<?php

namespace Resrequest\Application\Chart\FusionCharts;

use Resrequest\Application\Chart\Chart;

class Doughnut2D extends Chart
{
    public $library = "FusionCharts";
    public $type = "doughnut2D";

    protected $accumulator = [
        'data' => []
    ];

    public function processData($accumulator, $data, $mapping)
    {
       $chartData = &$accumulator['data'];

       foreach ($data as $element) {
            $label = $element[$mapping['label']];
            $value = $element[$mapping['value']];

            // Exclude 0 and negative values
            if (!$value <= 0) {
                $chartData[] = [
                    'label' => $label,
                    'value' => $value
                ];
            }
       }

        return $accumulator;
    }

    public function finaliseData($processedData)
    {
        $dataStructure = [
            'data' => []
        ];

        $dataStructure['data'] = $processedData['data'];

        return $dataStructure;
    }

    public function validateData($accumulator)
    {
        if (empty($accumulator['data'])) {
            return false;
        } else {
            return true;
        }
    }
}
