<?php
namespace Resrequest\Application\Chart\FusionCharts;

use Resrequest\Application\Chart\Chart;

class Heatmap extends Chart {
    public $library = "FusionCharts";
    public $type = "heatmap";

    protected $accumulator = [
        'rows' => [],
        'columns' => [],
        'data' => []
    ];

    public function processData($accumulator, $data, $mapping)
    {
        $rows = &$accumulator['rows'];
        $columns = &$accumulator['columns'];
        $chartData = &$accumulator['data'];

        $columnLabel = $mapping['column']['staticLabel'];
        
        // TMP fix to missing columns when no data in dataset
        $columns[] = [
            'id' => (string)sizeof($columns),
            'label' => $columnLabel,
        ];

        foreach ($data as $element) {
            $value = $element[$mapping['value']];
            $rowLabel = $element[$mapping['row']['dynamicLabel']];
            $columnLabel = $mapping['column']['staticLabel'];

            // Add rows
            if (in_array($rowLabel, array_column($rows, 'label'))) {
                $rowKey = array_search($rowLabel, array_column($rows, 'label'));
            } else {
                $rows[] = [
                    'id' => (string)sizeof($rows),
                    'label' => $rowLabel,
                ];

                // Get key of inserted row
                end($rows);
                $rowKey = key($rows);
            }

            // Add columns
            if (in_array($columnLabel, array_column($columns, 'label'))) {
                $columnKey = array_search($columnLabel, array_column($columns, 'label'));
            } else {
                $columns[] = [
                    'id' => (string)sizeof($columns),
                    'label' => $columnLabel,
                ];

                // Get key of inserted row
                end($columns);
                $columnKey = key($columns);
            }

            $chartData[] = [
                'rowid' => (string)$rowKey,
                'columnid' => (string)$columnKey,
                'value' => (string)$value
            ];
        }

        return $accumulator; 
    }

    public function finaliseData($processedData)
    {
        $dataStructure = [
            'dataset' => [
                [
                    'data' => []
                ]
            ],
            'columns' => [
                'column' => []
            ],
            'rows' => [
                'row' => []
            ]
        ];
        
        $data = $processedData['data'];
        
        foreach ($processedData['columns'] as $column) {
            foreach($processedData['rows'] as $row) {
                // Check for missing data entries for the row and column combination
                $dataFound = false;
                foreach ($data as $element) {
                    $rowId = $element['rowid'];
                    $columnId = $element['columnid'];

                    // Data entry for row and column combination exists
                    if ($rowId == $row['id'] && $columnId == $column['id']) {
                        $dataFound = true;
                        break;
                    }
                }

                if (!$dataFound) {
                    $data[] = [
                        'rowid' => (string)$row['id'],
                        'columnid' => (string)$column['id'],
                        'value' => (string)0
                    ];
                }
            }
        }

        $highestValue = 0;
        foreach ($data as $element) {
            if ($element['value'] >= $highestValue) {
                $highestValue = (int) $element['value'];
            }
        }

        $dataStructure['rows']['row'] = $processedData['rows'];
        $dataStructure['columns']['column'] = $processedData['columns'];
        $dataStructure['dataset'][0]['data'] = $data;

        // If there is a color object with the maxvalue set to false
        // set it to the highest cell value
        if (!empty($this->config['library']['colorrange']['color'])) {
            foreach ($this->config['library']['colorrange']['color'] as &$colorConfig) {
                if (isset($colorConfig['maxvalue']) && $colorConfig['maxvalue'] === false) {
                    $colorConfig['maxvalue'] = $highestValue;
                }
            }
        }

        return $dataStructure;
    }

    public function validateData($accumulator)
    {
        if (empty($accumulator['data'])) {
            return false;
        } else {
            return true;
        }
    }

}