<?php

namespace Resrequest\Application\Chart\FusionCharts;

use Resrequest\Application\Chart\Chart;

class MsArea extends Chart
{
    public $library = "FusionCharts";
    public $type = "msArea";

    protected $accumulator = [
        'categories' => [],
        'dataset' => [],
        'trendlines' => [],
    ];

    private function addSeries(&$dataset, $seriesName, $config, $data = [])
    {
        // Check if series already exists
        if (!in_array($seriesName, array_column($dataset, 'seriesName'))) {
            $dataset[] = [
                'seriesName' => $seriesName,
                'data' => []
            ];

            // Get key of inserted series
            end($dataset);
            $seriesKey = key($dataset);

            if (!empty($config['config'])) {
                // Apply series configuration
                $dataset[$seriesKey] = array_merge($config['config'], $dataset[$seriesKey]);
            }

            // Apply dynamic config
            if (!empty($config['dynamicConfig']) &&!empty($data)) {
                $dynamicConfig = $config['dynamicConfig'];

                foreach ($dynamicConfig as $setting => &$value) {
                    // Overwrite field name with value from data
                    if (isset($data[$value])) {
                        $value = $data[$value];
                    } else {
                        // Remove the setting if there's no data for it
                        unset($dynamicConfig[$setting]);
                    }
                }
                $dataset[$seriesKey] = array_merge($dynamicConfig, $dataset[$seriesKey]);
            }
        }
    }

    public function processData($accumulator, $data, $mapping)
    {
        $categories = &$accumulator['categories'];
        $dataset = &$accumulator['dataset'];
        $trendlines = &$accumulator['trendlines'];

        // Add static series
        foreach ($mapping['series'] as $seriesMapping) {
            if (!isset($seriesMapping['dynamicSeriesName'])) {
                $seriesName = $seriesMapping['seriesName'];
                $this->addSeries($dataset, $seriesName, $seriesMapping);
            }
        }

        if (empty($data)) {
            return $accumulator;
        }

        foreach ($data as $element) {
            $categoryLabel = $element[$mapping['category']];

            // Check if category exists
            if (in_array($categoryLabel, array_column($categories, 'label'))) {
                $categoryKey = array_search($categoryLabel, array_column($categories, 'label'));
            } else {
                // Add new category
                $categories[] = [
                    'label' => $categoryLabel,
                ];

                // Get key of inserted category
                end($categories);
                $categoryKey = key($categories);
            }

            // Build chart series
            foreach ($mapping['series'] as $seriesMapping) {
                if (isset($seriesMapping['comparisonData'])) {
                    if ($element['comparisonData'] !== $seriesMapping['comparisonData']) {
                        continue;
                    }
                }

                // Add dynamic chart series
                if (isset($seriesMapping['dynamicSeriesName'])) {
                    $seriesName = $element[$seriesMapping['dynamicSeriesName']];
                    $this->addSeries($dataset, $seriesName, $seriesMapping, $element);
                } else {
                    $seriesName = $seriesMapping['seriesName'];
                }

                $value = $element[$seriesMapping['data']];

                $seriesKey = array_search($seriesName, array_column($dataset, 'seriesName'));

                $dataset[$seriesKey]['data'][$categoryKey] = [
                    'value' => $value
                ];
            }
        }

        // Build chart trendlines
        if (!empty($mapping['trendlines'])) {
            foreach ($mapping['trendlines'] as $trendlineMapping) {
                $startValue = $element[$trendlineMapping['startValue']];

                $trendline = [
                    'startValue' => $startValue,
                ];

                if (isset($trendlineMapping['endValue'])) {
                    $endValue = $element[$trendlineMapping['endValue']];
                    $trendline['endValue'] = $endValue;
                }

                $trendline = array_merge($trendline, $trendlineMapping['config']);
                $trendlines[]['line'][] = $trendline;
            }
        }

        return $accumulator;
    }

    public function finaliseData($accumulator)
    {
        $chartStructure = [
            'categories' => [
                [
                    'category' => []
                ]
            ],
            'dataset' => [],
            'trendlines' => []
        ];

        $dataset = &$accumulator['dataset'];

        foreach ($accumulator['categories'] as $categoryKey => $category) {
            foreach ($dataset as &$series) {
                if (!array_key_exists($categoryKey, $series['data'])) {
                    $series['data'][$categoryKey] = [
                        'value' => 0
                    ];
                }
                // Make sure array keys are in order, otherwise
                // json_encode will convert it to an object
                ksort($series['data']);
            }
        }

        $chartStructure['dataset'] = $accumulator['dataset'];
        $chartStructure['categories'][0]['category'] = $accumulator['categories'];
        $chartStructure['trendlines'] = $accumulator['trendlines'];

        return $chartStructure;
    }

    public function validateData($accumulator)
    {
        if (empty($accumulator['dataset']) || empty($accumulator['categories'])) {
            return false;
        } else {
            return true;
        }
    }
}
