<?php
namespace Resrequest\Application\Chart;

class Input
{
    protected $value;

    public function __construct($defaultValue = null)
    {
        if (!is_null($defaultValue)) {
            $this->setValue($defaultValue);
        }
    }

    public function setValue($value)
    {
        $this->value = $value;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function getConfig()
    {
        return [];
    }

    /**
     * Returns the input type
     *
     * @return string $inputType
     */
    public function type()
    {
        $tmp = explode('\\', get_called_class());
        $inputClass = end($tmp);
        $inputType = lcfirst($inputClass);

        return  $inputType;
    }
}