<?php

namespace Resrequest\Application\Chart\Input;

use Resrequest\Application\Chart\Input;

class AccommodationFilter extends Input
{
    protected $config = [];

    public function __construct()
    {
        parent::__construct([]);
    }

    public function getValue()
    {
        if (empty($this->value)) {
            $allAccommodationTypes = [];

            foreach ($this->config as $property) {
                foreach ($property['accommodations'] as $accommodation) {
                    $allAccommodationTypes[] = $accommodation['id'];
                } 
            }

            $this->value = $allAccommodationTypes;
        }
        return $this->value;
    }

    public function setConfig($config)
    {
        $this->config = $config;
    }

    public function getConfig()
    {
        return $this->config;
    }
}
