<?php

namespace Resrequest\Application\Chart\Input;

use Resrequest\Application\Chart\Input;

class CurrencyConversion extends Input
{
    protected $config = [
        'supportedCurrencies' => [],
    ];

    public function addSupportedCurrencies($currencies)
    {
        $this->config['supportedCurrencies'] = $currencies;
    }

    public function setValue($value)
    {
        if (
            array_key_exists('currencyTo', $value)
            && array_key_exists('rates', $value)
        ) {
            $this->value = $value;
        }
    }

    public function getConfig()
    {
        return $this->config;
    }
}
