<?php

namespace Resrequest\Application\Chart\Input;

use Resrequest\Application\Chart\Input;

class DateRange extends Input
{
    public function __construct($startDate = 'yesterday', $endDate = 'today') {
        $this->value = ['startDate' => $startDate, 'endDate' => $endDate];
    }

    public function getValue()
    {
        $startDate = new Date($this->value['startDate']);
        $endDate = new Date($this->value['endDate']);

        $date = [];
        $date['startDate'] = $startDate->getValue();
        $date['endDate'] = $endDate->getValue();

        $this->setValue($date);

        return $date;
    }
}
