<?php

namespace Resrequest\Application\Chart\Input;

use Resrequest\Application\Chart\Input;

class MultiSelect extends Input
{
    protected $searchLabel;
    protected $headerLabel;
    protected $options;
    protected $enableSearch;

    public function __construct($headerLabel = '', $enableSearch = false, $searchLabel = '', $options = [])
    {
        $this->searchLabel = $searchLabel;
        $this->headerLabel = $headerLabel;
        $this->enableSearch = $enableSearch;
        $this->options = $options;
    }

    public function setValue($value)
    {
        if (is_array($value)) {
            $optionValues = [];
            $this->value = [];

            foreach ($this->options as $option) {
                $optionValue = $option->toArray()['value'];
                $optionValues[] = $optionValue;
            }
            
            // Validate values
            foreach ($value as $item) {
                if (in_array($item, $optionValues)) {
                    $this->value[] = $item;
                }
            }
        }
    }

    public function setSearchLabel($searchLabel) {
        $this->searchLabel = $searchLabel;
    }

    public function setHeaderLabel($headerLabel) {
        $this->headerLabel = $headerLabel;
    }

    public function setOptions($options) {
        $this->options = $options;
    }

    public function showSearch(bool $enableSearch) {
        $this->enableSearch = $enableSearch;
    }

    public function getConfig()
    {
        $options = array_map(function($option) {
            return $option->toArray();
        }, $this->options);

        $config = [
            'searchLabel' => $this->searchLabel,
            'headerLabel' => $this->headerLabel,
            'enableSearch' => $this->enableSearch,
            'options' => $options
        ];

        return $config;
    }
}
