<?php

namespace Resrequest\Application\Chart\Input\Select;

class SelectOption
{
    /**
     * The name of the option.
     *
     * @var string
     */
    public $name;

    /**
     * The value of the option.
     *
     * @var string
     */
    public $value;

    /**
     * Whether the option is inactive or not.
     *
     * @var boolean
     */
    public $inactive;

    /**
     * Constructs a new select option.
     *
     * @param string $name The name of the option.
     * @param string $value The value of the option.
     * @param boolean $inactive Whether the option is inactive or not.
     */
    public function __construct($name, $value, $inactive)
    {
        $this->name = $name;
        $this->value = $value;
        $this->inactive = $inactive;
    }

    /**
     * The array representation of the option.
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name,
            'value' => $this->value,
            'inactive' => $this->inactive
        ];
    }
}