<?php

namespace Resrequest\Application\Chart;

use Resrequest\Application\Chart\Input;

class Option
{
    /**
     * Option name.
     *
     * @var string
     */
    public $name;

    /**
     * Instance of input class.
     *
     * @var Input
     */
    public $input;

    public function __construct($name, $input)
    {
        $this->name = $name;
        $this->input = $input;
    }

    public function setValue($value)
    {
        $this->input->setValue($value);
    }

    public function getName()
    {
        return $this->name;
    }

    public function getValue()
    {
        return $this->input->getValue();
    }

    public function toArray()
    {
        return [
            'name' => $this->name,
            'type' => $this->input->type(),
            'value' => $this->input->getValue(),
            'config' => $this->input->getConfig()
        ];
    }
}
