<?php

namespace Resrequest\Application\Chart;

class Registry
{
    const CONVERTERS = [
        'addition' => 'Resrequest\Application\Chart\Converter\Addition',
        'accumulator' => 'Resrequest\Application\Chart\Converter\Accumulator',
        'sortBy' => 'Resrequest\Application\Chart\Converter\SortBy',
        'currency' => 'Resrequest\Application\Chart\Converter\Currency',
        'mathExpression' => 'Resrequest\Application\Chart\Converter\MathExpression',
        'total' => 'Resrequest\Application\Chart\Converter\Total',
        'additionGroup' => 'Resrequest\Application\Chart\Converter\AdditionGroup',
        'dateFormat' => 'Resrequest\Application\Chart\Converter\DateFormat',
        'max' => 'Resrequest\Application\Chart\Converter\Max',
        'datasetRange' => 'Resrequest\Application\Chart\Converter\DatasetRange',
        'round' => 'Resrequest\Application\Chart\Converter\Round',
        'template' => 'Resrequest\Application\Chart\Converter\Template',
        'groupDistributor' => 'Resrequest\Application\Chart\Converter\GroupDistributor',
        'reservationCountry' => 'Resrequest\Application\Chart\Converter\ReservationCountry',
        'percentage' => 'Resrequest\Application\Chart\Converter\Percentage',
    ];

    const DATASETS = [
        'arrivalsWithoutFullPayment' => 'Resrequest\Application\Chart\Dataset\ArrivalsWithoutFullPayment',
        'bookingRevenue' => 'Resrequest\Application\Chart\Dataset\BookingRevenue',
        'consultantBookingsByStatus' => 'Resrequest\Application\Chart\Dataset\ConsultantBookingsByStatus',
        'consultantSalesPerformance' => 'Resrequest\Application\Chart\Dataset\ConsultantSalesPerformance',
        'consultantWorkload' => 'Resrequest\Application\Chart\Dataset\ConsultantWorkload',
        'provisionalsDueToExpire' => 'Resrequest\Application\Chart\Dataset\ProvisionalsDueToExpire',
        'waitlist' => 'Resrequest\Application\Chart\Dataset\Waitlist',
        'occupancy' => 'Resrequest\Application\Chart\Dataset\Occupancy',
    ];

    public static function hasConverter($converter)
    {
        return array_key_exists($converter, self::CONVERTERS);
    }

    public static function getConverterClass($converter)
    {
        if (array_key_exists($converter, self::CONVERTERS)) {
            return self::CONVERTERS[$converter];
        } else {
            throw new \Exception("Converter '$converter' does not exist");
        }
    }

    public static function hasDataset($dataset)
    {
        return array_key_exists($dataset, self::DATASETS);
    }

    public static function getDatasetClass($dataset)
    {
        if (array_key_exists($dataset, self::DATASETS)) {
            return self::DATASETS[$dataset];
        } else {
            throw new \Exception("Dataset '$dataset' does not exist");
        }
    }
}