<?php

namespace Resrequest\Application\Chart\Store;

class AsyncStore
{
    /**
     * Stores items by id. The value is a function that when run
     * produces the value.
     *
     * @var array
     */
    protected $items;

    /**
     * Create a new instance of the Async store.
     */
    public function __construct()
    {
        $this->items = [];
    }

    /**
     * Adds an item to the store.
     *
     * @param string $id The id of the item.
     * @param callable $callable The function to produce the value
     * @return void
     */
    public function addItem($id, $summary, $callable)
    {
        $this->items[$id] = [
            'summary' => $summary,
            'value' => $callable
        ];
    }

    /**
     * Whether the item exists in the store or not.
     *
     * @param string $id
     * @return boolean
     */
    public function hasItem($id)
    {
        return array_key_exists($id, $this->items);
    }

    /**
     * Retrieves the summary of the item.
     *
     * @param string $id
     * @return mixed
     */
    public function getItemSummary($id)
    {
        return $this->items[$id]['summary'];
    }

    /**
     * Retrieves the value of a stored item.
     *
     * @param string $id The id of the item.
     * @return mixed
     */
    public function getItemValue($id)
    {
        return call_user_func($this->items[$id]['value']);
    }
}