<?php

namespace Resrequest\Application\Chart\Store;

abstract class Chart
{
    /**
     * The id of the chart.
     *
     * @var string
     */
    protected $id = '';

    /**
     * The name of the chart.
     *
     * @var string
     */
    protected $name = '';

    /**
     * The description of the chart.
     *
     * @var string
     */
    protected $description = '';

    /**
     * The type of the chart.
     *
     * @var string
     */
    protected $chartClass = '';

    /**
     * The report info for the chart.
     *
     * @var string
     */
    protected $reportInfo = '';

    /**
     * The library that the chart uses.
     *
     * @var string
     */
    protected $library = '';

    /**
     * Returns the id of the chart.
     *
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Returns the configuration of the chart.
     *
     * @return array
     */
    public abstract function toArray();

    /**
     * Returns a callable function that when invoked provides
     * the configuration of the chart.
     *
     * @return callable
     */
    public function getAsyncConfigFunction()
    {
        return [$this, 'toArray'];
    }

    /**
     * Retrieves the summary of the chart.
     *
     * @return array
     */
    public function getSummary()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'chartClass' => $this->chartClass,
            'reportInfo' => $this->reportInfo,
            'library' => $this->library
        ];
    }
}