<?php

namespace Resrequest\Application\Chart\Store;

use Resrequest\Application\Chart\Store\Charts\AgentOverviewRevenue;
use Resrequest\Application\Chart\Store\Charts\ArrivalsByConsultantWithoutPayment;
use Resrequest\Application\Chart\Store\Charts\ArrivalsWithoutPayment;
use Resrequest\Application\Chart\Store\Charts\BusinessByCountry;
use Resrequest\Application\Chart\Store\Charts\ConsultantBookingsByArrival;
use Resrequest\Application\Chart\Store\Charts\ConvertibleWaitlists;
use Resrequest\Application\Chart\Store\Charts\ExpiringProvisionals;
use Resrequest\Application\Chart\Store\Charts\LostGainedSalesRevenue;
use Resrequest\Application\Chart\Store\Charts\NewBookingsByConsultants;
use Resrequest\Application\Chart\Store\Charts\NewBookingsPerformance;
use Resrequest\Application\Chart\Store\Charts\Occupancy;
use Resrequest\Application\Chart\Store\Charts\RevenueAccommodationCumulativeTwoYear;
use Resrequest\Application\Chart\Store\Charts\RevenueAccommodationThreeYear;
use Resrequest\Application\Chart\Store\Charts\RevenueYield;
use Resrequest\Application\Chart\Store\Charts\SalesThisTimeLastYear;

class ChartStore extends AsyncStore
{
    const CHARTS = [
        'arrivalsByConsultantWithoutPayment' => '11e9c41c91446fdc928e02399910d15e',
        'arrivalsWithoutPayment' => '11e9c46b31e53f5f928e02399910d15e',
        'consultantBookingsByArrival' => '11e9ad14ad08dddf90da02399910d15e',
        'convertibleWaitlists' => '11e9c46b3f592816928e02399910d15e',
        'expiringProvisionals' => '11e9c4556a79d3db928e02399910d15e',
        'newBookingsByConsultants' => '11ea0fa2a2e55ffe904c02399910d15e',
        'newBookingsPerformance' => '11e8439f3234ef708be40cc47a969e7c',
        'revenueYield' => '11ea31004cdfaf038fc802399910d15e',
        'revenueAccommodationThreeYear' => '11ea7ec64157287a989402399910d15e',
        'revenueAccommodationCumulativeTwoYear' => '11ea7f6e5e70b330973602399910d15e',
        'occupancy' => '11ea7f6e5e70b330973602366610d15e',
        'lostGainedSalesRevenue' => '11ea84e029d970eb952002399910d15e',
        'salesThisTimeLastYear' => '11ea85450f542779952002399910d15e',
        'agentOverviewRevenue' => '11ea31004cdfaf038fc802366610d15e',
        'businessByCountry' => '11e9ad14ad08dddf90da02366610d15e',
    ];

    public function __construct()
    {
        $this->addCharts();
    }

    /**
     * Adds a chart to the store.
     *
     * @param Chart $chart
     * @return void
     */
    protected function addChart($chart)
    {
        $this->addItem(
            $chart->getId(),
            $chart->getSummary(),
            $chart->getAsyncConfigFunction()
        );
    }

    /**
     * Retrieves chart IDs in the store
     *
     * @return $charts Array containing the IDs of charts in the store
     */
    public function getCharts()
    {
        $charts = [];
        foreach ($this::CHARTS as $id) {
            $charts[] = $id;
        }

        return $charts;
    }

    /**
     * Whether there is a config for the given chart.
     *
     * @param string $id
     * @return boolean
     */
    public function hasChart($id)
    {
        return $this->hasItem($id);
    }

    /**
     * Retrieves the summary of the chart.
     *
     * @param string $id
     * @return array
     */
    public function getChartSummary($id)
    {
        return $this->getItemSummary($id);
    }

    /**
     * Retrieves the config for a chart.
     *
     * @param string $id
     * @return array
     */
    public function getChartConfig($id)
    {
        return $this->getItemValue($id);
    }

    /**
     * Adds the available chart configs to the store.
     *
     * @return void
     */
    private function addCharts()
    {
        $this->addChart(new ArrivalsByConsultantWithoutPayment());
        $this->addChart(new ArrivalsWithoutPayment());
        $this->addChart(new ConsultantBookingsByArrival());
        $this->addChart(new ConvertibleWaitlists());
        $this->addChart(new ExpiringProvisionals());
        $this->addChart(new NewBookingsByConsultants());
        $this->addChart(new NewBookingsPerformance());
        $this->addChart(new RevenueYield());
        $this->addChart(new AgentOverviewRevenue());
        $this->addChart(new RevenueAccommodationThreeYear());
        $this->addChart(new RevenueAccommodationCumulativeTwoYear());
        $this->addChart(new LostGainedSalesRevenue());
        $this->addChart(new SalesThisTimeLastYear());
        $this->addChart(new Occupancy());
        $this->addChart(new BusinessByCountry());
    }

    /**
     * Gets the id of the chart by name.
     *
     * @param string $name
     * @return string
     */
    public static function chartIdByName($name)
    {
        if (array_key_exists($name, self::CHARTS)) {
            return self::CHARTS[$name];
        } else {
            throw new \Exception("Chart '$name' does not exist");
        }
    }
}