<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;

class ArrivalsByConsultantWithoutPayment extends Chart
{
    protected $id = '11e9c41c91446fdc928e02399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'Doughnut2D';
    protected $name = 'Arrivals by consultant without full payment';
    protected $description = "See payments on confirmed and valid provisional bookings (not expired provisionals) travelling today and in the next six days. This chart shows bookings where there is an outstanding amount on the total value of the booking. TBA bookings are included in the calculations and are considered unpaid, no matter how many receipts are recorded on the booking. Bookings that have a 0.00 total value are considered fully paid. Bookings that arrived today, are already checked in and have incurred direct guest charges at the property may skew the results for today's arrivals.";
    protected $reportInfo = "Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week. Set the Res filters > Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. Set Folio filters > Filter by amount owing to TBA, Unpaid and Part Paid. In the Select Data section group your results by Consultant and select the Reservation Count field for your results. Note: bookings with a 0.00 value are considered as fully paid on the chart; however the Financial Analysis report considers them as unpaid and fully paid, these bookings will need to be separated on the Financial Analysis report in order to balance with the chart.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Arrivals by consultant without full payment',
                'subcaption' => 'For today and the next six days',
                'decimals' => '0',
                'showPercentValues' => '0',
                'showValues' => '1',
                'theme' => 'fusion',
                'animation' => '1',
                'animationDuration' => '1',
                'captionAlignment' => 'center',
                'enableSmartLabels' => '1',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'outCnvBaseFontSize' => '12',
                'legendItemFontSize' => '13',
                'labelFontSize' => '12',
                'manageLabelOverflow' => '1',
                'showLegend' => '0'
            ],
        ];

        $mapping = [
            'label' => 'consultantName',
            'value' => 'bookingsWithoutFullPayment'
        ];

        $dataset = (new Dataset('arrivalsWithoutFullPayment'))
            ->addFilter(
                (new Filter('arrivalPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => 'today', 'endDate' => '+6 days']))
            );


        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}
