<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;

class ConsultantBookingsByArrival extends Chart
{
    protected $id = '11e9ad14ad08dddf90da02399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'ScrollStackedColumn2D';
    protected $name = 'Consultant bookings by arrival';
    protected $description = "This chart shows consultant workloads based on bookings due to arrive. The chart includes stock-holding bookings arriving 'This week' (today and in the next six days) and 'Future' bookings (bookings beyond this week). A booking is included in the results if the first arrival date for the booking falls within the date range and if bookings are confirmed or valid provisionals (valid means not-expired). The consultant is based on the allocated consultant, i.e. not the user who created the booking.";
    protected $reportInfo = "Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), set the Travel date range to Arrival for this week (or future weeks). Set the Status filter to Confirmed and Provisional, remember to select Exclude expired Provisionals. In the Select Data section group your results by Consultant and select the Reservation Count field for your results.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Consultant bookings by arrival',
                'subcaption' => 'Stock-holding bookings arriving from today',
                'yaxisname' => 'Bookings',
                'flatscrollbars' => '1',
                'scrollheight' => '12',
                'numvisibleplot' => '8',
                'showSum' => true,
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '11',
                'xAxisNameFontSize' => '11',
                'labelDisplay' => 'AUTO',
                'slantLabels' => '1',
            ],
        ];

        $mapping = [
            'category' => 'consultantName',
            'series' => [
                [
                    'seriesName' => 'This week',
                    'data' => 'currentAndFutureBookings',
                    'config' => [
                        'plottooltext' => '<b>$dataValue</b> bookings arriving this week allocated to $label',
                    ]
                ],
                [
                    'seriesName' => 'Future',
                    'data' => 'otherBookings',
                    'config' => [
                        'plottooltext' => '<b>$dataValue</b> future bookings allocated to $label',
                    ]
                ]
            ]
        ];

        $dataset = (new Dataset('consultantWorkload'))
            ->addFilter(
                (new Filter('accommodationAccess'))
                    ->addOption(new Option('disableAcl', false))
            );

        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}