<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;

class ConvertibleWaitlists extends Chart
{
    protected $id = '11e9c46b3f592816928e02399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'Heatmap';
    protected $name = 'Convertible waitlists';
    protected $description = "View consultant's waitlist bookings that can be converted to a stock-holding status i.e. where stock is available and is travelling in the next 30/60/90/120 days";
    protected $reportInfo = "How to see this information on a calendar: Scan the Availability Calendar for days holding Waitlists (a purple handler at the bottom right of each cell indicates the days and room types where waitlists are held). If stock is available, the cell showing the waitlist will not be red for that day / room).";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Convertible waitlists',
                'subcaption' => 'Travelling in the next 30/60/90/120 days',
                'plottooltext' => '<b>$value</b> convertible waitlist bookings for <b>$rowLabel</b> travelling in the next <b>$columnLabel</b>',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'xAxisNameFontSize' => '12',
                'xAxisNameFontColor' => '#666666',
                'labelFontSize' => '12',
                'labelDisplay' => 'AUTO',
                'showValues' => '1',
            ],
            'colorrange' => [
                'gradient' => '1',
                'minvalue' => '0',
                'code' => '#ffffff',
                'color' => [
                    [
                        'code' => '#c9252f',
                        'maxvalue' => false
                    ]
                ]
            ]
        ];

        $mapping1 = [
            'value' => 'convertibleWaitlistedReservations',
            'row' => [
                'dynamicLabel' => 'consultantName'
            ],
            'column' => [
                'staticLabel' => '30 days'
            ]
        ];

        $mapping2 = [
            'value' => 'convertibleWaitlistedReservations',
            'row' => [
                'dynamicLabel' => 'consultantName'
            ],
            'column' => [
                'staticLabel' => '60 days'
            ]
        ];

        $mapping3 = [
            'value' => 'convertibleWaitlistedReservations',
            'row' => [
                'dynamicLabel' => 'consultantName'
            ],
            'column' => [
                'staticLabel' => '90 days'
            ]
        ];

        $mapping4 = [
            'value' => 'convertibleWaitlistedReservations',
            'row' => [
                'dynamicLabel' => 'consultantName'
            ],
            'column' => [
                'staticLabel' => '120 days'
            ]
        ];

        $dataset1 = (new Dataset('waitlist'))
            ->addFilter(
                (new Filter('arrivalPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => 'today', 'endDate' => '+29 days']))
            );

        $dataset2 = (new Dataset('waitlist'))
            ->addFilter(
                (new Filter('arrivalPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '+30 days', 'endDate' => '+59 days']))
            );

        $dataset3 = (new Dataset('waitlist'))
            ->addFilter(
                (new Filter('arrivalPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '+60 days', 'endDate' => '+89 days']))
            );

        $dataset4 = (new Dataset('waitlist'))
            ->addFilter(
                (new Filter('arrivalPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '+90 days', 'endDate' => '+120 days']))
            );

        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMappings([
                $mapping1,
                $mapping2,
                $mapping3,
                $mapping4
            ])
            ->addDatasets([
                $dataset1,
                $dataset2,
                $dataset3,
                $dataset4,
            ])
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}
