<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;

class ExpiringProvisionals extends Chart
{
    protected $id = '11e9c4556a79d3db928e02399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'Doughnut2D';
    protected $name = 'Provisionals due to expire';
    protected $description = "All provisional bookings grouped by consultant that will expire this week, i.e. that will expire today and in the next six days.";
    protected $reportInfo = "How to generate this data using a report: Use the Provisional Expiry report. Select the Date range to Today and for the next six days. Set the Consultant filter and generate the report as a List.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Provisionals due to expire',
                'subcaption' => 'For today and the next six days',
                'animation' => '1',
                'animationDuration' => '1',
                'decimals' => '0',
                'showPercentValues' => '0',
                'showValues' => '1',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'enableSmartLabels' => '1',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'outCnvBaseFontSize' => '12',
                'legendItemFontSize' => '13',
                'labelFontSize' => '12',
                'manageLabelOverflow' => '1',
                'showLegend' => '0'
            ]
        ];

        $mapping = [
            'label' => 'consultantName',
            'value' => 'provisionalsDueToExpire'
        ];

        $dataset = (new Dataset('provisionalsDueToExpire'))
            ->addFilter(
                (new Filter('provisionalExpiryPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => 'today', 'endDate' => '+6 days']))
            );

        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}
