<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;
use Resrequest\Application\Chart\Config\Converter;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\DatasetOption;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\InputMapping;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\OutputMapping;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\UiOption;
use Resrequest\Application\Chart\Config\UiPage;
use Resrequest\Application\Chart\Config\UiPageSection;
use Resrequest\Application\Chart\Config\UiSection;
use Resrequest\Application\Chart\Config\UiSubOption;

class LostGainedSalesRevenue extends Chart
{
    protected $id = '11ea84e029d970eb952002399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'msSpline';
    protected $name = 'New & lost sales';
    protected $description = 'This chart shows lost revenue, by travel month, for bookings that were changed to non-stock holding in the specified sales period and revenue gained where bookings were created or changed to a stock-holding status, in the specified sales period. Non-stock holding status’ are: waitlist, cancelled, quotation and deleted. Stock-holding status’ are: confirmed & provisional.';
    protected $reportInfo = '';

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'New & Lost Sales',
                'subcaption' => 'Revenue changes during a specified period',
                'xAxisName' => 'Month',
                'yAxisName' => 'Revenue',
                'sYAxisName' => 'Yield',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '12',
                'xAxisNameFontSize' => '12',
                'formatNumber' => '1',
                'formatNumberScale' => '0',
                'minimizeTendency' => '1',
            ]
        ];

        $mapping = [
            'category' => 'date',
            'series' => [
                [
                    'seriesName' => 'Revenue Gained ({{thisYear}})',
                    'data' => 'revenueGained',
                    'comparisonData' => '0',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue gained</b> in $label this year',
                        'color' => '#3364b5'
                    ]
                ],
                [
                    'seriesName' => 'Revenue Gained ({{lastYear}})',
                    'data' => 'revenueGained',
                    'comparisonData' => '1',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue gained</b> in $label last year',
                        'color' => '#b37478'
                    ]
                ],
                [
                    'seriesName' => 'Revenue Lost ({{thisYear}})',
                    'data' => 'revenueLost',
                    'comparisonData' => '0',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue lost</b> in $label this year',
                        'color' => '#C9252F',
                        'dashed' => true
                    ]
                ],
                [
                    'seriesName' => 'Revenue Lost ({{lastYear}})',
                    'data' => 'revenueLost',
                    'comparisonData' => '1',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue lost</b> in $label last year',
                        'color' => '#cacaca',
                        'dashed' => true
                    ]
                ]
            ]
        ];

        $libraryConfig['annotations'] = [
            'autoscale' => '1',
            'groups' =>
            [
                [
                    'items' =>
                    [
                        [
                            'id' => 'currency-rectangle',
                            'type' => 'rectangle',
                            'radius' => '3',
                            'x' => '10',
                            'y' => '10',
                            'tox' => '80',
                            'toy' => '40',
                            'color' => '#c9c9c9',
                            'alpha' => '70',
                            'origW' => '150',
                            'origH' => '300',
                        ],
                        [
                            'id' => 'currency-text',
                            'type' => 'text',
                            'fillcolor' => '#ffffff',
                            'fontsize' => '10',
                            'x' => '45',
                            'y' => '27',
                            'text' => '{{invoiceCurrency}}',
                            'origW' => '150',
                            'origH' => '300',
                        ],
                    ],
                ],
            ],
        ];

        $dateRange = [
            'startDate' => 'First day of January this year',
            'endDate' => 'Last day of December this year'
        ];

        $compareDateRange = [
            'startDate' => 'First day of January last year',
            'endDate' => 'Last day of December last year'
        ];

        $saleLostGainedDateRange = [
            'startDate' => 'First day of this month',
            'endDate' => 'today'
        ];

        $c1SaleLostGainedDateRange = [
            'startDate' => 'First day of this month last year',
            'endDate' => 'today last year'
        ];

        $dataset = (new Dataset('bookingRevenue'))
            ->addFilters([
                new Filter('rateType', 'rateType'),
                new Filter('rateComponent', 'rateComponent'),
                (new Filter('accommodationAccess', 'accommodationAccess'))
                    ->addOption(new Option('disableAcl', false)),
                (new Filter('reservationStatus', 'reservationStatus'))
                    ->addOption(new Option('reservationStatuses')),
                (new Filter('dateRange', 'dateRange'))
                    ->addOption(new Option('dateRange', $dateRange)),
                (new Filter('compare1DateRange', 'compare1DateRange'))
                    ->addOption(new Option('dateRange', $compareDateRange)),
                (new Filter('saleLostGainedDateRange', 'saleLostGainedDateRange'))
                    ->addOption(new Option('dateRange', $saleLostGainedDateRange)),
                (new Filter('compare1SaleLostGainedDateRange', 'compare1SaleLostGainedDateRange'))
                    ->addOption(new Option('dateRange', $c1SaleLostGainedDateRange))
            ])
            ->addDatasetOptions([
                new DatasetOption('farByFolio', 'farByFolio'),
                new DatasetOption('excludeTba', 'excludeTba'),
                (new DatasetOption('commission', 'commission'))
                    ->addOption(new Option('commission', 'nett')),
                (new DatasetOption('includeAccommTax', 'includeAccommTax'))
                    ->addOption(new Option('includeAccommTax', false)),
                (new DatasetOption('calculateLostGainedRevenue', 'calculateLostGainedRevenue'))
                    ->addOption(new Option('calculateLostGainedRevenue', true)),
            ])
            ->addConverters(
                [
                    (new Converter('additionGroup', 'additionGroup'))
                        ->setSubType('additionGroup')
                        ->addInputMappings([
                            new InputMapping('groupBy', ['date', 'invoiceCurrency', 'comparisonData']),
                            new InputMapping('additionFields', ['revenueGained', 'revenueLost']),
                        ]),
                    (new Converter('currency', 'currency'))
                        ->setSubType('currency')
                        ->addInputMappings([
                            new InputMapping('amount', ['revenueGained', 'revenueLost']),
                            new InputMapping('currencyFrom', ['invoiceCurrency'])
                        ])
                        ->addOutputMappings([
                            new OutputMapping('currencyTo', 'invoiceCurrency'),
                            new OutputMapping('amount', [
                                'revenueGained' => 'revenueGained',
                                'revenueLost' => 'revenueLost',
                            ])
                        ]),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['date']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'date'),
                        ])
                        ->addOption(new Option('format', 'M')),
                    (new Converter('additionGroup', 'additionGroup'))
                        ->setSubType('additionGroup')
                        ->addInputMappings([
                            new InputMapping('groupBy', ['date', 'comparisonData']),
                            new InputMapping('additionFields', ['revenueGained', 'revenueLost']),
                        ]),
                    (new Converter('roundRevenueGained'))
                        ->setSubType('round')
                        ->addInputMapping(
                            new InputMapping(
                                'field',
                                [
                                    'revenueGained'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'revenueGained')
                        ),
                    (new Converter('roundRevenueLost'))
                        ->setSubType('round')
                        ->addInputMapping(
                            new InputMapping(
                                'field',
                                [
                                    'revenueLost'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'revenueLost')
                        ),
                    (new Converter('negateRevenueLost'))
                        ->setSubType('mathExpression')
                        ->addInputMapping(
                            new InputMapping(
                                'expressionFields',
                                [
                                    'revenueLost'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'revenueLost')
                        )
                        ->addOption(new Option('expression', ['-', 'revenueLost'])),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['date']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'monthNumber'),
                        ])
                        ->addOption(new Option('format', 'm')),
                    (new Converter('sortByDate', 'sortByDate'))
                        ->setSubType('sortBy')
                        ->addInputMappings([
                            new InputMapping('sortBy', ['monthNumber']),
                        ]),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['travelStartDate']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'thisYear'),
                        ])
                        ->addOption(new Option('format', 'Y')),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['c1TravelStartDate']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'lastYear'),
                        ])
                        ->addOption(new Option('format', 'Y')),
                ]
            );

        $basicPage = (new UiPage('Basic'))
            ->addSections([
                (new UiPageSection('Date When Sale Was Gained or Lost'))
                    ->addOption(
                        (new UiOption('saleLostGainedDateRange'))
                            ->addSubOption(new UiSubOption('dateRange', 'Sale Date Range'))
                    )
                    ->addOption(
                        (new UiOption('compare1SaleLostGainedDateRange'))
                            ->addSubOption(new UiSubOption('dateRange', 'Comparison Sale Date Range'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('currency'))
                            ->addSubOption(new UiSubOption('currency', 'Currency Conversion'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('accommodationAccess'))
                            ->addSubOption(new UiSubOption('accommodationTypes', 'Property & Accommodation Type'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('reservationStatus'))
                            ->addSubOption(new UiSubOption('reservationStatuses', 'Status'))
                    )
            ]);

        $financialsPage = (new UiPage('Financials'))
            ->addSections([
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('farByFolio'))
                            ->addSubOption(new UiSubOption('farByFolio', 'Revenue By'))
                    ),
            ]);

        $uiConfig = (new UiConfig())
            ->addSection(
                (new UiSection('Options'))
                    ->addPages([
                        $basicPage,
                        $financialsPage
                    ])
            );

        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return  $chart->toArray();
    }
}
