<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;

class NewBookingsByConsultants extends Chart
{
    protected $id = '11ea0fa2a2e55ffe904c02399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'ScrollStackedColumn2D';
    protected $name = 'New bookings created by consultants';
    protected $description = "Total new bookings created this past week (today and the previous six days), grouped by the user who created the booking and by status. The chart shows the name of the user who created the booking originally, i.e. not the consultant currently linked to the booking. This chart gives the team an idea of the volume of bookings created by different users. This week's performance is an overlay on the previous two weeks.";
    protected $reportInfo = "How to generate this data using a report: Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), in the Res filters set the Create date range to this week, set the Status filter to All and set the Created by filter to the respective consultant. Group your results by Status and select the Reservation Count field for your results.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'New bookings created by consultants',
                'subcaption' => 'Today and the past six days',
                'xAxisName' => 'Consultant',
                'yAxisName' => 'Bookings',
                'plottooltext' => '<b>$value $seriesName</b> bookings created by $label',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '11',
                'xAxisNameFontSize' => '11',
                'labelDisplay' => 'AUTO',
            ]
        ];

        $mapping = [
            'category' => 'consultantName',
            'series' => [
                [
                    'seriesName' => 'Waitlisted',
                    'data' => 'waitlisted'
                ],
                [
                    'seriesName' => 'Quotation',
                    'data' => 'quotation'
                ],
                [
                    'seriesName' => 'Provisional (valid)',
                    'data' => 'validProvisional'
                ],
                [
                    'seriesName' => 'Provisional (expired)',
                    'data' => 'expiredProvisional'
                ],
                [
                    'seriesName' => 'Confirmed',
                    'data' => 'confirmed'
                ],
                [
                    'seriesName' => 'Cancelled',
                    'data' => 'cancelled'
                ],
                [
                    'seriesName' => 'Deleted',
                    'data' => 'deleted'
                ]
            ]
        ];

        $dataset = (new Dataset('consultantBookingsByStatus'))
            ->addFilter(
                (new Filter('dateRecordedPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '-6 days', 'endDate' => 'today']))
            );

        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}
