<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;
use Resrequest\Application\Chart\Config\Converter;
use Resrequest\Application\Chart\Config\InputMapping;
use Resrequest\Application\Chart\Config\OutputMapping;

class NewBookingsPerformance extends Chart
{
    protected $id = '11e8439f3234ef708be40cc47a969e7c';
    protected $library = 'FusionCharts';
    protected $chartClass = 'MsArea';
    protected $name = 'New booking performance by consultant';
    protected $description = "Total new bookings created this past week (today and the previous six days), grouped by the user who created the booking and by status. The chart shows the name of the user who created the booking originally, i.e. not the consultant currently linked to the booking. This chart gives the team an idea of the volume of bookings created by different users. This week's performance is an overlay on the previous two weeks.";
    protected $reportInfo = "Use the Financial Analysis (Folio) report. Set the Folio date range to all (by selecting a date range that covers all bookings), in the Res filters set the Create date range to this week (or the previous week/s), set the Status filter to All and set the Created by filter to the respective consultant. In the Select Data section group your results by Status and select the Reservation Count field for your results.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'New booking performance by consultant',
                'subcaption' => 'Bookings created in the past 3 weeks',
                'xAxisName' => 'Consultant',
                'yAxisName' => 'Bookings',
                'plottooltext' => '<b>$value $seriesName</b> bookings allocated to $label',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '11',
                'xAxisNameFontSize' => '11',
                'labelDisplay' => 'STAGGER'
            ]
        ];

        $mapping1 = [
            'category' => 'consultantName',
            'series' => [
                [
                    'seriesName' => 'Last week',
                    'data' => 'consultantTotalBookings'
                ]
            ]
        ];

        $mapping2 = [
            'category' => 'consultantName',
            'series' => [
                [
                    'seriesName' => '2 weeks ago',
                    'data' => 'consultantTotalBookings'
                ]
            ]
        ];

        $mapping3 = [
            'category' => 'consultantName',
            'series' => [
                [
                    'seriesName' => '3 weeks ago',
                    'data' => 'consultantTotalBookings'
                ]
            ]
        ];

        $dataset1 = (new Dataset('consultantBookingsByStatus'))
            ->addFilter(
                (new Filter('dateRecordedPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '-6 days', 'endDate' => 'today']))
            )
            ->addConverter(
                (new Converter('addition'))
                    ->setSubType('addition')
                    ->addInputMapping(
                        new InputMapping(
                            'additionFields',
                            [
                                'quotation',
                                'waitlisted',
                                'validProvisional',
                                'expiredProvisional',
                                'cancelled',
                                'confirmed',
                                'deleted'
                            ]
                        )
                    )
                    ->addOutputMapping(
                        new OutputMapping('result', 'consultantTotalBookings')
                    )
            );

        $dataset2 = (new Dataset('consultantBookingsByStatus'))
            ->addFilter(
                (new Filter('dateRecordedPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '-13 days', 'endDate' => '-7 days']))
            )
            ->addConverter(
                (new Converter('addition'))
                    ->setSubType('addition')
                    ->addInputMapping(
                        new InputMapping(
                            'additionFields',
                            [
                                'quotation',
                                'waitlisted',
                                'validProvisional',
                                'expiredProvisional',
                                'cancelled',
                                'confirmed',
                                'deleted'
                            ]
                        )
                    )
                    ->addOutputMapping(
                        new OutputMapping('result', 'consultantTotalBookings')
                    )
            );

        $dataset3 = (new Dataset('consultantBookingsByStatus'))
            ->addFilter(
                (new Filter('dateRecordedPeriod'))
                    ->addOption(new Option('dateRange', ['startDate' => '-20 days', 'endDate' => '-14 days']))
            )
            ->addConverter(
                (new Converter('addition'))
                    ->setSubType('addition')
                    ->addInputMapping(
                        new InputMapping(
                            'additionFields',
                            [
                                'quotation',
                                'waitlisted',
                                'validProvisional',
                                'expiredProvisional',
                                'cancelled',
                                'confirmed',
                                'deleted'
                            ]
                        )
                    )
                    ->addOutputMapping(
                        new OutputMapping('result', 'consultantTotalBookings')
                    )
            );


        $uiConfig = new UiConfig();
        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMappings([
                $mapping1,
                $mapping2,
                $mapping3
            ])
            ->addDatasets([
                $dataset1,
                $dataset2,
                $dataset3
            ])
            ->setUiConfig($uiConfig);

        return $chart->toArray();
    }
}
