<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;
use Resrequest\Application\Chart\Config\Converter;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\DatasetOption;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\InputMapping;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\OutputMapping;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\UiOption;
use Resrequest\Application\Chart\Config\UiPage;
use Resrequest\Application\Chart\Config\UiPageSection;
use Resrequest\Application\Chart\Config\UiSection;
use Resrequest\Application\Chart\Config\UiSubOption;

class Occupancy extends Chart
{
    protected $id = '11ea7f6e5e70b330973602366610d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'scrollCombiDY2D';
    protected $name = 'Accomodation occupancy';
    protected $description = 'The Occupancy report shows three series: 1. The total number of rooms (or bed nights) allocated to bookings compared with the total rooms available in that period. 2. The % of total rooms (or bed nights) compared with the total rooms (or bed nights) available this year, by month. 3. The % of total rooms (or bed nights) compared with the total rooms (or bed nights) available last year, by month.';
    protected $reportInfo = "Use the Financial Analysis By Day report. Set the report's filters to match the chart's filters for last year and this year. Set the Res filters > Status filter to the same statuses as the chart and select ‘Exclude expired provisionals‘. From the ‘Select data’ section include ‘Bed nights’ or ‘Room nights’ (depending on the chart filters) and select ‘BN % of potential / group / period’ or ‘RN % of potential / group / period’. From ‘Display options’ select ‘Include totals per month’.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Accomodation Occupancy',
                'subcaption' => 'Achieved vs potential occupancy by room or bed night',
                'xAxisName' => 'Month',
                'yAxisName' => '{{selectedDataLabel}}',
                'sYAxisName' => 'Occupancy %',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '12',
                'xAxisNameFontSize' => '12'
            ]
        ];

        $mapping = [
            'category' => 'month',
            'series' => [
                [
                    'seriesName' => 'Total {{selectedDataLabelLowerCase}}',
                    'data' => 'selectedTotal',
                    'config' => [
                        'plottooltext' => '<b>$value total {{selectedDataLabelLowerCase}}</b> in $label',
                        'color' => '#cacaca',
                        'renderAs' => 'area',
                    ]
                ],
                [
                    'seriesName' => 'Occupied {{selectedDataLabelLowerCase}}',
                    'data' => 'selectedOccupied',
                    'config' => [
                        'plottooltext' => '<b>$value {{selectedDataLabelLowerCase}} occupied</b> in $label',
                        'color' => '#3364b5',
                        'renderAs' => 'area',
                    ]
                ],
                [
                    'seriesName' => 'Occupancy % (this year)',
                    'data' => 'occupancyPercentage',
                    'config' => [
                        'plottooltext' => '<b>$value% occupancy</b> in $label',
                        'color' => '#C9252F',
                        'renderAs' => 'line',
                        'parentYAxis' => 'S',
                        'dashed' => 1,
                    ]
                ],
                [
                    'seriesName' => 'Occupancy % (last year)',
                    'data' => 'c1OccupancyPercentage',
                    'config' => [
                        'plottooltext' => '<b>$value% occupancy</b> in $label last year',
                        'color' => '#41857b',
                        'renderAs' => 'line',
                        'parentYAxis' => 'S',
                        'dashed' => 1,
                        'lineThickness' => 3,
                        'lineDashLen' => 1
                    ]
                ]
            ]
        ];

        $dateRange = [
            'startDate' => 'First day of January this year',
            'endDate' => 'Last day of December this year'
        ];

        $dataset = (new Dataset('occupancy'))
            ->addDatasetOptions([
                (new DatasetOption('selectData', 'selectData'))
                    ->addOption(new Option('selectData', 'rooms')),
                (new Filter('reservationStatus', 'reservationStatus'))
                    ->addOption(new Option('reservationStatuses', ['confirmed', 'provisionalValid'])),

            ])
            ->addFilters([
                (new Filter('accommodationAccess', 'accommodationAccess'))
                    ->addOption(new Option('disableAcl', false)),
                (new Filter('dateRange', 'dateRange'))
                    ->addOption(new Option('dateRange', $dateRange)),
            ])
            ->addConverters(
                [
                    (new Converter('additionGroup', 'additionGroup'))
                        ->setSubType('additionGroup')
                        ->addInputMappings([
                            new InputMapping('groupBy', ['month']),
                            new InputMapping('additionFields', [
                                'selectedTotal',
                                'selectedOccupied',
                                'c1SelectedTotal',
                                'c1SelectedOccupied',
                            ]),
                        ]),
                    (new Converter('occupancyPercentage'))
                        ->setSubType('percentage')
                        ->addInputMappings(
                            [
                                new InputMapping('numerator', 'selectedOccupied'),
                                new InputMapping('denominator', 'selectedTotal')
                            ]
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'occupancyPercentage')
                        ),
                    (new Converter('c1OccupancyPercentage'))
                        ->setSubType('percentage')
                        ->addInputMappings(
                            [
                                new InputMapping('numerator', 'c1SelectedOccupied'),
                                new InputMapping('denominator', 'c1SelectedTotal')
                            ]
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'c1OccupancyPercentage')
                        ),
                    (new Converter('roundOccupancyPercentage'))
                        ->setSubType('round')
                        ->addInputMapping(
                            new InputMapping(
                                'field',
                                [
                                    'occupancyPercentage'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'occupancyPercentage')
                        ),
                    (new Converter('c1RoundOccupancyPercentage'))
                        ->setSubType('round')
                        ->addInputMapping(
                            new InputMapping(
                                'field',
                                [
                                    'c1OccupancyPercentage'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'c1OccupancyPercentage')
                        ),
                ]
            );

        $basicPage = (new UiPage('Basic'))
            ->addSections([
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('selectData'))
                            ->addSubOption(new UiSubOption('selectData', 'Display Occupancy As'))
                    )
                    ->addOption(
                        (new UiOption('accommodationAccess'))
                            ->addSubOption(new UiSubOption('accommodationTypes', 'Property & Accommodation Type'))
                    )
                    ->addOption(
                        (new UiOption('reservationStatus'))
                            ->addSubOption(new UiSubOption('reservationStatuses', 'Status'))
                    ),
            ]);

        $uiConfig = (new UiConfig())
            ->addSection(
                (new UiSection('Options'))
                    ->addPages([
                        $basicPage,
                    ])
            );


        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return  $chart->toArray();
    }
}
