<?php

namespace Resrequest\Application\Chart\Store\Charts;

use Resrequest\Application\Chart\Store\Chart;
use Resrequest\Application\Chart\Config\Chart as ChartConfig;
use Resrequest\Application\Chart\Config\Converter;
use Resrequest\Application\Chart\Config\Dataset;
use Resrequest\Application\Chart\Config\DatasetOption;
use Resrequest\Application\Chart\Config\Filter;
use Resrequest\Application\Chart\Config\InputMapping;
use Resrequest\Application\Chart\Config\Option;
use Resrequest\Application\Chart\Config\OutputMapping;
use Resrequest\Application\Chart\Config\UiConfig;
use Resrequest\Application\Chart\Config\UiOption;
use Resrequest\Application\Chart\Config\UiPage;
use Resrequest\Application\Chart\Config\UiPageSection;
use Resrequest\Application\Chart\Config\UiSection;
use Resrequest\Application\Chart\Config\UiSubOption;

class RevenueAccommodationThreeYear extends Chart
{
    protected $id = '11ea7ec64157287a989402399910d15e';
    protected $library = 'FusionCharts';
    protected $chartClass = 'msSpline';
    protected $name = 'Accommodation revenue';
    protected $description = "This chart compares revenue for this year, last year and the coming year (next year). If you work with multiple currencies the chart will default to the internal user default rate type currency. To include other currencies, set the exchange rate in chart options.";
    protected $reportInfo = "Use the Financial Analysis report (use the Folio or Day report depending on the chart's filters). Set the report's filters to match the chart's filters. Include Revenue Accommodation as a report field (in Select data option). Set the Display options to include totals by month.";

    public function toArray()
    {
        $libraryConfig = [
            'chart' => [
                'caption' => 'Accommodation Revenue',
                'subcaption' => 'Revenue for 3 concurrent years',
                'xAxisName' => 'Month',
                'yAxisName' => 'Revenue',
                'theme' => 'fusion',
                'captionAlignment' => 'center',
                'baseFont' => 'Helvetica',
                'legendItemFont' => 'Helvetica',
                'legendItemFontSize' => '13',
                'outCnvBaseFontSize' => '12',
                'xAxisNameFontSize' => '12',
                'formatNumber' => '1',
                'formatNumberScale' => '0',
                'minimizeTendency' => '1',
            ]
        ];

        $mapping = [
            'category' => 'date',
            'series' => [
                [
                    'seriesName' => 'This year ({{year}})',
                    'data' => 'revenue',
                    'comparisonData' => '0',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue</b> in $label',
                        'color' => '#3364b5',
                        'linethickness' => 4
                    ]
                ],
                [
                    'seriesName' => 'Last year ({{c1Year}})',
                    'data' => 'revenue',
                    'comparisonData' => '1',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue</b> in $label $seriesName',
                        'color' => '#cacaca',
                        'linethickness' => 4,
                        'lineDashLen' => 1,
                        'dashed' => 1,
                    ]
                ],
                [
                    'seriesName' => 'Next year ({{c2Year}})',
                    'data' => 'revenue',
                    'comparisonData' => '2',
                    'config' => [
                        'plottooltext' => '<b>$dataValue {{invoiceCurrency}} revenue</b> in $label $seriesName',
                        'color' => '#C9252F',
                        'linethickness' => 3,
                        'dashed' => 1,
                    ]
                ],
            ]
        ];

        $libraryConfig['annotations'] = [
            'autoscale' => '1',
            'groups' =>
            [
                [
                    'items' =>
                    [
                        [
                            'id' => 'currency-rectangle',
                            'type' => 'rectangle',
                            'radius' => '3',
                            'x' => '10',
                            'y' => '10',
                            'tox' => '80',
                            'toy' => '40',
                            'color' => '#c9c9c9',
                            'alpha' => '70',
                            'origW' => '150',
                            'origH' => '300',
                        ],
                        [
                            'id' => 'currency-text',
                            'type' => 'text',
                            'fillcolor' => '#ffffff',
                            'fontsize' => '10',
                            'x' => '45',
                            'y' => '27',
                            'text' => '{{invoiceCurrency}}',
                            'origW' => '150',
                            'origH' => '300',
                        ],
                    ],
                ],
            ],
        ];

        $thisYear = [
            'startDate' => 'First day of January this year',
            'endDate' => 'Last day of December this year'
        ];

        $lastYear = [
            'startDate' => 'First day of January last year',
            'endDate' => 'Last day of December last year'
        ];

        $nextYear = [
            'startDate' => 'First day of January next year',
            'endDate' => 'Last day of December next year'
        ];

        $dataset = (new Dataset('bookingRevenue'))
            ->addFilters([
                new Filter('rateType', 'rateType'),
                new Filter('rateComponent', 'rateComponent'),
                (new Filter('accommodationAccess', 'accommodationAccess'))
                    ->addOption(new Option('disableAcl', false)),
                (new Filter('reservationStatus', 'reservationStatus'))
                    ->addOption(new Option('reservationStatuses', ['confirmed', 'provisionalValid'])),
                (new Filter('dateRange', 'dateRange'))
                    ->addOption(new Option('dateRange', $thisYear)),
                (new Filter('compare1DateRange', 'compare1DateRange'))
                    ->addOption(new Option('dateRange', $lastYear)),
                (new Filter('compare2DateRange', 'compare2DateRange'))
                    ->addOption(new Option('dateRange', $nextYear))
            ])
            ->addDatasetOptions([
                new DatasetOption('farByFolio', 'farByFolio'),
                new DatasetOption('excludeTba', 'excludeTba'),
                (new DatasetOption('commission', 'commission'))
                    ->addOption(new Option('commission', 'nett')),
                (new DatasetOption('includeAccommTax', 'includeAccommTax'))
                    ->addOption(new Option('includeAccommTax', false)),
            ])
            ->addConverters(
                [
                    (new Converter('additionGroup', 'additionGroup'))
                        ->setSubType('additionGroup')
                        ->addInputMappings([
                            new InputMapping('groupBy', ['date', 'invoiceCurrency', 'comparisonData']),
                            new InputMapping('additionFields', ['revenue']),
                        ]),
                    (new Converter('currency', 'currency'))
                        ->setSubType('currency')
                        ->addInputMappings([
                            new InputMapping('amount', ['revenue']),
                            new InputMapping('currencyFrom', ['invoiceCurrency'])
                        ])
                        ->addOutputMappings([
                            new OutputMapping('currencyTo', 'invoiceCurrency'),
                            new OutputMapping('amount', [
                                'revenue' => 'revenue',
                            ])
                        ]),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['date']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'date'),
                        ])
                        ->addOption(new Option('format', 'M')),
                    (new Converter('additionGroup', 'additionGroup2'))
                        ->setSubType('additionGroup')
                        ->addInputMappings([
                            new InputMapping('groupBy', ['date', 'comparisonData']),
                            new InputMapping('additionFields', ['revenue']),
                        ]),
                    (new Converter('roundRevenue'))
                        ->setSubType('round')
                        ->addInputMapping(
                            new InputMapping(
                                'field',
                                [
                                    'revenue'
                                ]
                            )
                        )
                        ->addOutputMapping(
                            new OutputMapping('result', 'revenue')
                        ),
                    (new Converter('dateFormat', 'dateFormat'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['date']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'monthNumber'),
                        ])
                        ->addOption(new Option('format', 'm')),
                    (new Converter('sortByDate', 'sortByDate'))
                        ->setSubType('sortBy')
                        ->addInputMappings([
                            new InputMapping('sortBy', ['monthNumber']),
                        ]),
                    (new Converter('dateFormat', 'dateFormat2'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['travelStartDate']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'year'),
                        ])
                        ->addOption(new Option('format', 'Y')),
                    (new Converter('dateFormat', 'dateFormat3'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['c1TravelStartDate']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'c1Year'),
                        ])
                        ->addOption(new Option('format', 'Y')),
                    (new Converter('dateFormat', 'dateFormat3'))
                        ->setSubType('dateFormat')
                        ->addInputMappings([
                            new InputMapping('date', ['c2TravelStartDate']),
                        ])
                        ->addOutputMappings([
                            new OutputMapping('date', 'c2Year'),
                        ])
                        ->addOption(new Option('format', 'Y')),
                ]
            );

        $basicPage = (new UiPage('Basic'))
            ->addSections([
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('currency'))
                            ->addSubOption(new UiSubOption('currency', 'Currency Conversion'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('accommodationAccess'))
                            ->addSubOption(new UiSubOption('accommodationTypes', 'Property & Accommodation Type'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('reservationStatus'))
                            ->addSubOption(new UiSubOption('reservationStatuses', 'Status'))
                    )
            ]);

        $financialsPage = (new UiPage('Financials'))
            ->addSections([
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('farByFolio'))
                            ->addSubOption(new UiSubOption('farByFolio', 'Revenue By'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('includeAccommTax'))
                            ->addSubOption(new UiSubOption('includeAccommTax', 'Tax'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('commission'))
                            ->addSubOption(new UiSubOption('commission', 'Commission'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('rateComponent'))
                            ->addSubOption(new UiSubOption('components', 'Rate Components'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('rateType'))
                            ->addSubOption(new UiSubOption('rates', 'Rate Types'))
                    ),
                (new UiPageSection(''))
                    ->addOption(
                        (new UiOption('excludeTba'))
                            ->addSubOption(new UiSubOption('excludeTba'))
                    )
            ]);

        $uiConfig = (new UiConfig())
            ->addSection(
                (new UiSection('Options'))
                    ->addPages([
                        $basicPage,
                        $financialsPage
                    ])
            );

        $chart = (new ChartConfig())
            ->setId($this->id)
            ->setLibrary($this->library)
            ->setLibaryConfig($libraryConfig)
            ->setChartClass($this->chartClass)
            ->setName($this->name)
            ->setDescription($this->description)
            ->setReportInfo($this->reportInfo)
            ->addMapping($mapping)
            ->addDataset($dataset)
            ->setUiConfig($uiConfig);

        return  $chart->toArray();
    }
}
