<?php

namespace Resrequest\Application\Chart\Store;

class GridsterItem
{
    /**
     * The chart to display in this Gridster item;
     *
     * @var array
     */
    protected $chart;

    /**
     * Creates a new container instance.
     *
     * @param string $id The id of the container.
     * @param array $charts The charts contained in the container.
     */
    public function __construct($chart, $x, $y, $rows, $cols, $config = [])
    {
        $this->chart = $chart;

        $config = array_merge($config, ['x' => $x, 'y' => $y, 'rows' => $rows, 'cols' => $cols]);

        $this->config = $config;
    }

    public function getChart() {
        return $this->chart;
    }

    /**
     * The array representation of the container.
     *
     * @return array
     */
    public function toArray()
    {
        return $this->config;
    }
}