<?php

namespace Resrequest\Application\Stock;

class Stock {
    protected $stock;

    public function __construct(
        $aAccommTypeId,
        $aStartDate = "0000-00-00",
        $aEndDate = "0000-00-00",
        $aOverrideAgent = false,
        $aAgentFilter = false,
        $aExpiredAllocation = false,
        $aExcludeItemFilter = false,
        $aExcludeBlockFilter = false,
        $aAllocationFilter = false,
        $aCache = true
    )
    {
        require_once(__DIR__ . '/../../legacy/class.stock.php');
        $this->stock = new \Stock(
            $aAccommTypeId,
            $aStartDate,
            $aEndDate,
            $aOverrideAgent,
            $aAgentFilter,
            $aExpiredAllocation,
            $aExcludeItemFilter,
            $aExcludeBlockFilter,
            $aAllocationFilter,
            $aCache
        );
    }

    public function __call($function, $arguments) {
        return call_user_func_array([$this->stock, $function], $arguments);
    }
}