<?php
	/* Functions in this file */
	/**************************/

	// Footer()
	// Header()
	// PDF($pdfTitle)
	define('FPDF_FONTPATH', '/font/');
	require(__DIR__ . '/fpdf.php');
	class PDF extends FPDF {
		var $title;
		var $footer;
		function __construct($pdfTitle,$orientation='P',$unit='mm',$format='A4',$footer=true) {
			parent::__construct($orientation,$unit,$format);
			$this->footer = $footer;
			$this->Open();
			$this->SetFont('Arial', '', 6);
			$this->SetTextColor(0);
			//$this->SetFillColor(0xD0, 0xD0, 0xC8);
			//$this->SetFillColor(0xE0, 0xE0, 0xD8);
			$this->SetFillColor(0xF0, 0xF0, 0xE8);
			$this->AliasNbPages("!totalPage!");
			if (trim($pdfTitle) != "") {
				$this->title = $pdfTitle;
			}/* else {
				$this->title = "Untitled";
			}*/
			$this->AddPage();
			if($GLOBALS['system'] == "training") {
				$logoY = $this->y;
				$pic = $this->_parsejpg(__DIR__ . "/../../../../public/img/training.jpg");
				if ($pic['w'] > $this->GetPageWidth(1)/4) {
					$pic['w'] = $this->GetPageWidth(1)/4;
				}
				$finalH = $this->Image(__DIR__ . "/../../../../public/img/training.jpg", ($this->GetPageWidth(1)/2)-($pic['w']/2), $logoY, $pic['w']);
			}
			//debug($GLOBALS['system']);
		}
		function ReportHeader($reportName, $itemArray) {
			if ($this->title == "Untitled") {
				$this->title = $reportName;
			}
			$_fontFamily = $this->FontFamily;
			$_fontStyle = $this->FontStyle;
			$_fontSize = $this->FontSizePt;
			// Main PDF header
			$logoY = $this->y;
			$pic = $this->_parsejpg(__DIR__ . "/../../../../public/img/logo_rr_30h.jpg");
			if ($pic['w'] > $this->GetPageWidth(1)/8) {
				$pic['w'] = $this->GetPageWidth(1)/8;
			
			}
			$this->Row(array(array()));
			$server = trim($_SESSION['domain']);
			$firstN = trim($_SESSION['firstname']);
			$lastN = trim($_SESSION['lastname']);
			$this->SetFillColor(237,237,237); 
			$this->setDrawColor(237,237,237);     
			$this->Row(array(
				array('width'=>"13%", 'data'=>"Username", 'align' => "L", 'fill'=>1, 'style'=>"B", 'border'=>"LRT"),
				array('width'=>"auto", 'data'=>($firstN == ""?"":$firstN." ").$lastN, 'border'=>"LRT")
			));
			$this->Row(array(
				array('width'=>"13%", 'data'=>"Server", 'align'=>"L", 'fill'=>1, 'style'=>"B", 'border'=>"LR"),
				array('width'=>"auto", 'data'=>$server, 'border'=>"LR")
			), 0);
			$this->SetFillColor(221,221,221);
			$this->Row(array(array('width'=>"1%", 'fill'=>0)));
			$this->SetFillColor(237,237,237);
			$this->Row(array(
				array('width'=>"13%", 'data'=>"Report", 'align'=>"L", 'fill'=>1, 'style'=>"B", 'border'=>"LR"),
				array('width'=>"auto", 'data'=>$reportName, 'border'=>"LR")
			), 0);
			$this->SetFillColor(221,221,221);
			$this->Row(array(array('width'=>"1%", 'fill'=>0)));
			$this->SetFillColor(237,237,237);

			$this->Row(array(
				array('width'=>"13%", 'data'=>"Date Generated", 'align'=>"L", 'fill'=>1, 'style'=>"B", 'border'=>"LR"),
				array('width'=>"auto", 'data'=>chng_date(date("Y-m-d"),"-")." ".date("H:i:s"), 'border'=>"LR")
			), 0);
			$this->SetFillColor(221,221,221);
			$this->Row(array(array('width'=>"1%", 'fill'=>0)));
			$this->SetFillColor(237,237,237);
			
      
/*      $dateTime = explode(" ",$GLOBALS[lastupdate]);
			$this->Row(array(
			  array(width => "13%", data => "Last updated", align => "L", fill => 1, style => "B", border => "LR"),
				array(width => "35%", data => chng_date($GLOBALS[lastupdate],"-")." ".$dateTime[1], border => "LR")), 0);
			$this->SetFillColor(221,221,221);
			$this->Row(array(array(width => "1%", fill => 1)));
			$this->SetFillColor(0xD0, 0xD0, 0xC8);*/

			$dbCode = isset($GLOBALS['dbcode']) && !empty($GLOBALS['dbcode']) ? $GLOBALS['dbcode'] : "";
      
			$this->Row(array(
				array('width'=>"13%", 'data'=>"Environment", 'align'=>"L", 'fill'=>1, 'style'=>"B", 'border'=>"LR"),
				array('width'=>"auto", 'data'=>$dbCode, 'border'=>"LR")
			), 0);
			$this->SetFillColor(221,221,221);
			$this->Row(array(array('width'=>"1%", 'fill'=>0)));
			$this->SetFillColor(237,237,237);
      
			foreach($itemArray as $item) {
				$this->Row(array(
					array('width'=>"13%", 'data'=>$item['name'], 'align'=>"L", 'fill'=>1, 'style'=>"B", 'border'=>"LR"),
					array('width'=>"auto", 'data'=>$item['value'], 'border'=>"LR",)
				), 0);
				$this->SetFillColor(221,221,221);
				$this->Row(array(array('width'=>"1%", 'fill'=>0)));
				$this->SetFillColor(237,237,237);
			}
			$this->SetFillColor(221,221,221);
			$this->SetFont('Arial', '', 4);
			$this->Row(array(
				array('width'=>"0%", 'border'=>"T"),
				array('width'=>"12%", 'fill'=> 0),
				array('width'=>"auto", 'fill'=> 0),
			));
			$this->SetFillColor(237,237,237);
			$this->SetFont('Arial', '', 6);
			$this->Row(array(array()));
			$this->FontFamily = $_fontFamily;
			$this->FontStyle = $_fontStyle;
			$this->FontSizePt = $_fontSize;
		}
		function Header() {
			/*       //Arial bold 15
			$this->SetFont('Arial','I',8);
			//Calculate width of title and position
			$w=$this->GetStringWidth($this->title)+10;
			$this->SetX((210-$w)/2);
			//Title
			$this->Cell($w,9,$this->title,0,0,'C',0);
			//Line break
			$this->Ln(10);*/
			$this->Row(array(
				array('data' => $this->title, 'align'=>"L", 'style'=>"", 'size'=>"10")
			));
			$this->Ln(4);
		}
		function Footer() {
			if($this->footer) {
				//Position at 1.5 cm from bottom
				$this->SetY(-15);
				$this->SetFont('Arial', '', 8);
				//Page number and date of generation
				$this->Cell(0, 10, 'Page ' . $this->PageNo() . '/!totalPage!', 0, 0, 'C');
				$this->Ln(0);
				$this->Cell(0, 10, 'Date ' . date("d M Y"), 0, 0, 'R');	
				$this->Ln(0);
				$this->Cell(0, 10, 'Generated by www.resrequest.com', 0, 0, 'L');		
			}
		}
	}
