<?php
/*

Author's signature:

	--
	Hugh Bothwell     hugh_bothwell <email protected>     Kingston ON Canada
	v3.1 GCS/E/AT d- s+: a- C+++ L++>+++$ P+ E- W+++$ N++ K? w++ M PS+
	PE++ Y+ PGP+ t-- 5++ !X R+ tv b++++ DI+++ D-(++) G+ e(++) h-- r- y+
	-- 

URL Source:

	http://www.phpbuilder.com/lists/php-db/2003061/0334.php (IntToRoman)
	http://www.phpbuilder.com/lists/php-db/2003061/0345.php (RomanToInt)

Notes:

	* The encode can only handle numbers between 1 and 3999 
	  (numbers above 3999 need overlining)
	* The decode function can only decode 100% correct strings and
	  has no error checking
	* Moved the $RomanTable array into the RomanToInt function.
	  This isn't the best for performance but stops any global
	  variable issues
*/

function RomanDigit($dig, $one, $five, $ten) {
	switch($dig) {
		case 0: return "";
		case 1: return "$one";
		case 2: return "$one$one";
		case 3: return "$one$one$one";
		case 4: return "$one$five";
		case 5: return "$five";
		case 6: return "$five$one";
		case 7: return "$five$one$one";
		case 8: return "$five$one$one$one";
		case 9: return "$one$ten";
	}
}

function IntToRoman($num) {
	if (($num < 1) || ($num > 3999))
		return("No corresponding Roman number!");

	$m = floor($num / 1000);
	$c = floor(($num % 1000) / 100);
	$x = floor(($num % 100) / 10);
	$i = floor($num % 10);

	return (
		RomanDigit($m, 'M', '', '')
		.RomanDigit($c, 'C', 'D', 'M')
		.RomanDigit($x, 'X', 'L', 'C')
		.RomanDigit($i, 'I', 'V', 'X')
	);
} 



function MatchClause($needle, $haystack) {
	// These two tests are probably just paranoia,
	// but - hey, I'm paranoid. ;-)
	if (strlen($haystack) < 1)
		return false;
	if (strlen($haystack) < strlen($needle))
		return false;

	return( strncasecmp($needle, $haystack, strlen($needle)) == 0 );
}

function RemoveClause($needle, $haystack) {
	return( substr($haystack, strlen($needle)) );
}

function RomanToInt($str) {
	// NOTE: the order of the table is
	// important! I will use greedy parsing,
	// so (for example) IX and IV must precede
	// I to parse correctly.
	$RomanTable = array(
		"M" => 1000,
		"CM" => 900,
		"D" => 500,
		"CD" => 400,
		"C" => 100,
		"XC" => 90,
		"L" => 50,
		"XL" => 40,
		"X" => 10,
		"IX" => 9,
		"V" => 5,
		"IV" => 4,
		"I" => 1
	);
	$sum = 0;

	do {
		$done = true;

		foreach($RomanTable as $clause => $value)
			if ( MatchClause($clause, $str) ) {
				$sum += $value;
				$str = RemoveClause($clause, $str);

				$done = false;
				break;
			}
	} while ($done == false);

	return($sum);
} 
