<?php

/*
 * $Id: api.contact.func.php,v 1.1 2013-08-19 17:02:51 light Exp $
 *
 * $Log: api.contact.func.php,v $
 * Revision 1.1  2013-08-19 17:02:51  light
 * Bug #8252 - API extensions for TVL
 *
 *
 */

/**
 * api/functions.contact.func.php - API functions related to contacts
 */ 

require_once(__DIR__ . '/../class.audit.php');
require_once(__DIR__ . '/../db.ac_accomm_type.php');
require_once(__DIR__ . "/../db.ad_persona_detail.php");
require_once(__DIR__ . '/../db.pr_agent.php');
require_once(__DIR__ . '/../db.pr_business.php');
require_once(__DIR__ . '/../db.pr_guest.php');
require_once(__DIR__ . '/../db.pr_guest_obj_data.php');
require_once(__DIR__ . '/../db.pr_persona.php');
require_once(__DIR__ . '/../db.pr_phone.php');
require_once(__DIR__ . '/../db.rf_obj_guest.php');
require_once(__DIR__ . '/../db.rf_obj_trip.php');
require_once(__DIR__ . '/../db.rf_phone_type.php');
require_once(__DIR__ . '/../functions.persona.php');
require_once(__DIR__ . '/api.rate.php');

function api_pr_get_contact($filter="",$fields="",$agentRole="",$agentRoleFilter="",$userRole="",$userRoleFilter="",$guestRole="",$guestRoleFilter="") {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}
	
	$extraSelect = "";
	$extraJoin = "";
	$extraWhere = "";	
	$extraOrderBy = "";
	$contactArray = array();
	$travelExtraWhere = "";
			
	if(!empty($agentRole)) {
		$extraSelect .= ",
			pr_agent.pr_agent_id,
			pr_agent.pr_agent_comm_deduct_yn,
			pr_agent.pr_agent_commission_perc,
			pr_agent.pr_agent_account,
			pr_agent.ac_pay_plan_id		
		";
	}
	
	if(!empty($agentRoleFilter)) {
		$extraWhere .= "
			AND pr_agent.pr_agent_id IS NOT NULL
		";
	}
	
	if(!empty($userRoleFilter)) {
		$extraWhere .= "
			AND pr_user.pr_user_id IS NOT NULL
		";
	}

	$guestProfile = false;
	$guestProfileBasic = false;
	$guestProfileCustom = false;
	$guestTripsheet = false;
	$guestVisits = false;
	if(!empty($guestRole)) {
		$extraSelect .= ",
			pr_guest.pr_guest_primary_yn
		";
		if(is_array($guestRole)) {

			if(array_key_exists("profile",$guestRole)) {
				if(!is_array($guestRole['profile'])) {
					switch($guestRole['profile']) {
					case "basic":
						$guestProfileBasic = true;
						break;
					case "custom":
						$guestProfileCustom = true;
						break;
					case "all":
						$guestProfileBasic = true;
						$guestProfileCustom = true;
						break;
					}
				} else {
					foreach($guestRole['profile'] as $item) {
						switch($item) {
						case "basic":
							$guestProfileBasic = true;
							break;
						case "custom":
							$guestProfileCustom = true;
							break;
						case "all":
							$guestProfileBasic = true;
							$guestProfileCustom = true;
							break;
						}
					}
				}
			}
			if(array_key_exists("tripsheet",$guestRole) && !empty($guestRole['tripsheet'])) {
				$guestTripsheet = true;
			}
			if(array_key_exists("calculate",$guestRole)) {
				if(!is_array($guestRole['calculate'])) {
					if($guestRole['calculate'] = "visits") {
						$guestVisits = true;
					}
				} else {
					if(in_array("visits",$guestRole['calculate'])) {
						$guestVisits = true;
					}
				}
			}
		}
		if($guestProfileBasic || $guestProfileCustom) {
			$guestProfile = true;
		}
	}

	if(!empty($guestRoleFilter)) {
		$extraWhere .= "
			AND pr_guest.pr_guest_id IS NOT NULL
		";
		if(is_array($guestRoleFilter)) {
			if(array_key_exists("tripsheet",$guestRoleFilter)) {
				$tripsheetFilter = $guestRoleFilter['tripsheet'];
				$joinItinerary = false;
				$filterOutput = false;
				if(array_key_exists("filter_output",$tripsheetFilter) && !empty($tripsheetFilter['filter_output'])) {
					$filterOutput = true;
				}
				if(array_key_exists("property",$tripsheetFilter)) {
					$joinItinerary = true;
					if(!is_array($tripsheetFilter['property'])) {
						$pr_business_ids = explode(",",$tripsheetFilter['property']);
					} else {
						$pr_business_ids = $tripsheetFilter['property'];
					}
					foreach($pr_business_ids as $pr_business_id) {
						if(!db_pr_business_exists($pr_business_id)) {
							return $api_instance->Error("Invalid property ($pr_business_id)");
						}
					}
					$pr_business_ids = array_map(function($pr_business_id) {
						global $lDB;

						return $lDB->escape($pr_business_id);
					},$pr_business_ids);
					$propertyWhere = "
						AND rv_reservation_item.pr_business_id IN ('".join("','",$pr_business_ids)."')
					";
					$extraWhere .= $propertyWhere;
					if($filterOutput) {
						$travelExtraWhere .= $propertyWhere;
					}
					unset($propertyWhere);
				}
				if(array_key_exists("accommodation_type",$tripsheetFilter)) {
					$joinItinerary = true;
					if(!is_array($tripsheetFilter['accommodation_type'])) {
						$ac_accomm_type_ids = explode(",",$tripsheetFilter['accommodation_type']);
					} else {
						$ac_accomm_type_ids = $tripsheetFilter['accommodation_type'];
					}
					foreach($ac_accomm_type_ids as $ac_accomm_type_id) {
						if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
							return $api_instance->Error("Invalid accommodation type ($ac_accomm_type_id)");
						}
					}
					$ac_accomm_type_ids = array_map(function($ac_accomm_type_id) {
						global $lDB;

						return $lDB->escape($ac_accomm_type_id);
					},$ac_accomm_type_ids);
					$accommWhere = "
						AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$ac_accomm_type_ids)."')
					";
					$extraWhere .= $accommWhere;
					if($filterOutput) {
						$travelExtraWhere .= $accommWhere;
					}
					unset($accommWhere);
				}
				if(array_key_exists("date",$tripsheetFilter)) {
					$joinItinerary = true;
					$startDate = $lDB->escape($tripsheetFilter['date']['start']);
					$endDate = $lDB->escape($tripsheetFilter['date']['end']);
					$dateWhere = "";
					switch($tripsheetFilter['date']['type']) {
					case "arrive":
						$dateWhere .= "
							AND rv_reservation_item.rv_item_date_arrive >= '$startDate'
							AND rv_reservation_item.rv_item_date_arrive <= '$endDate'
						";
						break;
					case "depart":
						$dateWhere .= "
							AND rv_reservation_item.rv_item_date_depart >= '$startDate'
							AND rv_reservation_item.rv_item_date_depart <= '$endDate'
						";
						break;
					case "travel":
						$dateWhere .= "
							AND 
								(
									(
										rv_reservation_item.rv_item_date_arrive >= '$startDate'
										AND rv_reservation_item.rv_item_date_arrive <= '$endDate'
									) OR (
										rv_reservation_item.rv_item_date_depart >= '$startDate'
										AND rv_reservation_item.rv_item_date_depart <= '$endDate'
									) OR (
										rv_reservation_item.rv_item_date_arrive < '$startDate'
										AND rv_reservation_item.rv_item_date_depart > '$endDate'
									)
								)
						";
						break;
					case "inhouse":
						$dateWhere .= "
							AND 
								(
									(
										rv_reservation_item.rv_item_date_arrive >= '$startDate'
										AND rv_reservation_item.rv_item_date_arrive <= '$endDate'
									) OR (
										rv_reservation_item.rv_item_date_depart > '$startDate'
										AND rv_reservation_item.rv_item_date_depart < '$endDate'
									) OR (
										rv_reservation_item.rv_item_date_arrive < '$startDate'
										AND rv_reservation_item.rv_item_date_depart > '$endDate'
									)
								)
						";
						break;
					}
					$extraWhere .= $dateWhere;
					if($filterOutput) {
						$travelExtraWhere .= $dateWhere;
					}
				}
				if($joinItinerary) {
					$extraJoin .= "
						INNER JOIN rv_res_item_guest ON rv_res_item_guest.pr_guest_id = pr_guest.pr_guest_id
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
					";
				}
			}
		}
	}

	$pr_name_last = "";
	if(!empty($filter)) {
		if(!is_array($filter)) {
			$pr_name_last = str_replace("*", "%", $filter);
			if ($pr_name_last != "" && $pr_name_last != "%") {
				$extraWhere .= " AND pr_persona.pr_name_last LIKE '".$lDB->escape($pr_name_last)."'";	
			}
		} else {
			$filters = array(
				'id'=>"pr_persona.pr_persona_ix",
				'last_name'=>"pr_persona.pr_name_last",
				'first_name'=>"pr_persona.pr_name_first",
				'email'=>"pr_persona.pr_email"
			);
			foreach($filters as $name=>$field) {
				if(array_key_exists($name,$filter) && !empty($filter[$name])) {
					$value = str_replace("*","%",$filter[$name]);
					$extraWhere .= " AND $field LIKE '".$lDB->escape($value)."'";
				}
			}
		}
	}

	if(!empty($fields)) {
		if(!is_array($fields)) {
			$pr_name_first = str_replace("*", "%", $fields);
			if ($pr_name_first != "" && $pr_name_first != "%") {
				$extraWhere .= " AND pr_persona.pr_name_first LIKE '".$lDB->escape($pr_name_first)."'";	
			}	
		}
	}
	
	$personaArray = $lDB->get("
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_email,
			rf_title.rf_title_ix,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_name_suffix_ix,
			rf_name_suffix.rf_suffix_desc,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_city,
			pr_persona.pr_corr_post_code,
			corr_country.rf_country_ix AS corr_country_id,
			corr_country.rf_country_code AS corr_country_code,
			corr_country.rf_country_name AS corr_country_name,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_city,
			pr_persona.pr_phys_post_code,
			phys_country.rf_country_ix AS phys_country_id,
			phys_country.rf_country_code AS phys_country_code,
			phys_country.rf_country_name AS phys_country_name
			$extraSelect
		FROM
			pr_persona
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
				AND rf_title.rf_title_inactive_yn = '0'
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
				AND rf_name_suffix.rf_suffix_inactive_yn = '0'
			LEFT JOIN rf_country AS corr_country ON corr_country.rf_country_ix = pr_persona.pr_corr_country_id
			LEFT JOIN rf_country AS phys_country ON phys_country.rf_country_ix = pr_persona.pr_phys_country_id
			LEFT JOIN pr_agent ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
				AND pr_agent.pr_agent_inactive_yn = '0'
			LEFT JOIN pr_user ON pr_user.pr_user_id = pr_persona.pr_persona_ix
				AND pr_user.pr_user_inactive_yn = '0'
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
				AND pr_guest.pr_guest_inactive_yn = '0'
			$extraJoin
		WHERE
			pr_persona.pr_persona_inactive_yn = '0'
			$extraWhere
		$extraOrderBy
	",2);	

	foreach ($personaArray as $item){

		$person['id'] = $item['pr_persona_ix'];
		$person['last_name'] = $item['pr_name_last'];
		$person['first_name'] = $item['pr_name_first'];
		$person['title'] = $item['rf_title_desc'];
		$person['title_id'] = $item['rf_title_ix'];
		$person['suffix'] = $item['rf_suffix_desc'];
		$person['suffix_id'] = $item['rf_name_suffix_ix'];
		$person['email'] = $item['pr_email'];
		$person['post_addr_line1'] = $item['pr_corr_addr_line1'];
		$person['post_addr_line2'] = $item['pr_corr_addr_line2'];
		$person['post_addr_line3'] = $item['pr_corr_addr_line3'];
		$person['post_city'] = $item['pr_corr_city'];
		$person['post_post_code'] = $item['pr_corr_post_code'];
		$person['post_country_id'] = $item['corr_country_id'];
		$person['post_country_code'] = $item['corr_country_code'];
		$person['post_country_name'] = $item['corr_country_name'];
		$person['phys_addr_line1'] = $item['pr_phys_addr_line1'];
		$person['phys_addr_line2'] = $item['pr_phys_addr_line2'];
		$person['phys_addr_line3'] = $item['pr_phys_addr_line3'];
		$person['phys_city'] = $item['pr_phys_city'];
		$person['phys_post_code'] = $item['pr_phys_post_code'];
		$person['phys_country_id'] = $item['phys_country_id'];
		$person['phys_country_code'] = $item['phys_country_code'];
		$person['phys_country_name'] = $item['phys_country_name'];

		$person['phone'] = array();
		$person['agent'] = array();
		$person['user'] = array();
		$person['guest'] = array();
				
		$phoneArray = $lDB->get("
			SELECT
				pr_phone.pr_phone_ix,
				pr_phone.pr_phone_number,
				rf_phone_type.rf_phone_type_desc,
				pr_phone.pr_default_yn
			FROM
				pr_phone 
				INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
			WHERE
				pr_phone.pr_persona_id  = '".$item['pr_persona_ix']."'
		",2);		
		
		foreach($phoneArray as $phoneItem) {
			$phone['id'] = $phoneItem['pr_phone_ix'];
			$phone['number'] = $phoneItem['pr_phone_number'];
			$phone['type'] = $phoneItem['rf_phone_type_desc'];
			$phone['default'] = $phoneItem['pr_default_yn'];
			
			array_push($person['phone'],$phone);
		}

		
		if(!empty($agentRole) && db_pr_agent_exists($item['pr_persona_ix'])){
			$agent = array();
			$agent['charge'] = $item['pr_agent_comm_deduct_yn'];
			$agent['commission'] = $item['pr_agent_commission_perc'];
			$agent['account'] = $item['pr_agent_account'];
			$agent['payment_plan'] = $item['ac_pay_plan_id'];
			$agent['rates'] = api_rt_get_rate("",0,$item['pr_persona_ix']);
			$person['agent'] = $agent;
	
		}

		if(!empty($userRole)) {
			// (RESERVED FOR LATER)
		}
		
		if(!empty($guestRole) && db_pr_guest_exists($item['pr_persona_ix'])) {
			$guest = array();
			$guest['primary_yn'] = $item['pr_guest_primary_yn'];
			if($guestProfile) {
				$profileWhere = "";
				if($guestProfileBasic && !$guestProfileCustom) {
					$profileWhere = "AND rf_obj_guest.rf_obj_guest_sys_code != '0'";
				} elseif(!$guestProfileBasic && $guestProfileCustom) {
					$profileWhere = "AND rf_obj_guest.rf_obj_guest_sys_code = '0'";
				}

				$profileRaw = $lDB->get("
					SELECT
						rf_obj_guest.rf_obj_guest_ix,
						rf_obj_guest.rf_obj_guest_label,
						rf_obj_guest.rf_obj_guest_type_ind,
						rf_obj_guest.rf_obj_guest_sys_code,
						rf_obj_guest.rf_obj_guest_sort_seq,
						pr_guest_obj_data.pr_guest_obj_data_ix,
						pr_guest_obj_data.pr_guest_obj_data_text,
						pr_guest_obj_data.pr_guest_obj_data_memo,
						pr_guest_obj_data.rf_obj_guest_data_id,
						rf_obj_guest_data.rf_obj_guest_data_content
					FROM
						rf_obj_guest
						LEFT JOIN pr_guest_obj_data ON pr_guest_obj_data.rf_obj_guest_id = rf_obj_guest.rf_obj_guest_ix
							AND pr_guest_obj_data.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
							AND rf_obj_guest.rf_obj_guest_type_ind != '".DB_RF_OBJ_GUEST_CHECKBOX."'
						LEFT JOIN rf_obj_guest_data ON rf_obj_guest_data.rf_obj_guest_data_ix = pr_guest_obj_data.rf_obj_guest_data_id
					WHERE
						rf_obj_guest.rf_obj_guest_inactive_yn = '0'
						AND (
							pr_guest_obj_data.pr_guest_obj_data_ix IS NULL
							OR pr_guest_obj_data.pr_guest_obj_data_inactive_yn = '0'
						)
						$profileWhere
					ORDER BY
						rf_obj_guest.rf_obj_guest_sort_seq
				",2);
				$profile = array();
				foreach($profileRaw as $profileItem) {
					$id = "";
					$code = "";
					$value = "";
					if($profileItem['rf_obj_guest_type_ind'] != DB_RF_OBJ_GUEST_CHECKBOX) {
						$all = db_pr_guest_obj_data_get_all($profileItem['pr_guest_obj_data_ix']);
						if($all !== false) {
							$id = $all['id'];
							$code = $all['code'];
							$value = $all['value'];
						}
					} else {
						$checkboxItems = $lDB->get("
							SELECT 
								pr_guest_obj_data.rf_obj_guest_data_id,
								rf_obj_guest_data.rf_obj_guest_data_content
							FROM
								pr_guest_obj_data
								INNER JOIN rf_obj_guest_data ON rf_obj_guest_data.rf_obj_guest_data_ix = pr_guest_obj_data.rf_obj_guest_data_id
							WHERE
								pr_guest_obj_data.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
								AND pr_guest_obj_data.rf_obj_guest_id = '".$lDB->escape($profileItem['rf_obj_guest_ix'])."'
						",6);
						$id = [];
						$value = [];
						foreach($checkboxItems as $checkboxItem) {
							$id[] = $checkboxItem['rf_obj_guest_data_id'];
							$value[] = $checkboxItem['rf_obj_guest_data_content'];
						}
					}
					$profile[] = array(
						'type'=>($profileItem['rf_obj_guest_sys_code']!=0?"basic":"custom"),
						'label'=>$profileItem['rf_obj_guest_label'],
						'id'=>$id,
						'value'=>$value,
						'code'=>$code,
						'field_id'=>$profileItem['rf_obj_guest_ix'],
						'field_type_id'=>$profileItem['rf_obj_guest_type_ind'],
						'field_type_name'=>db_rf_obj_guest_type_ind_desc($profileItem['rf_obj_guest_type_ind']),
						'field_sort_sequence'=>$profileItem['rf_obj_guest_sort_seq']
					);
				}
				$guest['profile'] = $profile;
			}
			if($guestTripsheet) {
				$travelRaw = $lDB->get("
					SELECT DISTINCT
						rv_reservation.rv_reservation_ix,
						rv_reservation.rv_res_name,
						rv_reservation.rf_reservation_status_id,
						rf_reservation_status.rf_reservation_status_desc,
						rv_reservation_item.rv_reservation_item_ix,
						rv_reservation_item.rv_item_date_arrive,
						rv_reservation_item.rv_item_date_depart,
						rv_reservation_item.rv_item_accomm_count,
						rv_reservation_item.rv_item_adult_count,
						rv_reservation_item.rv_item_child_count,
						pr_business.pr_business_id,
						pr_persona.pr_name_last,
						ac_accomm_type.ac_accomm_type_ix,
						ac_accomm_type.ac_accomm_desc
					FROM
						rv_res_item_guest
						INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
						INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
						INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
						INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
						INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
					WHERE
						rv_res_item_guest.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
						AND rv_reservation.rf_reservation_status_id IN ('30') 
						$travelExtraWhere
					ORDER BY 
						rv_reservation.rv_reservation_ix, 
						rv_reservation_item.rv_item_date_arrive, 
						ac_accomm_type.ac_accomm_desc
				",2);
				$travel = array();
				foreach($travelRaw as $travelItem) {
					if(!array_key_exists($travelItem['rv_reservation_ix'],$travel)) {
						$travel[$travelItem['rv_reservation_ix']] = array(
							'reservation_id'=>$travelItem['rv_reservation_ix'],
							'reservation_name'=>$travelItem['rv_res_name'],
							'status_id'=>$travelItem['rf_reservation_status_id'],
							'status'=>$travelItem['rf_reservation_status_desc'],
							'itineraries'=>array()
						);
					}
					$travel[$travelItem['rv_reservation_ix']]['itineraries'][] = array(
						'id'=>$travelItem['rv_reservation_item_ix'],
						'property_id'=>$travelItem['pr_business_id'],
						'property'=>$travelItem['pr_name_last'],
						'accommodation_id'=>$travelItem['ac_accomm_type_ix'],
						'accommodation'=>$travelItem['ac_accomm_desc'],
						'arrive_date'=>$travelItem['rv_item_date_arrive'],
						'depart_date'=>$travelItem['rv_item_date_depart'],
						'units'=>$travelItem['rv_item_accomm_count'],
						'adults'=>$travelItem['rv_item_adult_count'],
						'children'=>$travelItem['rv_item_child_count']
					);
				}
				foreach($travel as $rv_reservation_id=>$travelItem) {
					$properties = array_unique(array_map(function($itinerary) {
						return $itinerary['property_id'];
					},$travelItem['itineraries']));
					array_push($properties,'0');
					$tripsheetRaw = $lDB->get("
						SELECT
							rf_obj_trip.rf_obj_trip_ix,
							rf_obj_trip.rf_obj_trip_label,
							rf_obj_trip.rf_obj_trip_type_ind,
							rf_obj_trip.rf_obj_trip_sort_seq,
							rf_obj_trip_prop.pr_business_id,
							pr_persona.pr_name_last,
							rv_trip_obj_data.rv_trip_obj_data_ix,
							rv_trip_obj_data.rv_trip_obj_data,
							rv_trip_obj_data.rf_obj_trip_data_id,
							rf_obj_trip_data.rf_obj_trip_data_content
						FROM
							rf_obj_trip
							INNER JOIN rf_obj_trip_prop ON rf_obj_trip_prop.rf_obj_trip_id = rf_obj_trip.rf_obj_trip_ix
							LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_obj_trip_prop.pr_business_id
							LEFT JOIN rv_trip_obj_data ON rv_trip_obj_data.rf_obj_trip_id = rf_obj_trip.rf_obj_trip_ix
								AND rv_trip_obj_data.rv_reservation_id = '".$lDB->escape($rv_reservation_id)."'
								AND rv_trip_obj_data.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
								AND rf_obj_trip.rf_obj_trip_type_ind != '".DB_RF_OBJ_TRIP_CHECKBOX."'
							LEFT JOIN rf_obj_trip_data ON rf_obj_trip_data.rf_obj_trip_data_ix = rv_trip_obj_data.rf_obj_trip_data_id
						WHERE
							rf_obj_trip.rf_obj_trip_inactive_yn = '0'
							AND rf_obj_trip_prop.pr_business_id IN ('".join("','",$properties)."')
							AND (
								rv_trip_obj_data.rv_trip_obj_data_ix IS NULL
								OR rv_trip_obj_data.rv_trip_obj_data_inactive_yn = '0'
							)
						ORDER BY
							rf_obj_trip_prop.pr_business_id,
							rf_obj_trip.rf_obj_trip_sort_seq
						
					",2);
					$travel[$rv_reservation_id]['tripsheet'] = array();
					foreach($tripsheetRaw as $tripsheetItem) {
						$id = "";
						$value = "";
						if($tripsheetItem['rf_obj_trip_type_ind'] != DB_RF_OBJ_TRIP_CHECKBOX) {
							$all = db_rv_trip_obj_data_get_all($tripsheetItem['rv_trip_obj_data_ix']);
							if($all !== false) {
								$id = $all['id'];
								$value = $all['value'];
							}
						} else {
							$checkboxItems = $lDB->get("
								SELECT 
									rv_trip_obj_data.rf_obj_trip_data_id,
									rf_obj_trip_data.rf_obj_trip_data_content
								FROM
									rv_trip_obj_data
									INNER JOIN rf_obj_trip_data ON rf_obj_trip_data.rf_obj_trip_data_ix = rv_trip_obj_data.rf_obj_trip_data_id
								WHERE
									rv_trip_obj_data.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
									AND rv_trip_obj_data.rv_reservation_id = '".$lDB->escape($rv_reservation_id)."'
									AND rv_trip_obj_data.rf_obj_trip_id = '".$lDB->escape($tripsheetItem['rf_obj_trip_ix'])."'
							",6);
							$id = [];
							$value = [];
							foreach($checkboxItems as $checkboxItem) {
								$id[] = $checkboxItem['rf_obj_trip_data_id'];
								$value[] = $checkboxItem['rf_obj_trip_data_content'];
							}
						}
						$travel[$rv_reservation_id]['tripsheet'][] = array(
							'property_id'=>(empty($tripsheetItem['pr_business_id'])?"":$tripsheetItem['pr_business_id']),
							'property'=>(empty($tripsheetItem['pr_business_id'])?"":$tripsheetItem['pr_name_last']),
							'label'=>$tripsheetItem['rf_obj_trip_label'],
							'id'=>$id,
							'value'=>$value,
							'field_id'=>$tripsheetItem['rf_obj_trip_ix'],
							'field_type_id'=>$tripsheetItem['rf_obj_trip_type_ind'],
							'field_type_name'=>db_rf_obj_trip_type_ind_desc($tripsheetItem['rf_obj_trip_type_ind']),
							'field_sort_sequence'=>$tripsheetItem['rf_obj_trip_sort_seq']
						);
					}	
				}
				$travel = array_values($travel);
				$guest['tripsheets'] = $travel;
			}
			if($guestVisits) {
				$guest['visits'] = $lDB->get("
					SELECT 
						COUNT(DISTINCT rv_reservation.rv_reservation_ix) as visits
					FROM
						rv_res_item_guest
						INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
						INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					WHERE
						rv_res_item_guest.pr_guest_id = '".$lDB->escape($item['pr_persona_ix'])."'
						AND rv_reservation.rv_date_depart <= '".date("Y-m-d")."'
						AND rv_reservation.rf_reservation_status_id IN ('30') 
				",4);
			}
			$person['guest'] = $guest;
		}		

		array_push($contactArray,$person);
	}

	return $contactArray;
	
}

function api_pr_persona_fields() {
	return [
		'first_name'=>"pr_name_first",
		'last_name'=>"pr_name_last",
		'title_id'=>"pr_title_id",
		'suffix_id'=>"pr_name_suffix_id",
		'email'=>"pr_email",
		'post_addr_line1'=>"pr_corr_addr_line1",
		'post_addr_line2'=>"pr_corr_addr_line2",
		'post_addr_line3'=>"pr_corr_addr_line3",
		'post_city'=>"pr_corr_city",
		'post_post_code'=>"pr_corr_post_code",
		'post_country_id'=>"pr_corr_country_id",
		'phys_addr_line1'=>"pr_phys_addr_line1",
		'phys_addr_line2'=>"pr_phys_addr_line2",
		'phys_addr_line3'=>"pr_phys_addr_line3",
		'phys_city'=>"pr_phys_city",
		'phys_post_code'=>"pr_phys_post_code",
		'phys_country_id'=>"pr_phys_country_id"
	];
}

function api_pr_create_contact($values) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2) {
		return $api_instance->Error("Access denied.");
	}

	if(!is_array($values)) {
		return $api_instance->Error("Invalid field values supplied");
	}

	if(empty($values)) {
		return $api_instance->Error("No field values supplied");
	}

	$fields = api_pr_persona_fields();
	$mobileNumber = false;
	$guestRole = false;
	$guestFields = [];

	$newValues = [];
	foreach($values as $field=>$value) {
		if(array_key_exists($field,$fields)) {
			$newValues[$fields[$field]] = $value;
		} elseif($field == "guest") {
			$guestRole = true;
			$guestFields = $value;
		} elseif($field == "mobile_number") {
			$mobileNumber = $value;
		} else {
			return $api_instance->Error("Unknown field $field");
		}
	}
	$values = $newValues;
	unset($newValues);

	if($guestRole) {
		try {
			list($guestFields, $rf_obj_guests) = api_pr_validate_guest_fields($guestFields);
		} catch(Exception $e) {
			return $api_instance->Error($e->getMessage());
		}
	}

	try {
		$pr_persona_id = db_pr_persona_insert_custom($values);
		if($guestRole) {
			api_pr_save_guest($pr_persona_id, $guestFields, $rf_obj_guests);
		}
	} catch(Exception $e) {
		return $api_instance->Error(str_replace(array_values($fields),array_keys($fields),$e->getMessage()));
	}

	if($pr_persona_id !== false) {
		if ($mobileNumber !== false) {
			$rf_mobile_type_id = $lDB->get("
				SELECT
					rf_phone_type.rf_phone_type_ix
				FROM
					rf_phone_type
				WHERE
					rf_phone_type.rf_phone_type_desc LIKE '%mobile%'
			",4);
			db_pr_phone_insert($pr_persona_id, $rf_mobile_type_id, $mobileNumber, false, true);
		}

		return $pr_persona_id;
	} else {
		return $api_instance->Error("Unknown error creating contact");
	}
}

function api_pr_update_contact($pr_persona_id, $changes) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2 || $lDB->isMaster == "0") {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		return $api_instance->Error("Unknown contact");
	}

	if(!is_array($changes)) {
		return $api_instance->Error("Invalid changes requested");
	}

	$fields = api_pr_persona_fields();

	$newChanges = [];
	foreach($changes as $field=>$value) {
		if(!array_key_exists($field,$fields)) {
			return $api_instance->Error("Unknown field $field");
		}
		$newChanges[$fields[$field]] = $value;
	}
	$changes = $newChanges;
	unset($newChanges);

	try {
		db_pr_persona_update_custom($pr_persona_id, $changes);
	} catch(Exception $e) {
		return $api_instance->Error(str_replace(array_values($fields),array_keys($fields),$e->getMessage()));
	}

	return true;
}

function api_pr_create_phone($pr_persona_id, $pr_phone_number, $rf_phone_type_id, $pr_phone_detail=false, $pr_default_yn=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2) {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		return $api_instance->Error("Unknown contact");
	}

	if(!db_rf_phone_type_exists($rf_phone_type_id)) {
		return $api_instance->Error("Unknown phone type");
	}

	if(empty($pr_phone_detail)) {
		$pr_phone_detail = '';
	}

	if(empty($pr_default_yn)) {
		$pr_default_yn = false;
	} else {
		$pr_default_yn = true;
	}

	$pr_phone_id = db_pr_phone_insert($pr_persona_id,$rf_phone_type_id,$pr_phone_number,$pr_phone_detail,$pr_default_yn);
	if($pr_phone_id === false) {
		return $api_instance->Error("Error creating phone entry");
	}

	return $pr_phone_id;
}

function api_pr_update_phone($pr_persona_id, $pr_phone_id, $pr_phone_number, $rf_phone_type_id, $pr_phone_detail=false, $pr_default_yn=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2 || $lDB->isMaster == "0") {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		return $api_instance->Error("Unknown contact");
	}

	if(!db_pr_phone_exists($pr_phone_id)) {
		return $api_instance->Error("Unknown phone id");
	}

	if(!db_rf_phone_type_exists($rf_phone_type_id)) {
		return $api_instance->Error("Unknown phone type");
	}

	$check_persona_id = $lDB->get("SELECT pr_persona_id FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
	if($pr_persona_id != $check_persona_id) {
		return $api_instance->Error("Contact and phone id do not match");
	}

	if(empty($pr_default_yn)) {
		$pr_default_yn = false;
	} else {
		$pr_default_yn = true;
	}

	db_pr_phone_update($pr_phone_id,$rf_phone_type_id,$pr_phone_number,$pr_phone_detail,$pr_default_yn);
	
	return true;
}

function api_pr_delete_phone($pr_persona_id, $pr_phone_id) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2 || $lDB->isMaster == "0") {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		return $api_instance->Error("Unknown contact");
	}

	if(!db_pr_phone_exists($pr_phone_id)) {
		return $api_instance->Error("Unknown phone id");
	}

	$check_persona_id = $lDB->get("SELECT pr_persona_id FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
	if($pr_persona_id != $check_persona_id) {
		return $api_instance->Error("Contact and phone id do not match");
	}

	if(!db_pr_phone_delete($pr_phone_id)) {
		return $api_instance->Error("Error deleting phone entry");
	}

	return true;
}


function api_pr_validate_guest_fields($fields) {
	global $lDB;

	$rf_obj_guests = [];
	foreach($fields as $rf_obj_guest_id=>$value) {
		if($rf_obj_guest_id == "primary_yn") {
			if(empty($value)) {
				$fields[$rf_obj_guest_id] = "0";
			} else {
				$fields[$rf_obj_guest_id] = "1";
			}
			continue;
		}
		if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
			throw new Exception("Unknown field id $rf_obj_guest_id");
		}
		$rf_obj_guest = $rf_obj_guests[$rf_obj_guest_id] = $lDB->get("
			SELECT
				rf_obj_guest.rf_obj_guest_type_ind,
				rf_obj_guest.rf_obj_guest_sys_code,
				rf_obj_guest.rf_obj_guest_inactive_yn
			FROM
				rf_obj_guest
			WHERE
				rf_obj_guest.rf_obj_guest_ix = '".$lDB->escape($rf_obj_guest_id)."'
		",1);
		if($rf_obj_guest['rf_obj_guest_inactive_yn'] != "0") {
			throw new Exception("Unknown field id $rf_obj_guest_id");
		}
		switch($rf_obj_guest['rf_obj_guest_type_ind']) {
		case DB_RF_OBJ_GUEST_TEXTAREA:
		case DB_RF_OBJ_GUEST_TEXTBOX:
			// no validation needed
			break;
		case DB_RF_OBJ_GUEST_NUMERIC:
			if(!empty($value) && !is_numeric($value)) {
				throw new Exception("Invalid value $value for numeric field $rf_obj_guest_id");
			}
			break;
		case DB_RF_OBJ_GUEST_DATE:
			if(strtotime($value) === false) {
				throw new Exception("Invalid value $value for date field $rf_obj_guest_id");
			}
			break;
		case DB_RF_OBJ_GUEST_RADIO:
		case DB_RF_OBJ_GUEST_SELECTBOX:
			if($value !== "") {
				$check = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						rf_obj_guest_data
					WHERE
						rf_obj_guest_data.rf_obj_guest_id = '".$lDB->escape($rf_obj_guest_id)."'
						AND rf_obj_guest_data.rf_obj_guest_data_ix = '".$lDB->escape($value)."'
				",4);
				if($check == 0) {
					throw new Exception("Invalid value $value for field $rf_obj_guest_id");
				}
			}
			break;
		case DB_RF_OBJ_GUEST_CHECKBOX:
			if(!is_array($value)) {
				$value = [$value];
			}
			$value = array_unique(array_filter($value,function($item) {
				if(!empty(trim($item))) {
					return true;
				}
				return false;
			}));
			$fields[$rf_obj_guest_id] = $value;
			foreach($value as $rf_obj_guest_data_id) {
				if(!db_rf_obj_guest_data_exists($rf_obj_guest_data_id,$rf_obj_guest_id)) {
					throw new Exception("Invalid value $rf_obj_guest_data_id for field $rf_obj_guest_id");
				}
			}
			break;
		case DB_RF_OBJ_GUEST_NATION_LOOKUP:
			if(!db_rf_country_exists($value)) {
				throw new Exception("Invalid value $value for country field $rf_obj_guest_id");
			}
			break;
		}
	}

	return [$fields, $rf_obj_guests];
}

function api_pr_save_guest($pr_persona_id, $fields, $rf_obj_guests) {
	global $lDB;

	if(!db_pr_guest_exists($pr_persona_id)) {
		db_pr_guest_insert($pr_persona_id);
	}

	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	foreach($fields as $rf_obj_guest_id=>$value) {
		if($rf_obj_guest_id == "primary_yn") {
			$oldValue = $lDB->get("SELECT pr_guest_primary_yn FROM pr_guest WHERE pr_guest.pr_guest_id = '".$lDB->escape($pr_persona_id)."'",4);
			$audit->addDetail($oldValue, $value, $pr_persona_id, $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "guest", "pr_guest.pr_guest_primary_yn");
			db_pr_guest_set_role($pr_persona_id, $value);
			continue;
		}
		$rf_obj_guest = $rf_obj_guests[$rf_obj_guest_id];
		if($rf_obj_guest['rf_obj_guest_type_ind'] == DB_RF_OBJ_GUEST_CHECKBOX) {
			$pr_guest_obj_datas = $lDB->get("
				SELECT
					pr_guest_obj_data.pr_guest_obj_data_ix,
					pr_guest_obj_data.rf_obj_guest_data_id
				FROM
					pr_guest_obj_data
				WHERE
					rf_obj_guest_id = '".$lDB->escape($rf_obj_guest_id)."'
					AND pr_guest_id = '".$lDB->escape($pr_persona_id)."'
			",6);
			$rf_obj_guest_data_ids = [];
			foreach ($pr_guest_obj_datas as $pr_guest_obj_data) {
				$pr_guest_obj_data_id = $pr_guest_obj_data['pr_guest_obj_data_ix'];
				$rf_obj_guest_data_ids[] = $rf_obj_guest_data_id = $pr_guest_obj_data['rf_obj_guest_data_id'];
				// Delete only items that no longer exist
				if(!in_array($rf_obj_guest_data_id, $value)) {
					$all = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);
					$audit->addDetail($all['id'], "", $pr_guest_obj_data_id, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, $all['value'], "");
					db_pr_guest_obj_data_delete($pr_guest_obj_data_id);
				}
			}
			foreach($value as $item) {
				// Add only new items
				if(!in_array($item, $rf_obj_guest_data_ids)) {
					$pr_guest_obj_data_id = db_pr_guest_obj_data_insert($pr_persona_id, $rf_obj_guest_id, $item);
					$all = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);

					$audit->addDetail("", $all['id'], "", $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, "", $all['value']);
				}
			}
		} else {
			$newAll = db_rf_obj_guest_get_all($rf_obj_guest_id, $value);
			if(db_pr_guest_obj_data_exists_by_guest($pr_persona_id, $rf_obj_guest_id)) {
				$pr_guest_obj_data_id = db_pr_guest_obj_data_select_by_guest($pr_persona_id, $rf_obj_guest_id);
				$oldAll = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);
				db_pr_guest_obj_data_update($pr_guest_obj_data_id, $rf_obj_guest_id, $value);
				$audit->addDetail($oldAll['id'], $newAll['id'], $pr_guest_obj_data_id, $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, $oldAll['value'], $newAll['value']);
			} else {
				$pr_guest_obj_data_id = db_pr_guest_obj_data_insert($pr_persona_id, $rf_obj_guest_id, $value);
				$audit->addDetail("", $newAll['id'], "", $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, "", $newAll['value']);
			}
			if($rf_obj_guest['rf_obj_guest_sys_code'] > 0) {
				switch(db_rf_obj_guest_find_field_name($rf_obj_guest['rf_obj_guest_sys_code'])) {
				case "pr_identity_no":
					db_pr_persona_update_identity($pr_persona_id,$value);
					break;
				case "pr_guest_gender":
					if($value == "RS1") {
						$gender = "M";
					} elseif($value == "RS2") {
						$gender = "F";
					} else {
						$gender = "";
					}
					db_pr_guest_set_gender($pr_persona_id, $gender);
					break;
				case "rf_guest_type_ix":
					db_pr_guest_set_type($pr_persona_id, $value);
					break;
				case "rf_country_id":
					db_pr_guest_set_country($pr_persona_id, $value);
					break;
				case "pr_anniversary":
					db_pr_persona_update_anniversary($pr_persona_id, $value);
					break;
				case "pr_birthdate":
					db_pr_persona_update_birthdate($pr_persona_id, $value);
					break;
				case "pr_guest_note":
					db_pr_guest_set_note($pr_persona_id, $value);
					break;
				case "pr_guest_memo":
					db_pr_guest_set_memo($pr_persona_id, $value);
					break;
				}
			}
		}
	}
	$audit->save("Guest details (Edit)");

	return true;
}

function api_pr_update_guest($pr_persona_id,$changes) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2 || $lDB->isMaster == "0") {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		return $api_instance->Error("Unknown contact");
	}

	try {
		list($changes, $rf_obj_guests) = api_pr_validate_guest_fields($changes);
	} catch(Exception $e) {
		return $api_instance->Error($e->getMessage());
	}

	try {
		api_pr_save_guest($pr_persona_id, $changes, $rf_obj_guests);
	} catch(Exception $e) {
		return $api_instance->Error($e->getMessage());
	}

	return true;
}

function api_rf_get_guest_field($search="") {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_obj_guest.rf_obj_guest_label LIKE '".$lDB->like($search)."'
		";
	}

	$list = array_map(function($item) use ($lDB) {
		if($item['rf_obj_guest_type_ind'] != DB_RF_OBJ_GUEST_NATION_LOOKUP) {
			$items = array_map(function($option) {
				return [
					'id'=>$option['rf_obj_guest_data_ix'],
					'name'=>$option['rf_obj_guest_data_content'],
					'sequence'=>$option['rf_obj_guest_data_sort_seq'],
					'default_yn'=>(!empty($option['rf_obj_guest_data_default_yn'])?true:false)
				];
			},$lDB->get("
				SELECT
					rf_obj_guest_data.rf_obj_guest_data_ix,
					rf_obj_guest_data.rf_obj_guest_data_content,
					rf_obj_guest_data.rf_obj_guest_data_sort_seq,
					rf_obj_guest_data.rf_obj_guest_data_default_yn
				FROM
					rf_obj_guest_data
				WHERE
					rf_obj_guest_data.rf_obj_guest_data_inactive_yn = '0'
					AND rf_obj_guest_data.rf_obj_guest_id = '".$lDB->escape($item['rf_obj_guest_ix'])."'
				ORDER BY
					rf_obj_guest_data.rf_obj_guest_data_sort_seq
			",6));
		} else {
			$items = array_map(function($item) {
				return [
					'id'=>$item['rf_country_ix'],
					'name'=>$item['rf_country_name'],
					'sequence'=>1,
					'default_yn'=>false
				];
			},$lDB->get("
				SELECT DISTINCT
					rf_country.rf_country_ix,
					rf_country.rf_country_name,
					rf_country.rf_country_code
				FROM
					rf_country
				WHERE
					rf_country.rf_country_inactive=0
				ORDER BY
					rf_country.rf_country_name
			",6));
		}
		return [
			'id'=>$item['rf_obj_guest_ix'],
			'name'=>$item['rf_obj_guest_label'],
			'type_id'=>$item['rf_obj_guest_type_ind'],
			'type'=>db_rf_obj_guest_type_ind_desc($item['rf_obj_guest_type_ind']),
			'sequence'=>$item['rf_obj_guest_sort_seq'],
			'mandatory_yn'=>(!empty($item['rf_obj_guest_mandatory_yn'])?true:false),
			'system_yn'=>(!empty($item['rf_obj_guest_system_yn'])?true:false),
			'items'=>$items
		];
	},$lDB->get("
		SELECT
			rf_obj_guest.rf_obj_guest_ix,
			rf_obj_guest.rf_obj_guest_label,
			rf_obj_guest.rf_obj_guest_type_ind,
			rf_obj_guest.rf_obj_guest_sort_seq,
			rf_obj_guest.rf_obj_guest_mandatory_yn,
			rf_obj_guest.rf_obj_guest_sys_code
		FROM
			rf_obj_guest
		WHERE
			rf_obj_guest.rf_obj_guest_inactive_yn = '0'
			$searchSQL
		ORDER BY
			rf_obj_guest.rf_obj_guest_sort_seq
	",6));

	return $list;
}

function api_rf_get_tripsheet_field($search="") {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_obj_trip.rf_obj_trip_label LIKE '".$lDB->like($search)."'
		";
	}

	$list = array_map(function($item) use ($lDB) {
		return [
			'id'=>$item['rf_obj_trip_ix'],
			'name'=>$item['rf_obj_trip_label'],
			'type_id'=>$item['rf_obj_trip_type_ind'],
			'type'=>db_rf_obj_trip_type_ind_desc($item['rf_obj_trip_type_ind']),
			'sequence'=>$item['rf_obj_trip_sort_seq'],
			'mandatory_yn'=>(!empty($item['rf_obj_trip_mandatory_yn'])?true:false),
			'items'=>array_map(function($option) {
				return [
					'id'=>$option['rf_obj_trip_data_ix'],
					'name'=>$option['rf_obj_trip_data_content'],
					'sequence'=>$option['rf_obj_trip_data_sort_seq'],
					'default_yn'=>(!empty($option['rf_obj_trip_data_default_yn'])?true:false)
				];
			},$lDB->get("
				SELECT
					rf_obj_trip_data.rf_obj_trip_data_ix,
					rf_obj_trip_data.rf_obj_trip_data_content,
					rf_obj_trip_data.rf_obj_trip_data_sort_seq,
					rf_obj_trip_data.rf_obj_trip_data_default_yn
				FROM
					rf_obj_trip_data
				WHERE
					rf_obj_trip_data.rf_obj_trip_data_inactive_yn = '0'
					AND rf_obj_trip_data.rf_obj_trip_id = '".$lDB->escape($item['rf_obj_trip_ix'])."'
				ORDER BY
					rf_obj_trip_data.rf_obj_trip_data_sort_seq
			",6)),
			'properties'=>array_map(function($option) {
				return [
					'id'=>$option['pr_business_id'],
					'name'=>$option['pr_name_last']
				];
			},$lDB->get("
				SELECT
					rf_obj_trip_prop.pr_business_id,
					IF(pr_persona.pr_persona_ix IS NULL,'Not property specific',pr_persona.pr_name_last) AS pr_name_last
				FROM
					rf_obj_trip_prop
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rf_obj_trip_prop.pr_business_id
				WHERE
					rf_obj_trip_prop.rf_obj_trip_id = '".$lDB->escape($item['rf_obj_trip_ix'])."'
			",6))
		];
	},$lDB->get("
		SELECT
			rf_obj_trip.rf_obj_trip_ix,
			rf_obj_trip.rf_obj_trip_label,
			rf_obj_trip.rf_obj_trip_type_ind,
			rf_obj_trip.rf_obj_trip_sort_seq,
			rf_obj_trip.rf_obj_trip_mandatory_yn
		FROM
			rf_obj_trip
		WHERE
			rf_obj_trip.rf_obj_trip_inactive_yn = '0'
			$searchSQL
		ORDER BY
			rf_obj_trip.rf_obj_trip_sort_seq
	",6));

	return $list;
}

function api_rf_get_guest_type($search="") {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}
	
	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_guest_type.rf_guest_type_name LIKE '".$lDB->like($search)."'
		";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			rf_guest_type.rf_guest_type_ix,
			rf_guest_type.rf_guest_type_name
		FROM
			rf_guest_type
		WHERE
			rf_guest_type.rf_guest_type_inactive_yn = '0'
			$searchSQL
	",6);

	$newList = array();
	foreach($list as $item) {
		array_push($newList,[
			'id'=>$item['rf_guest_type_ix'],
			'name'=>$item['rf_guest_type_name']
		]);
	}

	return $newList;
}

function api_rf_get_phone_type($search="") {
	global $lDB;

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_phone_type.rf_phone_type_desc LIKE '".$lDB->like($search)."'
		";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			rf_phone_type.rf_phone_type_ix,
			rf_phone_type.rf_phone_type_desc
		FROM
			rf_phone_type
		WHERE
			rf_phone_type.rf_phone_inactive_yn = '0'
			$searchSQL
	",6);

	$newList = array();
	foreach($list as $item) {
		array_push($newList,[
			'id'=>$item['rf_phone_type_ix'],
			'name'=>$item['rf_phone_type_desc']
		]);
	}

	return $newList;
}

function api_rf_get_suffix($search="") {
	global $lDB;

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_name_suffix.rf_suffix_desc LIKE '".$lDB->like($search)."'
		";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			rf_name_suffix.rf_name_suffix_ix,
			rf_name_suffix.rf_suffix_desc
		FROM
			rf_name_suffix
		WHERE
			rf_name_suffix.rf_suffix_inactive_yn = '0'
			$searchSQL
	",6);

	$newList = array();
	foreach($list as $item) {
		array_push($newList,[
			'id'=>$item['rf_name_suffix_ix'],
			'name'=>$item['rf_suffix_desc']
		]);
	}

	return $newList;
}

function api_rf_get_title($search="") {
	global $lDB;

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_title.rf_title_desc LIKE '".$lDB->like($search)."'
		";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			rf_title.rf_title_ix,
			rf_title.rf_title_desc
		FROM
			rf_title
		WHERE
			rf_title.rf_title_inactive_yn = '0'
			$searchSQL
	",6);

	$newList = array();
	foreach($list as $item) {
		array_push($newList,[
			'id'=>$item['rf_title_ix'],
			'name'=>$item['rf_title_desc']
		]);
	}

	return $newList;
}

function api_pr_user_is_internal() {
	global $lDB;

	// Returns the users internally linked contact ID
	$internalLink = $lDB->get("
					SELECT 
						pr_link.pr_link_to
					FROM
						pr_link
					WHERE
						pr_link.rf_link_type_id = 'RS1'
						AND pr_link.pr_link_from = '".addslashes($GLOBALS['pr_user_id'])."'
				",4);

	if(!empty($internalLink)) {
		return "1";
	}

	return "0";
}
