<?php

/*
 * $Id: api.contact.php,v 1.3 2013-08-19 17:02:51 light Exp $
 *
 * $Log: api.contact.php,v $
 * Revision 1.3  2013-08-19 17:02:51  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.2  2011-05-17 14:08:35  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2010-02-18 11:46:03  light
 * Bug #7051 - API changes (merged)
 *
 */

/**
 * api/functions.contact.php - API definitions related to contacts
 */ 
 
$this->Register([
	'pr_get_contact'=>[
		'doc'=>"Returns an array of contacts based on the optional filter criteria of 'last name' and 'first name'. Additionally, agent information can also be returned when the agent role is set to 1. If the agent role filter is set to 1, only agents are returned.",
		'signature'=>"?string+struct,?string,?string,?string,?string,?string,?string+struct,?string+struct",
		'access'=>[
			["function"=>54,"level"=>5]
		]
	],
	'pr_create_contact'=>[
		'doc'=>"Returns the id of a newly created contact given a structure containing the 'name' and 'value' of the fileds to be updated. Available fields are 'first_name', 'last_name', 'title_id', 'suffix_id', 'email', 'post_*' and 'phys_*'",
		'signature'=>"struct",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'pr_update_contact'=>[
		'doc'=>"Returns true on a successful update given a contact id and structure containing the 'name' and 'value' of the fileds to be updated. Available fields are 'first_name', 'last_name', 'title_id', 'suffix_id', 'email', 'post_*' and 'phys_*'",
		'signature'=>"string,struct",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'pr_create_phone'=>[
		'doc'=>"Returns the id of a newly created phone record when passed a contact id, phone number, phone type, and optionally a phone description, and whether to make the phone number the default for the contact",
		'signature'=>"string,string,string,?string,?string+boolean",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'pr_update_phone'=>[
		'doc'=>"Updates an existing phone record when passed a contact id, phone id, phone number, phone type, phone description, and whether to make the phone number the default for the contact",
		'signature'=>"string,string,string,string,?string,?string+boolean",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'pr_delete_phone'=>[
		'doc'=>"Deletes an existing phone record when passed a contact id and phone id",
		'signature'=>"string,string",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'pr_update_guest'=>[
		'doc'=>"Returns true on a successful update given a contact id and structure containing the 'name' and 'value' of the fileds to be updated. Available fields are determined using rf_get_guest_field",
		'signature'=>"string,array+struct",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'rf_get_guest_field'=>[
		'doc'=>"When passed a valid username and password, returns a list of guest fields. Optionally, a search filter can be provided on guest field name.",
		'signature'=>"?string"
	],
	'rf_get_tripsheet_field'=>[
		'doc'=>"When passed a valid username and password, returns a list of tripsheet fields. Optionally, a search filter can be provided on tripsheet field name.",
		'signature'=>"?string"
	],
	'rf_get_guest_type'=>[
		'doc'=>"When passed a valid username and password, returns a list of guest types. Optionally, a search filter can be provided on guest type name.",
		'signature'=>"?string"
	],
	'rf_get_phone_type'=>[
		'doc'=>"When passed a valid username and password, returns a list of phone types. Optionally, a search filter can be provided on phone type name.",
		'signature'=>"?string"
	],
	'rf_get_suffix'=>[
		'doc'=>"When passed a valid username and password, returns a list of suffixes. Optionally, a search filter can be provided on suffix name.",
		'signature'=>"?string"
	],
	'rf_get_title'=>[
		'doc'=>"When passed a valid username and password, returns a list of titles. Optionally, a search filter can be provided on title name.",
		'signature'=>"?string"
	],
	'pr_user_is_internal'=>[
		'doc'=>"Checks if the user has an internal link. Returns string 1 or 0."
	]
]);
