<?php

/**
 * api/functions.default.func.php - API functions related to defaults
 */ 

require_once(__DIR__ . '/api.rate.php');

function api_ac_get_default() {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	$defaultArray = array();

	$principal = $lDB->get("
		SELECT
			rf_default.rf_principal_id AS id,
			pr_persona.pr_name_last AS last_name,
			pr_persona.pr_name_first AS first_name,
			pr_persona.pr_email AS email
		FROM
			rf_default
			LEFT JOIN pr_persona AS pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_principal_id
	",1);

	$defaultArray['principal'] = array(
		"id" => $principal['id'],
		"name" => trim($principal['first_name'].' '.$principal['last_name']),
		"email" => $principal['email']
	);

	$resOffice = $lDB->get("
		SELECT
			rf_default.rf_res_office_id AS id,
			pr_persona.pr_name_last AS last_name,
			pr_persona.pr_name_first AS first_name,
			pr_persona.pr_email AS email
		FROM
			rf_default
			LEFT JOIN pr_persona AS pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_res_office_id
	",1);

	$resOfficeFax = $lDB->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, 
			rf_phone_type 
		WHERE 
			pr_phone.pr_persona_id = '" . $resOffice['id'] . "'
		AND 
			pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix 
		AND 
			rf_phone_type.rf_phone_type_sys_code = '1' 
	", 4);

	$resOfficeTel = $lDB->get("
		SELECT 
			pr_phone.pr_phone_number 
		FROM 
			pr_phone 
		WHERE 
			pr_phone.pr_persona_id = '" . $resOffice['id'] . "'
		AND 
			pr_phone.pr_default_yn = '1'
	", 4);

	$defaultArray['resOffice'] = array(
		"id" => $resOffice['id'],
		"name" => trim($resOffice['first_name'].' '.$resOffice['last_name']),
		"email" => $resOffice['email'],
		"fax" => $resOfficeFax,
		"tel" => $resOfficeTel
	);

	return $defaultArray;
}
