<?php

/*
 * $Id: api.extra.func.php,v 1.1 2013-08-19 17:02:52 light Exp $
 * 
 * $Log: api.extra.func.php,v $
 * Revision 1.1  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 */

/**
 * api/api.extra.func.php - API functions related to extras
 */
 
require_once(__DIR__ . '/../db.pr_business.php');
require_once(__DIR__ . '/../db.ac_extra_category.php');
require_once(__DIR__ . '/../db.rv_reservation.php');
require_once(__DIR__ . '/../db.pr_persona.php');
require_once(__DIR__ . '/../db.rv_extra.php');
require_once(__DIR__ . '/../db.ac_extra.php');

function api_ac_get_extra_category($search="",$types=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;
	
	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}
	
	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL .= "
			AND ac_extra_category.ac_extra_cat_desc LIKE '".addslashes(str_replace("*","%",$search))."'
		";
	}

	if (is_array($types)){
		if (!empty($types)){
			foreach($types as $key=>$type) {
				if ($type != "0" && $type != "1" && $type != "2" && $type != "3"){
					return $api_instance->Error("Invalid type.");
				}
			}
			
			$searchSQL .= "
				AND ac_extra_category.ac_extra_cat_ind IN ('".join("','",$types)."') 
			";
		}
	}

	$list = $lDB->get("
		SELECT 
			ac_extra_category.ac_extra_category_ix,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra_category.ac_extra_cat_ind
		FROM
			ac_extra_category
		WHERE
			ac_extra_category.ac_extra_category_inactive_yn=0
			$searchSQL
	",2);
	
	$newList = array();
	foreach($list as $item) {
		array_push($newList,array('id'=>$item['ac_extra_category_ix'],'desc'=>$item['ac_extra_cat_desc'],'type'=>$item['ac_extra_cat_ind']));
	}

	return $newList;
}

function api_ac_get_extra($search="",$categories=false,$types=false,$properties=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;
	
	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL .= "
			AND ac_extra.ac_ext_desc LIKE '".addslashes(str_replace("*","%",$search))."'
		";
	}

	if (is_array($categories)){
		if(!empty($categories)){
			foreach($categories as $key=>$category) {
				if (!db_ac_extra_category_exists($category)){
					return $api_instance->Error("Invalid category.");
				}
			}
			
			$searchSQL .= "
				AND ac_extra.ac_extra_category_id IN ('".join("','",$categories)."') 
			";
		}
	}	
	
	if (is_array($types)){
		if(!empty($types)){
			foreach($types as $key=>$type) {
				if ($type != "0" && $type != "1" && $type != "2" && $type != "3"){
					return $api_instance->Error("Invalid type.");
				}
			}
			
			$searchSQL .= "
				AND ac_extra_category.ac_extra_cat_ind IN ('".join("','",$types)."') 
			";
		}
	}
	
	if (is_array($properties)){
		if(!empty($properties)){
			foreach($properties as $key=>$property) {
				if (!db_pr_business_exists($property)){
					return $api_instance->Error("Invalid property.");
				}
			}
			
			$searchSQL .= "
				AND ac_extra_prop.pr_business_id IN ('".join("','",$properties)."') 
			";
		}
	}	

	$list = $lDB->get("
		SELECT DISTINCT
			ac_extra.ac_extra_ix,
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra_category.ac_extra_cat_ind,
			ac_extra.ac_ext_note,
			ac_extra.ac_ext_note_internal,
			ac_extra.ac_ext_amount,
			rf_currency.rf_currency_symbol
		FROM
			ac_extra
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		WHERE
			1
			$searchSQL
	",2);

	$newList = array();
	foreach($list as $item) {
		if(!empty($item['rf_currency_symbol'])) {
			$currency = $item['rf_currency_symbol'];
		} else {
			$currency = "";
		}
		array_push($newList,array('id'=>$item['ac_extra_ix'],'desc'=>$item['ac_ext_desc'],'cat_desc'=>$item['ac_extra_cat_desc'],'type'=>$item['ac_extra_cat_ind'],'note'=>$item['ac_ext_note'],'memo'=>$item['ac_ext_note_internal'],'cost'=>$item['ac_ext_amount'],'currency'=>$currency));
	}

	return $newList;
}

function api_rv_get_extra($rv_reservation_id) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}

	$list = $lDB->get("
		SELECT
			rv_extra.rv_extra_ix AS 'id',
			rv_extra.ac_extra_id AS 'extra_id',
			ac_extra.ac_ext_desc AS 'extra_desc',
			ac_extra_category.ac_extra_cat_ind AS 'type',
			rv_extra.rv_extra_ref AS 'reference',
			rv_extra.rv_extra_date_serv AS 'service_date',
			rv_extra.pr_business_id AS 'property',
			rv_extra.pr_supplier_id AS 'supplier',
			rv_extra.rv_extra_units AS 'qty',
			rv_extra.rv_extra_charge AS 'cost',
			rf_currency.rf_currency_symbol AS 'currency',
			rv_extra.rv_extra_discount AS 'discount',
			rv_extra.rv_extra_comm_rec AS 'comm_rec',
			rv_extra.rv_extra_comm_pay AS 'comm_pay',
			rv_extra.rv_extra_note AS 'note',
			rv_extra.rv_extra_note_internal AS 'memo',
			rv_extra.rv_extra_travel_eta AS 'eta',
			rv_extra.rv_extra_travel_etd AS 'etd',
			rv_extra.rv_extra_adult_count AS 'adults',
			rv_extra.rv_extra_child_count AS 'children',
			rv_extra.rv_extra_date_depart AS 'depart_date'
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		WHERE
			rv_extra.rv_reservation_id = '$rv_reservation_id'
			AND rv_extra.rv_extra_void_ind = '0'
	",6);

	foreach($list as $key=>$item) {
		if(empty($item['currency'])) {
			$item['currency'] = "";
		}
		if($item['type'] != DB_RV_EXTRA_TRAVEL) {
			unset($item['eta']);
			unset($item['etd']);
		}
		if($item['type'] != DB_RV_EXTRA_ACCOMMODATION) {
			unset($item['adults']);
			unset($item['children']);
			unset($item['depart_date']);
		} else {
			$item['arrive_date'] = $item['service_date'];
			unset($item['service_date']);
		}
		$list[$key] = $item;
	}

	return $list;
}

function api_rv_create_extra($rv_reservation_id,$ac_extra_id,$reference=false,$service_date=false,$property_id=false,$supplier=false,$quantity=false,$cost=false,$discount=0,$comm_rec=0,$comm_pay=0,$note=false,$memo=false,$param1=false,$param2=false,$param3=false){
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}
	
	$reservation = $lDB->get("
		SELECT 
			rv_reservation.rv_invoice_persona_id
		FROM 
			rv_reservation 
		WHERE 
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",1);
	
	$itineraries = $lDB->get("
		SELECT 
			rv_reservation_item.pr_business_id,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive
		FROM 
			rv_reservation_item 
		WHERE 
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		ORDER BY
			rv_reservation_item.rv_item_date_arrive
	",2);	
	
	if (!db_ac_extra_exists($ac_extra_id)){
		return $api_instance->Error("Extra does not exist.");
	} else {
		$extra_cat_ind = $lDB->get("
			SELECT 
				ac_extra_category.ac_extra_cat_ind
			FROM
				ac_extra_category
				INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
			WHERE
				ac_extra.ac_extra_ix = '$ac_extra_id' 
		",4);
	}

	$eta = "";
	$etd = "";
	$adults = "";
	$children = "";
	$departure = "";
	switch($extra_cat_ind){
		case 0:
		case 1:
			if (empty($service_date)){
				$service_date = date("Y-m-d",time());
			} else {
				$service_date = strtotime($service_date);
				if($service_date == -1) {
					return $api_instance->Error("Invalid service date ($service_date)");
				}
				$service_date = date("Y-m-d",$service_date);	
			}		
			break;
		case 2:
			if (empty($service_date)){
				$service_date = date("Y-m-d",time());
			} else {
				$service_date = strtotime($service_date);
				if($service_date == -1) {
					return $api_instance->Error("Invalid service date ($service_date)");
				}
				$service_date = date("Y-m-d",$service_date);	
			}		
		
			$eta = $param1;
			$etd = $param2;
			break;
		case 3:
			$adults = $param1;
			$children = $param2;
			$departure = $param3;
			
			$defaults = $lDB->get("
				SELECT 
					ac_extra.ac_ext_adult_count,
					ac_extra.ac_ext_child_count,
					ac_extra.ac_ext_nights
				FROM
					ac_extra
				WHERE
					ac_extra.ac_extra_ix = '$ac_extra_id' 
			",1);			

			if($adults != "0" && empty($adults)){
				$adults = $defaults['ac_ext_adult_count'];
			}	else {
				if(!is_numeric($adults) || (int)$adults != $adults) {
					return $api_instance->Error("Invalid adult count.");
				} else {
					$adults = intval($adults);
				}
			}			
			
			if($children != "0" && empty($children)){
				$children = $defaults['ac_ext_child_count'];
			}	else {
				if(!is_numeric($children) || (int)$children != $children) {
					return $api_instance->Error("Invalid child count.");
				} else {
					$children = intval($children);
				}
			}	

			if (empty($service_date)){

				$service_date = $lDB->get("
					SELECT 
						rv_reservation.rv_date_arrive
					FROM
						rv_reservation
					WHERE
						rv_reservation.rv_reservation_ix = '$rv_reservation_id' 
				",4);
			} else {
				$service_date = strtotime($service_date);
				if($service_date == -1) {
					return $api_instance->Error("Invalid arrival date ($service_date)");
				}
				$service_date = date("Y-m-d",$service_date);	
			}			
			
			if(empty($departure)) {
				$departure = date("Y-m-d",strtotime($service_date." + ".$defaults['ac_ext_nights']." days"));
			} else {
				$departure = strtotime($departure);
				if($departure == -1) {
					return $api_instance->Error("Invalid departure date ($departure)");
				}
				$departure = date("Y-m-d",$departure);
			}			
			break;	
	}
	
	if (!empty($reference)){
		$reference = addslashes($reference);
	}

	if (!empty($property_id)){
		if (!db_pr_business_exists($property_id)){
			return $api_instance->Error("Invalid property.");
		}	
		$rv_business_inv_id = db_pr_business_get_billing($property_id);
	}


	if (!empty($supplier)){
		if (!db_pr_persona_exists($supplier)){
			return $api_instance->Error("Invalid supplier.");
		}	
	}

	if (!empty($quantity)){
		if (!is_numeric($quantity)){
			return $api_instance->Error("Invalid quantity.");
		}
	} else {
		$quantity = 1;
	}
	
	if (empty($cost)){
		
		$cost = $lDB->get("
			SELECT 
				ac_extra.ac_ext_amount
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '$ac_extra_id'
		",4);
		
		$currency_id = $lDB->get("
			SELECT 
				ac_extra.rf_currency_id
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '$ac_extra_id' 
		",4);
		if (!empty($currency_id)){
			$chargeable = true;
		}		
		
	} else {
		if (!is_numeric($cost)){
			return $api_instance->Error("Invalid cost.");
		} else {
			$currency_id = $lDB->get("
				SELECT 
					ac_extra.rf_currency_id
				FROM
					ac_extra
					INNER JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
				WHERE
					ac_extra.ac_extra_ix = '$ac_extra_id' 
			",4);
			if (empty($currency_id)){
				return $api_instance->Error("This is a non-chargeable extra.");
			} else {
				$chargeable = true;
			}
		}
	}

	if (!empty($discount)){
		if (!is_numeric($discount)){
			return $api_instance->Error("Invalid discount.");
		}	
	} else {
		$discount = 0;
	}
	
	if (!empty($comm_rec)){	
		if (!is_numeric($comm_rec)){
			return $api_instance->Error("Invalid comm_rec.");
		}
	} else {
		$comm_rec = 0;
	}
	
	if (!empty($comm_pay)){	
		if (!is_numeric($comm_pay)){
			return $api_instance->Error("Invalid comm_pay.");
		}
	} else {
		$comm_pay = 0;
	}
	
	if (empty($note)){
		$note = $lDB->get("
			SELECT 
				ac_extra.ac_ext_note
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '$ac_extra_id'
		",4);		
	}
	
	if (empty($memo)){
		$memo = $lDB->get("
			SELECT 
				ac_extra.ac_ext_note_internal
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '$ac_extra_id'
		",4);		
	}

	$taxID = $lDB->get("
		SELECT
			ac_extra.rf_tax_id,
			ac_extra.rf_tax_ind
		FROM
			ac_extra
		WHERE
			ac_extra.ac_extra_ix = '$ac_extra_id'
	",1);

	if ($chargeable && empty($property_id)){
		// If this is a chargeable extra and there is no property specified, use the billing unit from the first itinerary on the res.
		$rv_business_inv_id = db_pr_business_get_billing($itineraries[0]['pr_business_id']);
	}

	// Ignore passed percentage, look up percentage from Tax Code Table
	$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);
	
	$extraId = db_rv_extra_insert($rv_reservation_id, $ac_extra_id,$property_id,$quantity,$service_date,$cost,$discount,$taxPerc,$comm_rec,$comm_pay,$note,$memo,false,$currency_id,$currency_id,false,false,$rv_business_inv_id,$eta,$etd,$adults,$children,$departure,$reference,false,$supplier);
	db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
	verify_extra($extraId);
	
	// Folio
	if ($chargeable){
		$fn_folio_id = db_fn_folio_insert_extra($extraId, "", $reservation['rv_invoice_persona_id']);
		db_rv_extra_set_folio($extraId, $fn_folio_id);
	}

	return $extraId;
	
	
}

function api_rv_delete_extra($rv_reservation_id,$rv_extra_id,$rv_extra_void_reason) {
	global $api_instance;
	global $userStatusId;
	global $lDB;
	global $dbcode;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}	

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}

	if(!db_rv_extra_exists($rv_extra_id) || $lDB->get("SELECT rv_extra_void_ind FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4) != 0) {
		return $api_instance->Error("Extra does not exist.");
	}

	if($rv_reservation_id != $lDB->get("SELECT rv_reservation_id FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4)) {
		return $api_instance->Error("Extra $rv_extra_id does not belong to reservation $rv_reservation_id.");
	}

	if(empty($rv_extra_void_reason)) {
		return $api_instance->Error("Reason for deletion required");
	}

	$rv_extra_db = $lDB->get("SELECT rv_extra_db FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
	$rv_extra_trf_yn = $lDB->get("SELECT rv_extra_trf_yn FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);

	$canEdit = canEditDB($rv_extra_db) || ($dbcode == $rv_extra_db && $rv_extra_trf_yn == "0" && $dbcode[0] != "W");
	if(!$canEdit) {
		return $api_instance->Error("Extra edit access denied.");
	}

	if(!db_rv_extra_delete($rv_extra_id,$rv_extra_void_reason)) {
		return $api_instance->Error($GLOBALS['db_rv_extra_error']);
	}
	return true;
}
