<?php

/*
 * $Id: api.payment.func.php,v 1.1 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.payment.func.php,v $
 * Revision 1.1  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 *
 */


/**
 * api/api.payment.php - API functions related to payments
 */

require_once(__DIR__ . '/../db.rv_payment_gateway.php');
require_once(__DIR__ . '/../db.rv_payment.php');

function api_rv_get_total_outstanding($rv_reservation_id=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	} 

	$totals = $GLOBALS['lDB']->get("
		SELECT
			rv_amt_accomm_gross,
			rv_amt_extra_gross,
			rv_amt_travel_gross
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '" . $rv_reservation_id . "'
	",1);
	
	if($totals['rv_amt_accomm_gross'] == null || $totals['rv_amt_extra_gross'] == null || $totals['rv_amt_travel_gross'] == null) {
		return "tba";
	}	

	$folioList = $lDB->get("
		SELECT 
			fn_folio.fn_folio_amount,
			fn_folio.fn_folio_amt_paid
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		WHERE
			fn_folio.rf_currency_id = rv_reservation.rv_invoice_currency_id
			AND fn_folio.rv_reservation_id = '".addslashes($rv_reservation_id)."'
	",2);	

	$newList = array();
	$totalOutstanding = 0;
	foreach($folioList as $item) {
		$totalOutstanding += ($item['fn_folio_amount'] - $item['fn_folio_amt_paid']);
	}

	return $totalOutstanding;
}

function api_rv_get_payment_plan_outstanding($rv_reservation_id, $rv_pay_plan_date=false) {
	global $api_instance;
	global $lDB;
	global $calAgentId;
	global $userStatusId;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return $api_instance->Error("Reservation does not exist.");
	}

	if($userStatusId < 2) {
		$rv_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
		if($rv_agent_id != $calAgentId) {
			return $api_instance->Error("Reservation does not exist.");
		}
	}

	if(!empty($rv_pay_plan_date)) {
		$rv_pay_plan_date = strtotime($rv_pay_plan_date);
		if($rv_pay_plan_date == -1) {
			return $api_instance->Error("Invalid date");
		}		
	} else {
		$rv_pay_plan_date = time();
	}
	$rv_pay_plan_date = date("Y-m-d",$rv_pay_plan_date);

	$rv_reservation_db = $lDB->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	$rf_db_env_type_ind = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$rv_reservation_db'",4);	
	$rv_invoice_currency_id  = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation	WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	$rf_currency_symbol = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$rv_invoice_currency_id'",4);

	$totals = $GLOBALS['lDB']->get("
		SELECT
			rv_amt_accomm_gross,
			rv_amt_extra_gross,
			rv_amt_travel_gross
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '" . $rv_reservation_id . "'
	",1);
	
	if($totals['rv_amt_accomm_gross'] == null || $totals['rv_amt_extra_gross'] == null || $totals['rv_amt_travel_gross'] == null) {
		return array('amount'=>"tba",'currency'=>$rf_currency_symbol);
	}

	$total = $lDB->get("
		SELECT 
			SUM(fn_folio_amount)
		FROM
			fn_folio
			INNER JOIN rf_database ON fn_folio.fn_folio_db = rf_database.rf_db_code
		WHERE
			rf_database.rf_db_env_type_ind = '$rf_db_env_type_ind'
			AND fn_folio.rv_reservation_id='$rv_reservation_id'		 
			AND fn_folio.rf_currency_id = '$rv_invoice_currency_id'
	",4);	

	$totalPlanned = $lDB->get("
		SELECT
			SUM(rv_pay_plan_amount) AS rv_pay_plan_amount
		FROM
			rv_pay_plan_item
		WHERE
			rv_pay_plan_item.rv_reservation_id = '$rv_reservation_id'
	",4);

	$latest = $lDB->get("
		SELECT
			MAX(rv_pay_plan_date) AS rv_pay_plan_date
		FROM
			rv_pay_plan_item
		WHERE
			rv_pay_plan_item.rv_reservation_id = '$rv_reservation_id'
	",4);
	

	$unallocated = $total - $totalPlanned;

	$payments = $lDB->get("
		SELECT
			SUM(rv_payment_item.rv_payment_item_amt) AS rv_payment_item_amt
		FROM
			rv_payment_item
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
		WHERE
			fn_folio.rf_currency_id = '$rv_invoice_currency_id'
			AND rv_payment_item.rv_reservation_id = '$rv_reservation_id'
	",4);

	$planned = $lDB->get("
		SELECT
			SUM(rv_pay_plan_amount) AS rv_pay_plan_amount
		FROM
			rv_pay_plan_item
		WHERE
			rv_pay_plan_item.rv_reservation_id = '$rv_reservation_id'
			AND rv_pay_plan_item.rv_pay_plan_date <= '$rv_pay_plan_date'
	",4);

	$due = $planned - $payments;
	if($rv_pay_plan_date >= $latest) {
		$due += $unallocated;
	}
	if($due < 0) { $due = 0; }

	fixAmtDisplay($due,2);

	return array('amount'=>$due,'currency'=>$rf_currency_symbol);
}

function api_rv_create_payment_gateway($rv_reservation_id,$amount) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}

	$rv_invoice_currency_id = $lDB->get("
		SELECT 
			rv_reservation.rv_invoice_currency_id
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",4);

	if (!is_numeric($amount) || $amount <= 0){
		return $api_instance->Error("Invalid amount.");	
	}

	$folios = $lDB->get("
		SELECT 
				fn_folio.fn_folio_ix
			FROM
				fn_folio
			WHERE
	        	fn_folio.rv_reservation_id = '".addslashes($rv_reservation_id)."'
	",3);

	// Get sys code account ID
	$pg_account_id = $lDB->get("
		SELECT
			pg_account_ix
		FROM
			pg_account
		WHERE
			pg_account_sys_code = '1'
	",4);

	$payment_gateway_id = db_rv_payment_gateway_create($pg_account_id, $rv_invoice_currency_id, $amount, $folios);

	return $payment_gateway_id;

}

function api_rv_update_payment_gateway($rv_payment_gateway_id,$rv_payment_gateway_ind,$amount,$rv_payment_gateway_ref,$log=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_payment_gateway_exists($rv_payment_gateway_id)){
		return $api_instance->Error("Payment gateway does not exist.");
	}

	switch($rv_payment_gateway_ind) {
	case DB_RV_PAYMENT_GATEWAY_SUCCESS:
	case DB_RV_PAYMENT_GATEWAY_DECLINED:
	case DB_RV_PAYMENT_GATEWAY_ERROR:
		break;
	case DB_RV_PAYMENT_GATEWAY_PENDING:
	default:
		return $api_instance->Error("Invalid status.");
	}

	if (!is_numeric($amount) || $amount < 0){
		return $api_instance->Error("Invalid amount.");	
	}

	if ($rv_payment_gateway_ref == ""){
		return $api_instance->Error("Invalid payment gateway reference.");	
	}	

	if (db_rv_payment_gateway_update($rv_payment_gateway_id,$rv_payment_gateway_ind,$log,$rv_payment_gateway_ref,$amount)){
		return true;
	} else {
		return false;
	}
}

function api_rv_create_payment_by_gateway($rv_reservation_id,$rv_payment_gateway_id,$rv_payment_amt_rec,$pr_persona_id=false,$rv_pmnt_ref=false,$rv_pmnt_note=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	$result = array();

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if ($pr_persona_id){
		if ($pr_persona_id != "" && $pr_persona_id != "0"){
			if (!db_pr_persona_exists($pr_persona_id)){
				return $api_instance->Error("Invalid payer.");	
			}
		} elseif ($pr_persona_id == "0"){
			$pr_persona_id = "";
		}		
	} else {
		$pr_persona_id = "";
	}
	

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}

	if (!db_rv_payment_gateway_exists($rv_payment_gateway_id)){
		return $api_instance->Error("Payment gateway ID does not exist.");	
	}

	if (!is_numeric($rv_payment_amt_rec) || $rv_payment_amt_rec <= 0){
		return $api_instance->Error("Invalid amount.");	
	}

	$folioList = $lDB->get("
		SELECT 
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_amount,
			fn_folio.fn_folio_amt_paid
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		WHERE
			fn_folio.rf_currency_id = rv_reservation.rv_invoice_currency_id
			AND fn_folio.rv_reservation_id = '".addslashes($rv_reservation_id)."'
	",2);	

	$balance = $rv_payment_amt_rec;
	foreach($folioList as $folio) {
		$balance = $balance - ($folio['fn_folio_amount'] - $folio['fn_folio_amt_paid']);
	}

	if ($balance > 0){
		return $api_instance->Error("Overpayment.");
	}

	$rf_mthd_pmnt_id = $lDB->get("
		SELECT
			rf_mthd_pmnt_id
		FROM
			pg_account
		WHERE
			pg_account_sys_code = '1'
	",4);

	if ($rf_mthd_pmnt_id == ""){
		return $api_instance->Error("Payment method has not been set for default payment gateway.");	
	}

	$rv_invoice_currency_id = $lDB->get("
		SELECT
			rv_invoice_currency_id
		FROM
			rv_reservation
		WHERE
			rv_reservation_ix = '$rv_reservation_id'
	",4);	

	$rf_bank_id = $lDB->get("
		SELECT 
			pg_acc_currency.rf_bank_id
		FROM
			pg_acc_currency
		WHERE
			pg_acc_currency.rf_currency_id = '$rv_invoice_currency_id'
	",4);		

	$rv_payment_id = db_rv_payment_insert($pr_persona_id,date("Y-m-d"),$rf_bank_id,$rf_mthd_pmnt_id,$rv_pmnt_ref,$rv_pmnt_note);
	$left = $rv_payment_amt_rec;
	foreach($folioList as $folio) {
		if( ($left - $folio['fn_folio_amount']) < 0) {
			$amount = $left;
		} else {
			$amount = $folio['fn_folio_amount'];
		}
		if($amount > 0) {
			$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$folio['fn_folio_ix'],$amount,1,false,false,$rv_payment_gateway_id);
		}

		$left -=  $amount;

		if ($left == 0) {
			break;
		}
	}	
	
	recalcTotals($rv_reservation_id);
	ammendReservation($rv_reservation_id,"Payment");	

	$outstanding = api_rv_get_total_outstanding($rv_reservation_id);

	$result[] = array('id'=>$rv_payment_id,'amount'=>$rv_payment_amt_rec,'outstanding'=>$outstanding);

	return $result;
}

function api_rv_has_payment_by_gateway($rv_reservation_id,$rv_payment_gateway_id) {
	global $api_instance;
	global $userStatusId;

	if ($userStatusId < 2){
		return $api_instance->Error("Access denied.");
	}

	if (!db_rv_reservation_exists($rv_reservation_id)){
		return $api_instance->Error("Reservation does not exist.");
	}

	if (!db_rv_payment_gateway_exists($rv_payment_gateway_id)){
		return $api_instance->Error("Payment gateway ID does not exist.");	
	}

	return db_rv_payment_item_exists_by_gateway_and_reservation($rv_payment_gateway_id, $rv_reservation_id) ? '1' : '0';
}

function api_sc_record_payment_access() {
	global $lDB;

	$recordPaymentsAccess = $lDB->get("
		SELECT
			sc_fun_grp_level
		FROM
			sc_fun_group
		WHERE
			sc_fun_group.sc_group_id = '$GLOBALS[sc_group_id]'
			AND sc_fun_group.sc_function_id = '69'
	",4);

	if($recordPaymentsAccess >= 10) {
		return "1";
	}

	return "0";
}

function api_pg_payment_gateway_valid() {
	global $lDB;

	// Returns "pg_account_ix" of valid payment gateways.
	$validPaymentGateways = $lDB->get("
						SELECT DISTINCT pg_account.pg_account_ix 
						FROM   pg_account 
						       INNER JOIN rf_mthd_pmnt 
						               ON rf_mthd_pmnt.rf_mthd_pmnt_ix = pg_account.rf_mthd_pmnt_id 
						       INNER JOIN pg_acc_method 
						               ON pg_acc_method.pg_account_id = pg_account.pg_account_ix 
						WHERE  pg_account.pg_account_sys_code = '1' 
						       AND pg_account.pg_account_inactive_yn = '0'
				",5);

	if(count($validPaymentGateways) == 1) { // If there is only one valid gateway
		return "1";
	}

	return "0";
}