<?php

/*
 * $Id: api.payment.php,v 1.4 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.payment.php,v $
 * Revision 1.4  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.3  2013-03-13 18:34:32  light
 * Bug #8035 - API: Online payments enhancement (access control) and fix (parameter count)
 *
 * Revision 1.2  2012-10-15 14:05:15  light
 * Bug #6924 - Stock API to differentiate between confirmed & provisional reservations
 *
 * Revision 1.1  2012-08-06 16:49:27  light
 * Bug #7998 - Create online payments from API
 *
 */

/**
 * api/functions.payment.php - API definitions related to payments
 */ 

$this->Register(array(
	'rv_get_total_outstanding'=>array(
		'doc'=>"Returns the total amount outstanding on a reservation",
		'signature'=>"string",
		'access'=>array(
			array("function"=>69,"level"=>10)
		)
	),
	'rv_get_payment_plan_outstanding'=>array(
		'doc'=>"Given a username, password and reservation number, returns the amount due as of the current date based on the payment plan. A forth optional paramter may be used to specify a specific date on which the amount outstanding should be calculated for. This function will not work on multi-currency reservations or reservations for with the user does not have access",
		'signature'=>("string,?string")
	),
	'rv_create_payment_gateway'=>array(
		'doc'=>"Creates and returns a payment gateway ID",
		'signature'=>"string,string",
		'access'=>array(
			array("function"=>69,"level"=>10)
		)
	),
	'rv_update_payment_gateway'=>array(
		'doc'=>"Updates a payment gateway ID with a status",
		'signature'=>"string,string,string,string,?string",
		'access'=>array(
			array("function"=>69,"level"=>10)
		)
	),
	'rv_create_payment_by_gateway'=>array(
		'doc'=>"Creates a payment",
		'signature'=>"string,string,string,?string,?string,?string",
		'access'=>array(
			array("function"=>69,"level"=>10)
		)
	),
	'rv_has_payment_by_gateway'=>array(
		'doc'=>"Checks whether a payment exists for the gateway",
		'signature'=>"string,string",
		'access'=>array(
			array("function"=>69,"level"=>10)
		)
	),
	'sc_record_payment_access'=>array(
		'doc'=>"Checks if the user has access to the “Payments: Record” function. Returns string 1 or 0."
	),
	'pg_payment_gateway_valid'=>array(
		'doc'=>"Checks if there is a single valid payment gateway. Returns string 1 or 0."
	)
));
