<?php

/**
 * api/api.pos.func.php - Point of sales API functions
 */

require_once(__DIR__ . '/../db.pr_business.php');
require_once(__DIR__ . '/../db.pr_guest.php');
require_once(__DIR__ . '/../db.rf_currency.php');
require_once(__DIR__ . '/../db.rv_extra.php');
require_once(__DIR__ . '/../functions.pos.php');

function api_ac_get_pos($nameSearch=false, $environmentSearch=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if($userStatusId < 2) {
		return $api_instance->Error("Access denied.");
	}

	$searchSQL = "";
	if($nameSearch !== false && trim($nameSearch) != "") {
		$searchSQL .= "
			AND (
				ac_pos.ac_pos_name LIKE '".addslashes(str_replace("*","%",$nameSearch))."'
				OR ac_pos.ac_pos_name_rr LIKE '".addslashes(str_replace("*","%",$nameSearch))."'
			)
		";
	}
	if($environmentSearch !== false && trim($environmentSearch) != "") {
		$searchSQL .= "
			AND rf_db_business.rf_db_code LIKE '".addslashes(str_replace("*","%",$environmentSearch))."'
		";
	}

	$list = $lDB->get("
		SELECT
			ac_pos.ac_pos_ix,
			ac_pos.ac_pos_name,
			ac_pos.ac_pos_name_rr,
			rf_db_business.rf_db_code
		FROM
			ac_pos
			INNER JOIN rf_db_business ON rf_db_business.pr_business_id = ac_pos.pr_business_id
		WHERE
			ac_pos.ac_inactive_yn = '0'
			$searchSQL
		ORDER BY
			ac_pos.ac_pos_name
	",6);

	$newList = [];
	foreach($list as $item) {
		$newList[] = [
			'id' => $item['ac_pos_ix'],
			'code' => $item['ac_pos_name'],
			'name' => $item['ac_pos_name_rr'],
			'environment' => $item['rf_db_code'],
			'mappings' => array_map(function($mapping) {
				return [
					'code' => $mapping['ac_pos_stock_code'],
					'extra_id' => $mapping['ac_extra_id'],
					'extra_name' => $mapping['ac_ext_desc']
				];
			},$lDB->get("
				SELECT
					ac_pos_stock.ac_pos_stock_code,
					ac_pos_stock.ac_extra_id,
					ac_extra.ac_ext_desc
				FROM
					ac_pos_map
					INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos_map.ac_pos_stock_id
					INNER JOIN ac_extra ON ac_extra.ac_extra_ix = ac_pos_stock.ac_extra_id
				WHERE
					ac_pos_map.ac_pos_id = '" . $lDB->escape($item['ac_pos_ix']) . "'
			",6))
		];
	}
	unset($list);

	return $newList;
}

function api_rv_get_room($pr_business_id, $ac_accomm_type_ids=false, $search=false) {
	global $api_instance;
	global $lDB;
	global $userStatusId;

	if($userStatusId < 2) {
		return $api_instance->Error("Access denied.");
	}

	if(!db_pr_business_exists($pr_business_id)) {
		return $api_instance->Error("Invalid property id");
	}

	if(empty($ac_accomm_type_ids)) {
		$ac_accomm_type_ids = [];
	} elseif(!is_array($ac_accomm_type_ids)) {
		$ac_accomm_type_ids = [$ac_accomm_type_ids];
	}

	$accommSearchSQL = "";
	if(!empty($ac_accomm_type_ids)) {
		$ac_accomm_type_ids = array_map(function($ac_accomm_type_id) use ($lDB) {
			return $lDB->escape($ac_accomm_type_id);
		}, $ac_accomm_type_ids);
		$accommSearchSQL = "
			AND ac_accomm_type.ac_accomm_type_ix IN ('" . join("','", $ac_accomm_type_ids) . "')
		";
	}
	$ac_accomm_type_ids = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
		WHERE
			sc_accomm.sc_group_id = '$GLOBALS[sc_group_id]'
			AND ac_accomm_type.pr_business_id = '$pr_business_id'
			AND	ac_accomm_type.ac_accomm_type_inactive_yn=0
			$accommSearchSQL
		ORDER BY 
			ac_accomm_sequence ASC 
	",3);
	if(empty($ac_accomm_type_ids)) {
		return $api_instance->Error("Access denied");
	}

	$list = $lDB->get("
		SELECT
			ac_accomm_room.ac_accomm_room_ix,
			ac_accomm_room.ac_desc,
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc,
			rv_res_item_group.rv_res_item_group_ix,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rt_rate_type.rt_rate_type_ix,
			rt_rate_type.rt_rate_type_desc,
			rv_reservation.rv_invoice_currency_id,
			rf_currency.rf_currency_symbol
		FROM
			rv_res_item_group
			INNER JOIN ac_accomm_room on ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_reservation.rv_invoice_currency_id
		WHERE
			rv_res_item_group.rv_grp_status_ind = '5'
			AND ac_accomm_room.ac_accomm_type_id IN ('" . join("','", $ac_accomm_type_ids) . "')
			AND ac_accomm_room.ac_accomm_room_inactive_yn = '0'
	",6);
	$list = array_map(function($room) use ($lDB) {
		$components = $lDB->get("
			SELECT DISTINCT
				rt_component.rt_component_ix,
				rt_component.rt_component_desc,
				rt_component.rt_component_abbrv
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '" . $lDB->escape($room['rv_reservation_item_ix']) . "'
			ORDER BY
				rt_component.rt_component_desc
		",6);
		$room['components'] = [];
		foreach($components as $component) {
			$room['components'][] = [
				'id' => $component['rt_component_ix'],
				'code' => $component['rt_component_abbrv'],
				'name' => $component['rt_component_desc']
			];
		}

		$guests = $lDB->get("
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				rv_res_item_guest
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_res_item_guest.rv_res_item_group_id = '" . $room['rv_res_item_group_ix'] . "'
		",2);

		$room['guests'] = [];
		foreach($guests as $guest) {
			$room['guests'][] = [
				'id'=>$guest['pr_persona_ix'],
				'name_last'=>$guest['pr_name_last'],
				'name_first'=>$guest['pr_name_first']
			];
		}
		return $room;		
	}, $list);

	$newList = [];
	foreach($list as $item) {
		$newList[] = [
			'id'=>$item['ac_accomm_room_ix'],
			'name'=>$item['ac_desc'],
			'accommodation_id'=>$item['ac_accomm_type_ix'],
			'accommodation_name'=>$item['ac_accomm_desc'],
			'group_id'=>$item['rv_res_item_group_ix'],
			'reservation_id'=>$item['rv_reservation_ix'],
			'reservation_name'=>$item['rv_res_name'],
			'rate_type_id'=>$item['rt_rate_type_ix'],
			'rate_type_name'=>$item['rt_rate_type_desc'],
			'components'=>$item['components'],
			'guests'=>$item['guests'],
			'currency_id'=>$item['rv_invoice_currency_id'],
			'currency_code'=>$item['rf_currency_symbol']
		];
	}

	$searchFields = [
		'name'=>false,
		'reservation_id'=>false,
		'reservation_name'=>false,
		'guest'=>false
	];

	$searchType = "any";
	if(!is_array($search) && $search !== false && $search !== "") {
		foreach($searchFields as &$criteria) {
			$criteria = $search;
		}
		unset($criteria);
	} elseif(is_array($search) && sizeof($search) > 0) {
		foreach($search as $field=>$criteria) {
			if(array_key_exists($field, $searchFields) && $criteria !== false && $criteria !== "") {
				$searchFields[$field] = $criteria;
			}
		}
		if(array_key_exists("type",$search) && $search['type'] == "all") {
			$searchType = "all";
		}
	} else {
		$searchType = false;
	}

	$searchFields = array_filter($searchFields, function($field) {
		if($field === false) {
			return false;
		} else {
			return true;
		}
	});

	if($searchType !== false) {
		foreach($searchFields as &$criteria) {
			$criteria = join(".*",array_map(function ($item) {
				return preg_quote($item, '/');
			}, explode("%",str_replace("*","%",$criteria))));
			if($searchType == "all") {
				$criteria = "^" . $criteria . "$";
			}
			$criteria = "/" . $criteria . "/i";
		}
		unset($criteria);
		$newList = array_values(array_filter($newList, function($room) use ($searchFields, $searchType) {
			$found = 0;
			foreach($searchFields as $field=>$criteria) {
				if($field != "guest") {
					if(preg_match($criteria, $room[$field])) {
						$found++;
					}
				} else {
					$foundGuest = false;
					foreach($room['guests'] as $guest) {
						if(preg_match($criteria, $guest['name_first'] . " " . $guest['name_last'])) {
							$foundGuest = true;
						}
					}
					if($foundGuest) {
						$found++;
					}
				}
			}
			if($searchType == "any") {
				return $found > 0;
			} else { // all
				return $found == sizeof($searchFields);
			}
		}));
	}

	return $newList;
}

function api_rv_create_pos_extras($ac_pos, $rv_reservation_id, $ac_accomm_room_id, $rv_res_item_group_id, $pr_guest_id, $rv_extra_ref, $rv_extra_note, $rv_extra_note_internal, $property_business_id, $items, $rf_currency_id="", $rv_extra_date_serv=false, $payments=array(), $hostID="") {
	global $api_instance;
	global $lDB;
	global $userStatusId;
	global $isPropServer;
	global $dbcode;
	global $outletSale;
	$outletSale = false;

	if($userStatusId < 2) {
		return $api_instance->Error("Access denied.");
	}

	if ($hostID != "") {
		$where = $rv_reservation_id == "" ? "" : "AND rv_reservation_id = '" . $rv_reservation_id . "'";
		$hostIdCount = $lDB->get("
			SELECT
				COUNT(rv_extra.rv_extra_ix) AS count
			FROM
				rv_extra
			WHERE
				rv_extra_debug LIKE '%" . $hostID . "%'
				" . $where . "
		", 4);
		if (!empty($hostIdCount) && $hostIdCount > 0) {
			error_log("TallOrder Duplicate: Host ID '" . $hostID . "' already exists, duplicate tab.");
			return $api_instance->Error("Host ID already exists, duplicate tab.");
		}
	}

	$ac_pos_id = $lDB->get("
		SELECT
			ac_pos.ac_pos_ix
		FROM
			ac_pos
		WHERE
			ac_pos.ac_inactive_yn = '0'
			AND (
				ac_pos.ac_pos_ix = '" . $lDB->escape($ac_pos) . "'
				OR ac_pos.ac_pos_name = '" . $lDB->escape($ac_pos) . "'
			)
	",4);
	$pos_business_id = $lDB->get("SELECT pr_business_id FROM ac_pos WHERE ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'",4);

	if(empty($ac_pos_id)) {
		return $api_instance->Error("Unknown or invalid till.");
	}

	if($isPropServer) {
		$pos_dbcode = $lDB->get("SELECT rf_db_code FROM rf_db_business WHERE pr_business_id = '" . $lDB->escape($pos_business_id) . "'",4);
		if($pos_dbcode != $dbcode) {
			return $api_instance->Error("Till property is not linked to this property environment.");
		}
	}

	if(empty($rv_extra_date_serv)) {
		$rv_extra_date_serv = date("Y-m-d");
	} else {
		$rv_extra_date_serv = date("Y-m-d", strtotime($rv_extra_date_serv));
		$tomorrow = date("Y-m-d", strtotime("tomorrow"));
		$lastWeek = date("Y-m-d", strtotime("today -1 week"));
		if($rv_extra_date_serv < $lastWeek || $rv_extra_date_serv > $tomorrow) {
			return $api_instance->Error("Date override must be within 1 week in the past or 1 day in the future of the current server date (" . date("Y-m-d") . ")");
		}
	}

	$newFolio = false;

	if(empty($rv_reservation_id) && empty($ac_accomm_room_id) && empty($rv_res_item_group_id) && empty($pr_guest_id)) { // Outlet (cash) sale
		try {
			$rv_reservation_id = getCashReservation($ac_pos_id,$rv_extra_date_serv);
		} catch(Exception $e) {
			return $api_instance->Error("Error on outlet/cash reservation: " . $e->getMessage());
		}
		$ac_accomm_type_id = $lDB->get("
			SELECT
				rv_reservation_item.ac_accomm_type_id
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
			LIMIT 1
		",4);
		if(empty($ac_accomm_type_id)) {
			return $api_instance->Error("Invalid outlet/cash sale configuration. Unable to create transaction.");
		}

		$pr_guest_id = "";

		if(!empty($billing_property_id)) {
			if(!db_pr_business_exists($billing_property_id)) {
				return $api_instance->Error("Invalid property id");
			}
		} else {
			$billing_property_id = $pos_business_id;
		}

		$property_business_id = $lDB->get("
			SELECT
				rv_reservation_item.pr_business_id
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
			LIMIT 1
		",4);

		$ac_cash_folio_ind = $lDB->get("SELECT ac_cash_folio_ind FROM ac_pos WHERE ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'",4);
		if($ac_cash_folio_ind == 2) {
			$newFolio = true;
		}
		$outletSale = true;
	} else {
		$ac_accomm_type_id = $lDB->get("
			SELECT
				rv_reservation_item.ac_accomm_type_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_res_item_group.rv_grp_status_ind = '5'
				AND rv_res_item_group.rv_res_item_group_ix = '" . $lDB->escape($rv_res_item_group_id) . "'
				AND rv_res_item_group.ac_accomm_room_id = '" . $lDB->escape($ac_accomm_room_id) . "'
				AND rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
		",4);
		if(empty($ac_accomm_type_id)) {
			return $api_instance->Error("Invalid group, room or reservation");
		}

		$status = $lDB->get("
			SELECT
				rv_res_item_group.rv_grp_status_ind
			FROM
				rv_res_item_group
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '" . $lDB->escape($rv_res_item_group_id) . "'
		",4);
		if($status != "5") {
			return $api_instance->Error("Room not checked in");
		}

		if(strtolower($pr_guest_id) === "cash" || $pr_guest_id === "0") {
			$pr_guest_id = "";
		}

		if(!empty($pr_guest_id)) {
			if(!db_pr_guest_exists($pr_guest_id)) {
				return $api_instance->Error("Invalid guest id");
			}
		} else {
			$pr_guest_id = "";
		}

		if(!empty($billing_property_id)) {
			if(!db_pr_business_exists($billing_property_id)) {
				return $api_instance->Error("Invalid property id");
			}
		} else {
			$billing_property_id = $pos_business_id;
		}

		$property_business_id = $lDB->get("
			SELECT
				rv_reservation_item.pr_business_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_res_item_group.rv_res_item_group_ix = '" . $lDB->escape($rv_res_item_group_id) . "'
		",4);
	}

	if (!isset($rf_currency_id) || empty($rf_currency_id)) {
		// Setting default currency
		// Currency is set as Optional, as an interim solution, while migrating to the latest version of TallOrder.
		$rf_currency_id = $lDB->get("
			SELECT
				pr_bus_home_curr_id
			FROM
				pr_business
			WHERE
				pr_business_id = '" . $lDB->escape($property_business_id) . "'
		",4);
	}

	if(!db_rf_currency_exists($rf_currency_id)) {
		$rf_currency_id = $lDB->get("SELECT rf_currency_ix FROM rf_currency WHERE rf_currency_symbol = '" . $lDB->escape($rf_currency_id) . "'",4);
	}

	if(empty($rf_currency_id)) {
		return $api_instance->Error("Missing or invalid currency");
	}

	$billing_business_id = "";
	$current_business_id = $billing_property_id;
	while(!empty($current_business_id) && empty($billing_business_id)) {
		$check = $lDB->get("
			SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '" . $lDB->escape($current_business_id) . "'
		",4);
		if($check == "1") {
			$billing_business_id = $current_business_id;
		}
		$current_business_id = $lDB->get("
			SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '" . $lDB->escape($current_business_id) . "'
		",4);
	}
	if(empty($billing_business_id)) {
		return $api_instance->Error("No billing unit found for the location property");
	}

	if(!is_array($items) || empty($items)) {
		return $api_instance->Error("Invalid items list");
	}

	$fields = [
		'amount',
		'quantity',
		'id',
		'reference',
		'note',
		'memo'
	];

	$newItems = [];
	foreach($items as $key=>$item) {
		if(!array_key_exists("id", $item) && !array_key_exists("quantity", $item) && !array_key_exists("amount", $item)) {
			$newItem = [];
			foreach($fields as $index=>$field) {
				$newItem[$field] = $item[$index] ?? "";
			}
			$item = $newItem;
			unset($newItem);
		}
		foreach($fields as $field) {
			if(!array_key_exists($field, $item)) {
				$item[$field] = "";
			}
		}

		$ac_extra_id = false;

		$checkExtra = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '" . $lDB->escape($item['id']) . "'
		",4);
		if($checkExtra > 0) {
			$ac_extra_id = $item['id'];
		}

		if(empty($ac_extra_id)) {
			$posExtra = getPOSExtra($ac_pos_id, $item['id'], true);
			if(!empty($posExtra) && is_array($posExtra) && array_key_exists("ac_extra_id",$posExtra)) {
				$ac_extra_id = $posExtra['ac_extra_id'];
			}
		}

		if(empty($ac_extra_id)) {
			return $api_instance->Error("Invalid item id: $item[id]");
		}

		$ac_extra_cat_ind = $lDB->get("
			SELECT
				ac_extra_category.ac_extra_cat_ind
			FROM
				ac_extra
				INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			WHERE
				ac_extra.ac_extra_ix = '" . $lDB->escape($ac_extra_id) . "'
		",4);
		if($ac_extra_cat_ind !== "0") { // Not a general extra
			return $api_instance->Error("Invalid extra: Not a general extra (" . ($item['id'] == ""?"default":$item['id']). ")");
		}

		$chargable = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				ac_extra
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
			WHERE
				ac_extra.ac_extra_ix = '" . $lDB->escape($ac_extra_id) . "'
		",4);
		if($chargable < 1) {
			return $api_instance->Error("Invalid item id, non-chargable: $item[id]");
		}
		$item['id'] = $ac_extra_id;

		$rf_tax = $lDB->get("
			SELECT
				ac_extra.rf_tax_id,
				ac_extra.rf_tax_ind
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '" . $lDB->escape($ac_extra_id) . "'
		",1);
		if($rf_tax['rf_tax_ind'] == "10") { // tax rate
			$rf_tax_rate_perc = $lDB->get("
				SELECT
					rf_tax_rate.rf_tax_rate_perc
				FROM
					ac_extra
					INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
				WHERE
					ac_extra.ac_extra_ix = '" . $lDB->escape($ac_extra_id) . "'
			",4);
		} else { // tax group
			$rf_tax_rate_perc = $lDB->get("
				SELECT
					SUM(rf_tax_rate.rf_tax_rate_perc) AS perc
				FROM
					rt_tax_group
					INNER JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
					INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
				WHERE
					rt_tax_group.rt_tax_group_ix = '" . $lDB->escape($rf_tax['rf_tax_id']) . "'
			",4);
		}
		$item['tax'] = [
			'id'=>$rf_tax['rf_tax_id'],
			'ind'=>$rf_tax['rf_tax_ind'],
			'perc'=>$rf_tax_rate_perc
		];

		if(empty($item['quantity'])) {
			$item['quantity'] = "1";
		}

		if(!preg_match("/^[0-9]+$/",$item['quantity'])) {
			return $api_instance->Error("Invalid item quantity: $item[quantity]");
		}

		$item['quantity'] = (int)$item['quantity'];
		if(empty($item['quantity']) || $item['quantity'] < 1) {
			return $api_instance->Error("Invalid item quantity: $item[quantity]");
		}
			
		if(!is_numeric($item['amount'])) {
			return $api_instance->Error("Invalid item amount: $item[amount]");
		}

		if($item['reference'] == "") {
			$item['reference'] = $rv_extra_ref;
		}

		if($item['note'] == "") {
			$item['note'] = $rv_extra_note;
		}

		if($item['memo'] == "") {
			$item['memo'] = $rv_extra_note_internal;
		}
		$newItems[] = $item;
	}
	$items = $newItems;
	unset($newItems);

	$rv_extra_ids = [];
	$fn_folio_id = false;
	foreach($items as $item) {
		// Ignore passed percentage, look up percentage from Tax Code Table
		$taxPerc = taxPercentage($item['tax']['id'], $item['tax']['ind']);

		$rv_extra_id = db_rv_extra_insert(
			$rv_reservation_id,
			$item['id'],
			$property_business_id,
			$item['quantity'],
			$rv_extra_date_serv,
			$item['amount'],
			0, // discount
			$taxPerc,
			0, // comm received
			0, // comm paid
			$item['note'],
			$item['memo'],
			$rv_res_item_group_id,
			$rf_currency_id,
			$rf_currency_id,
			1, // exchange rate.
			false, // exchange expiry
			$billing_business_id,
			'', // travel eta
			'', // travel etd
			0, // adults
			0, // children
			'', // departure
			$item['reference'],
			0, // supplier yn
			0, // supplier id
			$ac_pos_id
		);
		if ($hostID != '') {
			db_rv_extra_debug($rv_extra_id,"TOHostID:".$hostID);
		}
		db_rv_extra_tax_insert($rv_extra_id, $item['tax']['ind'], $item['tax']['id']);
		verify_extra($rv_extra_id);

		if($fn_folio_id === false) {
			$fn_folio_id = db_fn_folio_insert_extra(
				$rv_extra_id,
				$rv_res_item_group_id,
				$pr_guest_id,
				$newFolio
			);
		}
		db_rv_extra_set_folio($rv_extra_id, $fn_folio_id, true, true);

		$rv_extra_ids[] = $rv_extra_id;
	}

	if (is_array($payments) && !empty($payments) ) { // [["payment_method_amount", "currency", "payment_method_id"],],
		if (!is_numeric(array_keys($payments[0])[0])) {
			return $api_instance->Error("Invalid payment parameter.");
		}
		$errors = 0;
		$errorMessage = "";
		$totalMismatchError = "";
		// Single currency only - exchange rate not taken into account.
		$gl_exch_rate = 1; 
		$rv_pay_item_exch_rate = 1;
		// Get payment totals from Extras
		$extrasTotal = array_sum(array_column($items, 'amount'));
		$paymentTotals = array_sum(array_column($payments, 0));
		if ( $outletSale && ( intval(array_sum(array_column($items, 'amount'))) != intval(array_sum(array_column($payments, 0))) ) ) {
			$totalMismatchError .= "\nPayment totals do not balance with Extra ";
		}

		$reservationAuditTrail = new AuditTrail($rv_reservation_id,TYPE_RESERVATION);
		$paymentIdArray = array();

		foreach($payments as $key => $paymentType) {

			$fields = [
				'payment_method_amount',
				'currency',
				'payment_method_id'
			];
		
			if(!array_key_exists("payment_method_amount", $paymentType) && !array_key_exists("currency", $paymentType) && !array_key_exists("payment_method_id", $paymentType)) {
				$newPaymentType = [];
				foreach($fields as $index=>$field) {
					$newPaymentType[$field] = $paymentType[$index] ?? "";
				}
				$paymentType = $newPaymentType;
				unset($newItem);
			}
			// Check valid Cash Point
			$rf_cash_point_bank_id = db_get_pos_cashpoint($ac_pos_id);
			if (!$rf_cash_point_bank_id || $rf_cash_point_bank_id == '0') {
				return $api_instance->Error("Invalid Location or unmapped Cash Point. Unable to create payment transaction.");
			}
			$paymentNote = "POS";
			$paymentAmount = $paymentType['payment_method_amount'];
			// Check API payment method is valid 
			$rf_mthd_pmnt_id = $paymentType['payment_method_id'];
			if (!db_get_valid_payment_id($rf_mthd_pmnt_id)) {
				if (!$outletSale) {
					continue;
				} else {
					$errors ++;
					$errorMessage .= "\nUnmapped payment method. Used default.";
					$rf_mthd_pmnt_id = 'RS300';
				}
			}
			// Check payment currency matches Extra currency
			$cashPointCurrencyId = db_get_cash_point_currency_id($rf_cash_point_bank_id);
			if (empty($cashPointCurrencyId) || ($cashPointCurrencyId != db_get_payment_currency_id($paymentType['currency'])) ) {
				$errors ++;
				$errorMessage .= "\nCurrency mismatch with Cash Point.";
			}

			if ($errors || !empty($totalMismatchError)) {
				$paymentNote .= $totalMismatchError;
				$paymentNote .= $errorMessage;
				$paymentNote .= "\nReceived from POS: " . db_get_currency_code($paymentType['currency']) . " " . $paymentType['payment_method_amount']; 
				
				$paymentAmount = '0';
			}

			$rv_payment_id = db_rv_payment_insert("0",$rv_extra_date_serv,$rf_cash_point_bank_id,$rf_mthd_pmnt_id,$rv_extra_ref,$paymentNote);
			
			if($rv_payment_id) {
				$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$paymentAmount,$rv_pay_item_exch_rate,$gl_exch_rate);
				db_rv_payment_update_amount($rv_payment_id);
				$paymentIdArray[] = $rv_payment_id;
			}
			$reservationAuditTrail->save("POS Extra (Payment " . $rv_payment_id . ")");
		}

		if ($errors || !empty($totalMismatchError)) {
			return $api_instance->Error("$totalMismatchError $errorMessage Payment recorded with zero value." . join(",", $paymentIdArray));
		}
		$rv_payment_ids = "Payments: ['" . join("','", $paymentIdArray) . "']";
		array_push($rv_extra_ids, $rv_payment_ids); 
	}

	return $rv_extra_ids;
}

function db_get_pos_cashpoint($ac_pos_id) {
	global $lDB;

	return $lDB->get("	
		SELECT
			ac_pos.rf_bank_id
		FROM
			ac_pos
		WHERE
			ac_pos.ac_inactive_yn = '0'
			AND 
			ac_pos.ac_pos_ix = '$ac_pos_id'
	",4);
}

function db_get_cash_point_currency_id($rf_cash_point_bank_id) {
	global $lDB;

	return $lDB->get("	
		SELECT 
			rf_currency_id 
		FROM 
			rf_bank
		WHERE 
			rf_bank_ix = '$rf_cash_point_bank_id'
	",4);
}

function db_get_payment_currency_id($paymentTypeCurrency) {
	global $lDB;

	return  $lDB->get("	
		SELECT 
			rf_currency_ix 
		FROM 
			rf_currency
		WHERE
			rf_currency_ix = '$paymentTypeCurrency'
			OR
			rf_currency_symbol like '%$paymentTypeCurrency%'
	",4) ?? $paymentTypeCurrency;
}

function db_get_valid_payment_id($rf_mthd_pmnt_ix) {
	global $lDB;

	return $lDB->get("	
		SELECT 
			COUNT(rf_mthd_pmnt_ix) 
		FROM 
			rf_mthd_pmnt 
		WHERE 
			rf_mthd_pmnt_ix = '$rf_mthd_pmnt_ix'	
	",4);
}

function db_get_currency_code($paymentTypeCurrency) {
	global $lDB;

	$currencySymbol =  $lDB->get("	
		SELECT 
			rf_currency_symbol 
		FROM 
			rf_currency
		WHERE
			rf_currency_ix = '$paymentTypeCurrency'
			OR
			rf_currency_symbol like '%$paymentTypeCurrency%'
	",4) ?? $paymentTypeCurrency;
	return $currencySymbol != "" ? $currencySymbol : $paymentTypeCurrency;
}
