<?php

/*
 * $Id: api.rate.php,v 1.10 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.rate.php,v $
 * Revision 1.10  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.9  2012-10-15 14:05:15  light
 * Bug #6924 - Stock API to differentiate between confirmed & provisional reservations
 *
 * Revision 1.8  2012-06-01 14:32:10  light
 * Bug #7884 - Get Rates Range API Call
 *
 */

/**
 * api/api.rate.php - API definitions related to rates
 */

$this->Register(array(
	'ac_get_rate'=>array(
		'doc'=>"This function has been DEPRECATED.  When passed a valid username and password, returns all available rates, their codes, currency and default flag. Optionally a third parameter may be passed to search for specific rate names. This search may use * or % as wildcard characters. The fourth and fifth parameters are also optional and are 'default' and 'agent' respectively. If set to 1, 'default' will return only the default rate for the specific user. The 'agent' parameter can be used to do a lookup on a specific agent. Optionally a sixth parameter may be passed to return additional information. This parameter is an array specifying the additional information required.",
		'signature'=>"?string,?string,?string,?array+struct"
	),
	'rt_get_rate'=>array(
		'doc'=>"When passed a valid username and password, returns all available rates, their codes, currency and default flag. Optionally a third parameter may be passed to search for specific rate names. This search may use * or % as wildcard characters. The fourth and fifth parameters are also optional and are 'default' and 'agent' respectively. If set to 1, 'default' will return only the default rate for the specific user. The 'agent' parameter can be used to do a lookup on a specific agent. Optionally a sixth parameter may be passed to return additional information. This parameter is an array specifying the additional information required.",
		'signature'=>"?string,?string,?string,?array+struct"
	),
	'ac_get_rate_total'=>array(
		'doc'=>"This function has been DEPRECATED.  When passed a valid username, password and accommdation code, returns the rate total for one night from today for one unit with the default room configuration. Optionally a third and fourth parameter may be passed to specify a date range, a fifth to specify the number of units, a sixth and seventh to specify the number of adults and children and an eighth to specify a rate type other than the default.",
		'signature'=>"string,?string,?string,?string,?string,?string,?string"
	),
	'rt_get_rate_total'=>array(
		'doc'=>"When passed a valid username, password and accommdation code, returns the rate total for one night from today for one unit with the default room configuration. Optionally a third and fourth parameter may be passed to specify a date range, a fifth to specify the rate groups and a sixth to specify a rate type other than the default.",
		'signature'=>"string,?string,?string,?array,?string,?string,?string,?string"
	),
	'rt_get_rate_detail'=>array(
		'doc'=>"When passed a valid username, password and accommodation code, returns the rate detail for one night from today for one unit with the default room configuration. Optionally a fourth and fifth parameter may be passed to specify a date range, a sixth to specify the rate groups, a seventh to specify a rate type other than the default, an eighth to specify the amount types to return, an ninth to specify the agent, a tenth to override the commission percentage and an eleventh to specify how the details are to be split.",
		'signature'=>"string,?string,string,array,string,string+array+struct,string,string,array+struct"
	),
	'rt_get_rate_total_range'=>array(
		'doc'=>"When passed a valid username, password and accommdation code and date range, returns the daily rate total for each day in the entire range.  This can be limited to certain rate groups, and/or rate group quantities.",
		'signature'=>"string,?string,?string,?array,?string,?string,?string"
	),
	'rt_get_rate_total_range_batch'=>array(
		'doc'=>"When passed a valid username, password and accommodation code and date range, returns the daily rate total for each day in the entire range.  This can be limited to certain rate groups, and/or rate group quantities. This batch call accepts an array of arrays, containing the same data structure as required by rt_get_rate_total_range.",
		'signature'=>"?array"
	),
	'rt_get_rate_group'=>array(
		'doc'=>"When passed a valid username, password and accommdation code, returns the rate groups for the applicable rate as at today with default rate type. Optionally a third and fourth parameter may be passed to specify a date range, and a fifth to specify a rate type other than the default.",
		'signature'=>"string,?string,?string,?string,?string,?string"
	),
	'ac_get_payment_plan'=>array(
		'doc'=>"This function has been DEPRECATED.  When passed a valid username and password, returns a list of payment plans. Optionally, a search filter can be provided on payment plan name.",
		'signature'=>"?string"
	),
	'rt_get_payment_plan'=>array(
		'doc'=>"When passed a valid username and password, returns a list of payment plans. Optionally, a search filter can be provided on payment plan name.",
		'signature'=>"?string"
	)
));
