<?php
/*
 * $Id: api.reservation.php,v 1.17 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.reservation.php,v $
 * Revision 1.17  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.16  2012-10-15 14:05:15  light
 * Bug #6924 - Stock API to differentiate between confirmed & provisional reservations
 *
 * Revision 1.15  2012-08-06 16:49:27  light
 * Bug #7998 - Create online payments from API
 *
 * Revision 1.14  2012-07-03 11:43:07  light
 * Bug #7987 - API - Add ability to specify rate type at itinerary level
 *
 * Revision 1.13  2012-06-13 11:11:44  light
 * Bug #7944 - External Users can query ANY reservation from the API
 *
 * Revision 1.12  2012-03-30 13:06:39  light
 * Bug #7801 - Gym Session Project Blue (Parent)
 *
 * Revision 1.11  2012-01-16 14:01:15  light
 * Bug #7841 - Access control changes for fraud prevention #2
 *
 */

/**
 * api/api.reservation.php - API definitions related to reservations
 */

$this->Register(array(
	'rv_create'=>array(
		'doc'=>"When passed a valid array of itinerary items, a reservation will be created and a receipt returned.",
		'signature'=>"array,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string,?string",
		'access'=>array(
			array("function"=>50,"level"=>10)
		)
	),
	'rf_get_source'=>array(
		'doc'=>"When passed a valid username and password, returns a list of sources. Optionally, a search filter can be provided on source name.",
		'signature'=>"?string"
	),
	'rf_get_reservation_status'=>array(
		'doc'=>"When passed a valid username and password, returns a list of reservation statuses. Optionally, a search filter can be provided on status description.",
		'signature'=>"?string"
	),
	'rv_get_reservation'=>array(
		'doc'=>"When passed a valid username and password, returns a list of reservations. Optionally, the following search parameters can be included, in this order: Reservation ID, Reservation Name, Arrive Date, Depart Date, Reservation Status, Agent, Contact.",
		'signature'=>"?string,?string,?string,?string,?string,?string,?string"
	),
	'rv_get_note'=>array(
		'doc'=>"When passed a valid username, password and reservation id, returns a list of the notes and reservation nationality.",
		'signature'=>"string"
	),
	'rv_update_note'=>array(
		'doc'=>"When passed a valid username, password, reservation id, note and optionally a guest note, memo and country id updates the reservation notes and returns a note reference id.",
		'signature'=>"string,string+boolean,?string+boolean,?string+boolean,?string+boolean"
	),
	'rv_update_status'=>array(
		'doc'=>"When passed a valid username, password, reservation id, status id and optionally a provisional expiry date, cancellation reason and overbooking override,  updates the reservation status.",
		'signature'=>"string,string,?string,?string,?string+boolean,?boolean,?string,?string"
	),
	'rv_get_itinerary'=>array(
		'doc'=>"When passed a valid username, password and reservation id, returns a list of itineraries linked to the reservation.",
		'signature'=>"string"
	),
	'rv_create_itinerary'=>array(
		'doc'=>"Creates a new itinerary(s) on a reservation when passed a valid username, password, reservation id, array of itinerary items and optionally a parameter to allow overbookings.",
		'signature'=>"string,array,?string"
	),
	'rv_update_itinerary'=>array(
		'doc'=>"Replaces a list of old itineraries with a list of new itineraries when passed a valid username, password, reservation id, array of itinerary ids to replace, an array of new itinerary items to create and optionally a parameters to allow overbookings, send modification requests, custom subject, and add custom modification request text",
		'signature'=>"string,array,array,?string,?boolean,?string,?string"
	),
	'rv_delete_itinerary'=>array(
		'doc'=>"Deletes an itinerary when passed a valid username, password, reservation id and itinerary id, and optionally a parameters to allow sending of a modification requests, custom subject, and add custom deletion request text.",
		'signature'=>"string,string,?boolean,?string,?string"
	),
	'rf_get_booking_info'=>array(
		'doc'=>"When passed a valid username and password, returns booking information."
	),
	'rv_request_cancel'=>array(
		'doc'=>"When passed a valid username, password, reservation id and optionally a third party reference, reason, from email address and additional to addresses, sends a cancellation request for the reservation.",
		'signature'=>"string,?string,?string,?string,?string",
		'access'=>array(
			array("function"=>50,"level"=>10)
		)
	),
	'rv_request_cancel_itinerary'=>array(
		'doc'=>"When passed a valid username, password, itinerary id and optionally a third party reference, reason, from email address and additional to addresses, sends a cancellation request for the itinerary.",
		'signature'=>"string,string,?string,?string,?string,?string",
		'access'=>array(
			array("function"=>50,"level"=>10)
		)
	),
	'rv_update_tripsheet'=>[
		'doc'=>"Returns true on a successful update given a reservation id, contact id and structure containing the 'name' and 'value' of the fileds to be updated. Available fields are determined using rf_get_guest_field",
		'signature'=>"string,string,struct",
		'access'=>[
			['function'=>54, 'level'=>10]
		]
	],
	'rv_can_edit_reservation'=>array(
		'doc'=>"Whether or not the user can edit a reservation. Returns a structure containing keys can_edit and editable_items indicating whether the user can edit reservations and which parts.",
		'signature'=>"string"
	),
));
