<?php

/*
 * $Id: api.stock.func.php,v 1.1 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.stock.func.php,v $
 * Revision 1.1  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 */

/**
 * api/api.stock.func.php - API functions related to proprerty, accommodation and stock data
 */

require_once(__DIR__ . '/../db.pr_agent.php');
require_once(__DIR__ . '/../db.pr_business.php');
require_once(__DIR__ . '/../db.ac_accomm_type.php');
require_once(__DIR__ . '/../class.stock.php');

// Taken from functions.property.php (function recurse_array) and modified to generate a hierarchial list of property id's without accomms
function api_ac_get_property_hierarchy ($record=0) {
	global $lDB;
	global $dbcode;

	$propList = "";
	if ($record != $dbcode."0") {
		$name = trim($lDB->get("
		SELECT
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$record'
		",4));
	} else {
		$name = "Properties";
	}
	# get children
	$propList .= $record.",";
	if ($lDB->count("ac_accomm_type","pr_business_id",$record,"0")) {
		$temp = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$record'
		ORDER BY
			pr_business_sequence
		",3);
		cleanse($temp);
		# for each child property, add to list, then recurse
		foreach($temp as $child) {
			$propList .= api_ac_get_property_hierarchy($child).",";
		}
	}
	return $propList;
}

function api_ac_get_property($search="",$extra=false) {
	global $api_instance;
	global $lDB;
	global $domain;

	$searchSQL = "";
	$getGps = 0;
	$getSocial = 0;
	$getImages = 0;
	$getPropertyURL = 0;
	if(trim($search) != "") {
		$searchSQL = "
			AND pr_persona.pr_name_last LIKE '".addslashes(str_replace("*","%",$search))."'
		";
	}

	if($extra === false) {
		$extra = array(0,0,0,0,0,0);
	}

	if(!is_array($extra)) {
		return $api_instance->Error("Invalid request for additional information. This parameter must be an array.");
	}

	$extraFields = array();
	if((array_key_exists(0,$extra) && !empty($extra[0])) || (array_key_exists("calendar_note",$extra) && !empty($extra['calendar_note']))) {
		$extraFields['calendar_note'] = array("table" => "pr_business", "field" => "pr_bus_memo_cal");
	}
	if((array_key_exists(1,$extra) && !empty($extra[1])) || (array_key_exists("document_note",$extra) && !empty($extra['document_note']))) {
		$extraFields['document_note'] = array("table" => "pr_business", "field" => "pr_bus_memo_info");
	}
	if((array_key_exists(2,$extra) && !empty($extra[2])) || (array_key_exists("gps_coords",$extra) && !empty($extra['gps_coords']))) {
		$getGps = 1;
	}
	if((array_key_exists(3,$extra) && !empty($extra[3])) || (array_key_exists("social_links",$extra) && !empty($extra['social_links']))) {
		$getSocial = 1;
	}
	if((array_key_exists(4,$extra) && !empty($extra[4])) || (array_key_exists("images",$extra) && !empty($extra['images']))) {
		$getImages = 1;
	}
	if((array_key_exists(5,$extra) && !empty($extra[5])) || (array_key_exists("property_url",$extra) && !empty($extra['property_url']))) {
		$getPropertyURL = 1;
		$extraFields['property_url'] = array("table" => "pr_persona", "field" => "pr_web_addr");
	}

	$extraFieldSQL = array();
	foreach($extraFields as $field) {
		$extraFieldSQL[] = "$field[table].$field[field]";
	}
	$extraFieldSQL = join(",\n",$extraFieldSQL);
	if(!empty($extraFieldSQL)) {
		$extraFieldSQL = ",$extraFieldSQL";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last
			$extraFieldSQL
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			sc_accomm.sc_group_id = '$GLOBALS[sc_group_id]'
			AND	ac_accomm_type.ac_accomm_type_inactive_yn=0
			AND	pr_business.pr_bus_inactive_yn= '0'			
			$searchSQL
		ORDER BY
		   pr_business_sequence
	",2);
	$hierarchy = array_filter( explode( ',', api_ac_get_property_hierarchy(0) ) );

	$orderedList = array();
	foreach ($hierarchy as $buss) {
		foreach ($list as $prop) {
			if ($prop['pr_business_id'] == $buss) {
				$orderedList[] = $prop;
			}
		}
	}

	$list = $orderedList;

	$newList = array();
	foreach($list as $item) {
		$newItem = array('id'=>$item['pr_business_id'],'name'=>$item['pr_name_last']);
		if ($getGps == 1) {
			$gps = $lDB->get("
				SELECT
					pr_business.pr_bus_prop_latitude,
					pr_business.pr_bus_prop_longitude
				FROM
					pr_business
				WHERE
					pr_business_id = '".$item['pr_business_id']."'
			",2);
			$newItem['gps_coords'] = array('latitude'=>$gps[0]['pr_bus_prop_latitude'], 'longitude'=>$gps[0]['pr_bus_prop_longitude']);
		}

		if ($getSocial == 1) {
			$social_links = $lDB->get("
				SELECT DISTINCT
					pr_bus_social.pr_bus_social_data,
					pr_social.pr_social_label
				FROM
					pr_bus_social
					INNER JOIN pr_social ON pr_social.pr_social_ix = pr_bus_social.pr_social_id
				WHERE
					pr_bus_social.pr_business_id = '".$item['pr_business_id']."'
				ORDER BY
					pr_social.pr_social_sort_seq ASC
			",2);
			$newItem['social_links'] = !empty($social_links) ? $social_links : array();
		}

		if ($getImages == 1) {
			$imageList = $lDB->get("
				SELECT DISTINCT
					pr_bus_image.pr_bus_image_desc,
					pr_bus_image.pr_bus_image_filename
				FROM
					pr_bus_image
				WHERE
					pr_bus_image.pr_business_id = '".$item['pr_business_id']."'
				ORDER BY
					pr_bus_image.pr_bus_image_desc ASC
			",2);
			if (empty($imageList)) {
				$newItem['images'] = array();
			} else {
				$newImages = array();
				foreach ($imageList as $image) {
					$dbcode = substr($lDB->name, 8);
					$newImages[] = array('description'=>$image['pr_bus_image_desc'], 'filename'=>$GLOBALS['http'].$GLOBALS['online_images_dir'].'/'.$dbcode.'/business_structure/'.$item['pr_business_id'].'/'.$image['pr_bus_image_filename']);
				}
				$newItem['images'] = $newImages;
			}
		}

		if ($getPropertyURL == 1) {
			$newItem['property_url'] = $item['pr_web_addr'];
		}
		foreach($extraFields as $name=>$field) {
			$newItem[$name] = $item[$field['field']];
		}
		$newList[] = $newItem;
	}

	return $newList;
}

function api_ac_get_accomm($pr_business_id,$search="",$extra=false) {
	global $api_instance;
	global $lDB;
	global $domain;
	$getImages = 0;

	$pr_business_id = addslashes($pr_business_id);
	if(!db_pr_business_exists($pr_business_id)) {
		return $api_instance->Error("Invalid property id");
	}

	if($extra === false) {
		$extra = array(0,1,1,0,0);
	}

	if(!is_array($extra)) {
		return $api_instance->Error("Invalid request for additional information. This parameter must be an array.");
	}	

	$extraFields = array();
	if((array_key_exists(0,$extra) && !empty($extra[0])) || (array_key_exists("note",$extra) && !empty($extra['note']))) {
		$extraFields['note'] = "ac_accomm_note";
	}
	if((array_key_exists(1,$extra) && !empty($extra[1])) || (array_key_exists("max_capacity",$extra) && !empty($extra['max_capacity']))) {
		$extraFields['max_capacity'] = "ac_accomm_max_capacity";
	}
	if((array_key_exists(2,$extra) && !empty($extra[2])) || (array_key_exists("max_adults",$extra) && !empty($extra['max_adults']))) {
		$extraFields['max_adults'] = "ac_accomm_max_adults";
	}
	if((array_key_exists(3,$extra) && !empty($extra[3])) || (array_key_exists("max_child_age",$extra) && !empty($extra['max_child_age']))) {
		$extraFields['max_child_age'] = "ac_accomm_max_child_age";
	}
	if((array_key_exists(4,$extra) && !empty($extra[4])) || (array_key_exists("room_capacity",$extra) && !empty($extra['room_capacity']))) {
		$extraFields['room_capacity'] = "ac_accomm_capacity";
	}
	if((array_key_exists(5,$extra) && !empty($extra[5])) || (array_key_exists("images",$extra) && !empty($extra['images']))) {
		$getImages = 1;
	}

	$searchSQL = "";
	
	if(trim($search) != "") {
		$searchSQL = "
			AND ac_accomm_type.ac_accomm_desc LIKE '".addslashes(str_replace("*","%",$search))."'
		";
	}

	$extraFieldSQL = array();
	foreach($extraFields as $field) {
		$extraFieldSQL[] = "ac_accomm_type.$field";
	}
	$extraFieldSQL = join(",\n",$extraFieldSQL);
	if(!empty($extraFieldSQL)) {
		$extraFieldSQL = ",$extraFieldSQL";
	}
	
	$list = $lDB->get("
		SELECT DISTINCT
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.ac_accomm_desc
			$extraFieldSQL
		FROM
			sc_accomm
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
		WHERE
			sc_accomm.sc_group_id = '$GLOBALS[sc_group_id]'
			AND ac_accomm_type.pr_business_id = '$pr_business_id'
			AND	ac_accomm_type.ac_accomm_type_inactive_yn=0
			$searchSQL
		ORDER BY 
			ac_accomm_sequence ASC 
	",2);

	$newList = array();
	foreach($list as $item) {
		
		$newItem = array('id'=>$item['ac_accomm_type_ix'],'name'=>$item['ac_accomm_desc']);

		if ($getImages == 1) {
			$imageList = $lDB->get("
				SELECT DISTINCT
					ac_accomm_image.ac_accomm_image_desc,
					ac_accomm_image.ac_accomm_image_filename
				FROM
					ac_accomm_image
				WHERE
					ac_accomm_image.ac_accomm_type_id = '".$item['ac_accomm_type_ix']."'
				ORDER BY
					ac_accomm_image.ac_accomm_image_desc ASC
			",2);
			if (empty($imageList)) {
				$newItem['images'] = array();
			} else {
				$newImages = array();
				foreach ($imageList as $image) {
					$dbcode = substr($lDB->name, 8);
					$newImages[] = array('description'=>$image['ac_accomm_image_desc'], 'filename'=>$GLOBALS['http'].$GLOBALS['online_images_dir'].'/'.$dbcode.'/business_structure/'.$pr_business_id.'/'.$item['ac_accomm_type_ix'].'/'.$image['ac_accomm_image_filename']);
				}
				$newItem['images'] = $newImages;
			}
		}

		foreach($extraFields as $name=>$field) {
			$newItem[$name] = $item[$field];
		}
		$newList[] = $newItem;
		//array_push($newList,array('id'=>$item['ac_accomm_type_ix'],'name'=>$item['ac_accomm_desc'],'max_capacity'=>$item['ac_accomm_max_capacity'],'max_adults'=>$item['ac_accomm_max_adults']));
	}

	return $newList;
}

function api_ac_get_stock_batch($ac_accomm_type_id, $fromDate=false, $toDate=false, $agentOverride=false, $split=false, $cacheOverride=false) {
	global $api_instance;
	global $userStatusId;
	global $lDB;

	$result = [
		'principal_id' => $GLOBALS['principal_id']
	];
	foreach ($ac_accomm_type_id as $accomm) {
		$accommList = $lDB->get("
			SELECT
				ac_accomm_type_id
			FROM
				sc_accomm
			WHERE
				sc_group_id = '" . $GLOBALS['sc_group_id'] . "'
				AND ac_accomm_type_id = '" . $accomm . "'
		", 2);

		if (!empty($accommList) && db_ac_accomm_type_exists($accomm)) {
			$result[$accomm] = api_ac_get_stock($accomm, $fromDate, $toDate, $agentOverride, $split, $cacheOverride);
		}
	}

	return $result;
}

function api_ac_get_stock($ac_accomm_type_id, $fromDate=false, $toDate=false, $agentOverride=false,$split=false,$cacheOverride=false) {
	global $api_instance;
	global $userStatusId;
	global $lDB;
	
	$accommList = $lDB->get("
		SELECT
			ac_accomm_type_id
		FROM
			sc_accomm
		WHERE
			sc_group_id = '" . $GLOBALS['sc_group_id'] . "'
			AND ac_accomm_type_id = '" . $ac_accomm_type_id . "'
	",2);

	if (empty($accommList)) {
		return $api_instance->Error("Access Denied for this accommodation type");
	}

	if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
		return $api_instance->Error("Invalid accommodation type id");
	}

	// ignore 'linked' for external users
	if($userStatusId < 2 && $agentOverride == "linked") {
		$agentOverride = "";
	}

	if(!empty($agentOverride)) {
		if($userStatusId < 2) {
			return $api_instance->Error("Access denied for agent override.");
		}

		if(strtolower($agentOverride) == "linked") {
			$agentOverride = $GLOBALS['pr_agent_link'];
		}
	}

	if(!empty($agentOverride) && !db_pr_agent_exists($agentOverride)) {
		return $api_instance->Error("Invalid override agent id");
	}

	if(empty($agentOverride)) {
		$agentOverride = ""; // This is the value expected by the stock object
	}

	if($GLOBALS['userStatusId'] < 2) {
		$allocationAgent = $GLOBALS['calAgentId'];
	} else {
		$allocationAgent = $agentOverride;
	}


	if(!empty($split)) {
		$splitTotal = false;
		$splitProv = false;
		$splitAlloc = false;
		if(!is_array($split)) {
			$splitTotal = true;
			if($GLOBALS['showProv'] == "1") {
				$splitProv = true;
			}
			$splitAlloc = true;
		} else {
			//$split = array_pad($split,3,0);
			$splitTotal = (array_key_exists(0,$split) && !empty($split[0])) || (array_key_exists("total",$split) && !empty($split['total']));
			$splitProv = (array_key_exists(1,$split) && !empty($split[1])) || (array_key_exists("provisional",$split) && !empty($split['provisional']));
			if($splitProv && $GLOBALS['showProv'] == "0") {
				return $api_instance->Error("Access denied for provisional split");
			}
			$splitAlloc = (array_key_exists(2,$split) && !empty($split[2])) || (array_key_exists("allocation",$split) && !empty($split['allocation']));
		}
	}

	if(empty($fromDate)) {
		$now = explode("-",date("Y-m-d"));
		$fromDate = date("Y-m-d",mktime(0,0,0,$now[1],$now[2],$now[0]));
		$toDate = date("Y-m-d",mktime(0,0,0,$now[1],$now[2]+6,$now[0]));
	}
	if(empty($toDate)) {
		$now = explode("-",$fromDate);
		$toDate = date("Y-m-d",mktime(0,0,0,$now[1],$now[2]+6,$now[0]));
	}

	$fromDate = strtotime($fromDate);
	if($fromDate == -1) {
		return $api_instance->Error("Invalid from date");
	}

	$toDate = strtotime($toDate);
	if($toDate == -1) {
		return $api_instance->Error("Invalid to date");
	}

	$fromDate = date("Y-m-d",$fromDate);
	$toDate = date("Y-m-d",$toDate);

	if($toDate < $fromDate) {
		return $api_instance->Error("The to date must be greater than or equal to the from date");
	}

	if($userStatusId < 2 && $fromDate < date("Y-m-d")) {
		return $api_instance->Error("The from date may not be in the past");
	}

	$rf_date_res_limit = $lDB->get("SELECT rf_date_res_limit FROM rf_default",4);
	if($toDate > $rf_date_res_limit) {
		return $api_instance->Error("The to date may not be past the current system limit of $rf_date_res_limit");
	}

	$getAvail = new Stock($ac_accomm_type_id,$fromDate,$toDate,$agentOverride);
	if(!empty($cacheOverride) && ($cacheOverride & 1)) {
		$getAvail->SetCache(false);
	}
	if(empty($split)) {
		$result = $getAvail->ToAvailability();
	} else {
		$result = array();
		if($splitTotal) {
			$result['total'] = $getAvail->ToAvailability();
		}
		if($splitAlloc) {
			$result['allocation'] = $getAvail->ToAllocation($allocationAgent);
		}
		if($splitProv) {
			$result['provisional'] = $getAvail->ToProvisional();
		}
	}

	return $result;
}

function api_ac_get_max_stock_date() {
	global $lDB;

	return $lDB->get("SELECT rf_date_res_limit FROM rf_default",4);
}
