<?php

/*
 * $Id: api.stock.php,v 1.5 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.stock.php,v $
 * Revision 1.5  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.4  2012-10-15 14:05:15  light
 * Bug #6924 - Stock API to differentiate between confirmed & provisional reservations
 *
 * Revision 1.3  2011-05-17 14:08:35  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.2  2010-02-18 11:46:03  light
 * Bug #7051 - API changes (merged)
 *
 * Revision 1.1  2009-09-04 16:44:44  light
 * Bug #6940 - API: Reservation creation method missing
 *
 */

/**
 * api/api.stock.php - API definitions related to proprerty, accommodation and stock data
 */

$this->Register(array(
	'ac_get_property'=>array(
		'doc'=>"When passed a valid username and password, returns all available properties and their codes. Optionally a third parameter may be passed to search for specific property names. This search may use * or % as wildcard characters. Optionally a forth parameter may be passed to return additional information. This parameter is an array specifying the additional information required.",
		'signature'=>"?string,?array+struct"
	),
	'ac_get_accomm'=>array(
		'doc'=>"When passed a valid username, password and property code, returns all available accommodation types, their codes, max capacity and max adults.  Optionally a forth parameter may be passed to search for specific accommodation type names. This search may use * or % as wildcard characters. Optionally a fifth parameter may be passed to return additional information. This parameter is an array specifying the additional information required.",
		'signature'=>"string,?string,?array+struct"
	),
	'ac_get_stock'=>array(
		'doc'=>"When passed a valid username, password and accommodation code, returns availablity from the current date for 7 days. Optionally a third and forth parameter may be passed to specify a from and to date. When specifying dates no longer than one year of availability may be used at a time. A fifth optional parameter may be passed to override the agent used to calculate allocations using a valid agent id. If sixth optional parameter is specified an array of the different stock components requested will be returned instead of a single total array. The sixth paramater may either be set to 1 to return all available splits or an array to specify which splits are needed. A seventh optional parameter may be used to override caching. The seventh paramter may be blank or zero to use caching, 1 to skip ResRequest memory caching, 2 to skip brige memory caching, and 4 to skip bridge disc caching. These may be added together to skip multiple levels of caching",
		'signature'=>"string,?string,string,?string,?string+array+struct,?string",
		'access'=>array(
			array("function"=>50,"level"=>5)
		)
	),
	'ac_get_stock_batch'=>array(
		'doc'=>"When passed a valid username, password and accommodation code, returns availablity from the current date for 7 days. Optionally a third and forth parameter may be passed to specify a from and to date. When specifying dates no longer than one year of availability may be used at a time. A fifth optional parameter may be passed to override the agent used to calculate allocations using a valid agent id. If sixth optional parameter is specified an array of the different stock components requested will be returned instead of a single total array. The sixth paramater may either be set to 1 to return all available splits or an array to specify which splits are needed. A seventh optional parameter may be used to override caching. The seventh paramter may be blank or zero to use caching, 1 to skip ResRequest memory caching, 2 to skip brige memory caching, and 4 to skip bridge disc caching. These may be added together to skip multiple levels of caching",
		'signature'=>"array,?string,string,?string,?string+array+struct,?string",
		'access'=>array(
			array("function"=>50,"level"=>5)
		)
	),
	'ac_get_max_stock_date'=>array(
		'doc'=>"When passed a valid username and password returns the maximum date till which stock may be booked."
	)
));

