<?php

/*
 * $Id: api.system.func.php,v 1.1 2013-08-19 17:02:52 light Exp $
 *
 * $Log: api.system.func.php,v $
 * Revision 1.1  2013-08-19 17:02:52  light
 * Bug #8252 - API extensions for TVL
 *
 */

/**
 * api/api.system.func.php - System API functions
 */

function api_sc_get_version() {
	return getSystemVersion();	
}

function api_rf_get_country($search="") {
	global $lDB;
	
	$searchSQL = "";
	if(trim($search) != "") {
		$searchSQL = "
			AND rf_country.rf_country_name LIKE '".addslashes(str_replace("*","%",$search))."'
		";
	}

	$list = $lDB->get("
		SELECT DISTINCT
			rf_country.rf_country_ix,
			rf_country.rf_country_name,
			rf_country.rf_country_code
		FROM
			rf_country
		WHERE
			rf_country.rf_country_inactive=0
			$searchSQL
	",6);

	$newList = array();
	foreach($list as $item) {
		array_push($newList,[
			'id'=>$item['rf_country_ix'],
			'code'=>$item['rf_country_code'],
			'name'=>$item['rf_country_name']
		]);
	}

	return $newList;
}

function api_rf_get_env() {
	require_once(__DIR__ . '/../db.sc_env_group.php');
	$environments = db_sc_env_group_can_access($GLOBALS['sc_group_id']);

	$envTypeName = [
		"1" => "System",
		"2" => "Reservations",
		"4" => "Property"
	];

	foreach ($environments as $key => $environment) {
		$environments[$key][2] = $envTypeName[$environments[$key][2]];
		unset($environments[$key][3]);
	}

	return $environments;
}