<?php

require_once(__DIR__ . "/class.api.abstract.php");
require_once(__DIR__ . "/../db.ad_api.php");
require_once(__DIR__ . "/../utils/bridge/class.multicall.service.php");

use MaglLegacyApplication\Application\MaglLegacy;

class API extends APIAbstract
{
	private $Whitelist;
	public $multicallService;

	/**
	 * Constructor
	 * 
	 */
	public function __construct()
	{
		global $config;
		$this->Mode = "api";
		$this->isMulticall = false;
		$this->multicallService = new Bridge\Multicall\MulticallService($this);
		parent::__construct();
    $whitelist = $config['whitelist'] ?? array();
		$this->Whitelist = $whitelist;
	}

	protected function LoadMethod($method)
	{
		require_once(__DIR__ . '/api.' . $method . '.func.php');
		parent::LoadMethod($method);
	}

	protected function Authenticate($pr_user_name,$pr_user_password) {
		global $lDB;
		global $dbcode;

		$pr_user_id = $lDB->get("
			SELECT
				pr_user.pr_user_id
			FROM
				pr_user
				INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
			WHERE
				pr_user.pr_user_name='".strtolower($pr_user_name)."'
				AND pr_user.pr_user_inactive_yn=0
		",4);
		if(empty($pr_user_id)) {
			throw new Exception("Unable to retrieve user id.");
		}

		$application = MaglLegacy::getInstance()->getApplication();
		$passwordService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Password');
		$passwordService->setupContext($pr_user_password, $pr_user_id);

		if(!$passwordService->verify()) {
			throw new Exception();
		}

		$GLOBALS['userid'] = $pr_user_id;
		require(__DIR__ . "/../ac_logon.php");
		if(!$passwordService->finalise()) {
			throw new Exception("Unable to retrieve user id.");
		}

		if($_SESSION['require_password_change'] !== false) {
			throw new Exception("Password change required.");
		}

		return true;
	}

	protected function Access($access=false) {
		global $lDB;

		$allowAPI = $lDB->get("
			SELECT
				sc_group.sc_grp_api_yn
			FROM
				sc_user
				INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
			WHERE
				sc_user.pr_user_id = '$GLOBALS[userid]'
		",4);
		if(empty($allowAPI)) {
			return false;
		}	

		if(!empty($access)) {
			foreach($access as $item) {
				$level = $lDB->get("
					SELECT
						sc_fun_grp_level
					FROM
						sc_fun_group
					WHERE
						sc_fun_group.sc_group_id = '$GLOBALS[sc_group_id]'
						AND sc_fun_group.sc_function_id = '$item[function]'
				",4);
				if($level < $item['level']) {
					return false;
				}
			}
		}

		return true;
	}

	public function Wrapper($m="")
	{
		$ipAllowed = false;
		foreach($this->Whitelist as $ipPattern) {
			if(preg_match($ipPattern,$_SERVER['REMOTE_ADDR'])) {
				$ipAllowed = true;
			}
		}

		if($_SERVER['SERVER_ADDR'] != $_SERVER['REMOTE_ADDR'] && !$ipAllowed) {
			return $this->StandardError("access_denied");
		}
		
		$this->method = $method = $m->method();
    $this->uniqueId = uniqid();

		$params = array();
		for($count=0; $count<$m->getNumParams(); $count++) {
			array_push($params,php_xmlrpc_decode($m->getParam($count)));
		}
		$username = addslashes(array_shift($params));
		$password = addslashes(array_shift($params));
    $this->bridgeUsername = "";
    $this->principalUsername = $username;
    $this->environmentCode = trim(isset($GLOBALS['dbcode']) ? $GLOBALS['dbcode'] : "");
    $this->principalId = trim(isset($GLOBALS['principal_id']) ? $GLOBALS['principal_id'] : "");
 
    if (!$this->isBridgeOrigin()) {
      // only log if not logged by bridge
      $this->log(
        $this->uniqueId,
        $this->bridgeUsername,
        $this->principalUsername,
        $this->principalId,
        $this->environmentCode,
        $this->method,
        self::CALL_TYPE_REQUEST,
        $params
      );
    }
		try {
			$this->Authenticate($username,$password);
		} catch (Exception $e) {
			return $this->StandardError("invalid_login", $e->getMessage());
		}

		if(!isset($this->Map[$method]['access'])) {
			$access = array();
		} else {
			$access = $this->Map[$method]['access'];
		}
		if(!$this->Access($access)) {
			return $this->StandardError("access_denied");
		}


		if(!array_key_exists($method,$this->Map)) {
			return $this->StandardError("invalid_method_name");
		}

    db_ad_api_insert($method);
		$result = call_user_func_array($this->Map[$method]['real_function'],$params);

		if($result === false) {
			return $this->StandardError("invalid_method_return");
		}

    if (!$this->isBridgeOrigin()) {
      // only log if not logged by bridge
      $this->log(
        $this->uniqueId,
        $this->bridgeUsername,
        $this->principalUsername,
        $this->principalId,
        $this->environmentCode,
        $this->method,
        self::CALL_TYPE_RESPONSE,
        is_array($result) ? $result : []
      );
    }

		if(is_a($result, 'xmlrpcresp')) {
			return $result;
		} else {
      $xmlrpcresp = new xmlrpcresp(php_xmlrpc_encode($result));
			return $xmlrpcresp;
		}
	}

	/**
	 * Check headers to determine if this was invoked by the bridge
	 *
	 * @return boolean
	 */
  protected function isBridgeOrigin() {
    $bridgeOriginHeader = $_SERVER['HTTP_BRIDGE_ORIGIN'] ?? "";
    $bridgeHashCode = $_SERVER['HTTP_BRIDGE_ORIGIN_AUTH'] ?? "";
    if ($bridgeOriginHeader && $bridgeHashCode === $this->getHashCode()) {
      return true;
    }
    return false;
  }

	public function handleMulticall($server, $message)
	{
		$this->isMulticall = true;
		return $this->multicallService->service($server, $message);
	}
}
