<?php

/**
 * PHP-XMLRPC "logger" functionality
 * Add a generic logger function using error_log() if no other known function is defined.
 *
 * @version $Id: xmlrpc_logger.php,v 1.2 2011-05-17 14:08:35 light Exp $
 * @author Dylan Bridgman
 */

if(!function_exists('xmlrpc_log')) {
	function xmlrpc_log($level, $message) {
		if(function_exists('log_message')) {
			log_message($level, $message);
		} else {
			error_log(ucwords($level) . ": " . $message);
		}
	}
}
