<?php

/**
 * class.audit.php - Class to manage keep track of and create audit trail entries
 **/

require_once(__DIR__ . '/db.ad_reservation.php');
require_once(__DIR__ . '/db.ad_res_detail.php');
require_once(__DIR__ . '/db.ad_useraccess.php');
require_once(__DIR__ . '/db.ad_useraccess_detail.php');
require_once(__DIR__ . '/db.ad_misc.php');
require_once(__DIR__ . '/db.ad_misc_detail.php');
require_once(__DIR__ . '/db.ad_persona.php');
require_once(__DIR__ . '/db.ad_persona_detail.php');
require_once(__DIR__ . '/functions.persona.audit.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/functions.reservation.audit.php');
require_once(__DIR__ . '/db.ad_module_field.php');

define("TYPE_RESERVATION",1);
define("TYPE_USERACCESS",2);
define("TYPE_PERSONA",3);
define("TYPE_MISC",4);

class AuditTrail {

  protected $recordId = null;
  protected $recordType = null;
  protected $detailItems = array();
  protected $action = null;
  protected $updateReservation = true;
  protected $comment = null;
  protected $db = null;
  const TYPE_RESERVATION = 1;
  const TYPE_USERACCESS = 2;
  const TYPE_PERSONA = 3;
  const TYPE_MISC = 4;

  public function getRecordId() {
    return $this->recordId;
  }

  public function getRecordType() {
    return $this->recordType;
  }

  public function getDetailItems() {
    return $this->detailItems;
  }

  public function setDetailItems($detailItems) {
    $this->detailItems = $detailItems;
  }

  public function getAction() {
    return $this->action;
  }

  public function setAction($action) {
    $this->action = $action;
  }

  public function getUpdateReservation() {
    return $this->updateReservation;
  }

  public function setUpdateReservation($updateReservation) {
    $this->updateReservation = $updateReservation;
  }

  public function getComment() {
    return $this->comment;
  }

  public function setComment($comment) {
    $this->comment = $comment;
  }


  function __construct($recordId, $recordType=TYPE_RESERVATION, $config=[], $db = null) {
    global $lDB;
    $this->db = $db === null ? $lDB : $db;
    $this->recordId = $recordId;
    $this->recordType = $recordType;
    $this->config = $config;
  }

  public function save($comment=null) {
    $this->comment = (!empty($comment)) ? $comment : $this->comment;
    switch($this->recordType) {
    case TYPE_RESERVATION:
      ammendReservation($this->recordId, $this->comment, $this->updateReservation, $this->detailItems);
      break;
    case TYPE_USERACCESS:
      db_ad_useraccess_insert($this->recordId, $this->comment, $this->detailItems);
      break;
    case TYPE_PERSONA:
      db_ad_persona_insert($this->recordId, $this->comment, $this->detailItems, $this->config['rv_reservation_id']??false);
      break;
    case TYPE_MISC:
      db_ad_misc_insert($this->recordId, $this->comment, $this->detailItems, $this->config['rv_reservation_id']??false);
      break;
    default:
      throw new Exception("Audit trail record cannot be created because the record type is not defined.");
      break;
    }
  }

  /**
   * Sets a flag on a reservation marking it as specially modified.
   *
   * @return void
   */
  public function flagReservationModification() {
    $flagMod = "UPDATE rv_reservation
      SET rv_mod_yn = 1, rv_mod_date = NOW()
      WHERE rv_reservation_ix = '$this->recordId'";
    $this->db->put($flagMod);
  }

  public function addDetail(
    $ad_res_detail_value_from, 
    $ad_res_detail_value_to, 
    $ad_res_detail_id_from, 
    $ad_res_detail_id_to, 
    $ad_res_detail_action_ind, 
    $rf_audit_module_description_internal, 
    $ad_module_field_name,
    $ad_res_detail_field_id=false,
    $ad_res_detail_value_from_display=false,
    $ad_res_detail_value_to_display=false
  ) {
    $canAppend = false;
    $ad_module_field = $this->db->get("
      SELECT 
        ad_module_field.ad_module_field_id,
        ad_module_field.ad_module_field_display,
        ad_module_field.ad_module_field_name,
        tc_table.tc_table_name,
        tc_table_from.tc_table_name AS tc_table_name_from
      FROM 
        ad_module_field 
        INNER JOIN rf_audit_module ON rf_audit_module.rf_audit_module_id = ad_module_field.rf_audit_module_id
        INNER JOIN tc_table tc_table_from ON tc_table_from.tc_table_id = ad_module_field.tc_table_id
        LEFT JOIN tc_table ON tc_table.tc_table_id = ad_module_field.tc_table_id_display
      WHERE 
        ad_module_field.ad_module_field_name = '$ad_module_field_name'
        AND rf_audit_module.rf_audit_module_description_internal = '$rf_audit_module_description_internal'
    ",1);
    $ad_module_field_id = $ad_module_field['ad_module_field_id'];
    $ad_module_field_display_type_ind = db_ad_module_field_get_display_type($ad_module_field_id);
    // Make sure number values are cast to appropriate type to help empty(...) checks
    if (in_array($ad_module_field_display_type_ind, array(DB_AD_RES_DETAIL_TYPE_CURRENCY, DB_AD_RES_DETAIL_TYPE_FLOAT, DB_AD_RES_DETAIL_TYPE_INTEGER))) {
      $ad_res_detail_value_from = (float)$ad_res_detail_value_from;
      $ad_res_detail_value_to = (float)$ad_res_detail_value_to;
    }
    if ($ad_res_detail_action_ind == DB_AD_RES_DETAIL_ACTION_EDIT) {
      if (
        ($ad_res_detail_value_from != $ad_res_detail_value_to)
        || (
          $ad_res_detail_field_id !== false
          && ($ad_res_detail_value_from_display != $ad_res_detail_value_to_display)
        )
      ) {
        $canAppend = true;
      }
    } elseif ($ad_res_detail_action_ind == DB_AD_RES_DETAIL_ACTION_ADD) {
      switch($ad_module_field_display_type_ind) {
      case DB_AD_RES_DETAIL_TYPE_BOOLEAN:
        $canAppend = true;
        break;
      case DB_AD_RES_DETAIL_TYPE_DATE:
        if (!empty($ad_res_detail_value_to) && $ad_res_detail_value_to != "0000-00-00 00:00:00" && $ad_res_detail_value_to != "0000-00-00") {
          $canAppend = true;
        }
        break;
      case DB_AD_RES_DETAIL_TYPE_DATETIME:
        if (!empty($ad_res_detail_value_to) && $ad_res_detail_value_to != "0000-00-00 00:00:00" && $ad_res_detail_value_to != "0000-00-00") {
          $canAppend = true;
        }
        break;
      case DB_AD_RES_DETAIL_TYPE_TIME:
        if (!empty($ad_res_detail_value_to) && $ad_res_detail_value_to != "0000-00-00 00:00:00") {
          $canAppend = true;
        }
        break;
      default:
        if (
          !empty($ad_res_detail_value_to)
          || (
            $ad_res_detail_field_id !== false
            && !empty($ad_res_detail_value_to_display)
          )
        ) {
          $canAppend = true;
        }
        break;
      }
    } else {
      switch($ad_module_field_display_type_ind) {
      case DB_AD_RES_DETAIL_TYPE_BOOLEAN:
        $canAppend = true;
        break;
      case DB_AD_RES_DETAIL_TYPE_DATE:
        if (!empty($ad_res_detail_value_from) && $ad_res_detail_value_from != "0000-00-00 00:00:00" && $ad_res_detail_value_from != "0000-00-00") {
          $canAppend = true;
        }
        break;
      case DB_AD_RES_DETAIL_TYPE_DATETIME:
        if (!empty($ad_res_detail_value_from) && $ad_res_detail_value_from != "0000-00-00 00:00:00" && $ad_res_detail_value_from != "0000-00-00") {
          $canAppend = true;
        }
        break;
      case DB_AD_RES_DETAIL_TYPE_TIME:
        if (!empty($ad_res_detail_value_from) && $ad_res_detail_value_from != "0000-00-00 00:00:00") {
          $canAppend = true;
        }
        break;
      default:
        if (
          !empty($ad_res_detail_value_from)
          || (
            $ad_res_detail_field_id !== false
            && !empty($ad_res_detail_value_from_display)
          )
        ) {
          $canAppend = true;
        }
        break;
      }
    }
    if ($canAppend) {
      // If this is a dynamic field (eg guest profile or tripsheet)
      // then all values will already be set
      if($ad_res_detail_field_id === false) {
        // If the value being stored is a foreign key, get a value to store 
        // that will be displayed to the user
        $ad_res_detail_value_from_display = Null;
        $ad_res_detail_value_to_display = Null;
        if (!empty($ad_module_field['tc_table_name'])) {
          if (in_array($ad_res_detail_action_ind, array(DB_AD_RES_DETAIL_ACTION_EDIT, DB_AD_RES_DETAIL_ACTION_DELETE))) {
            $ad_res_detail_value_from_display = $this->db->get("
              SELECT
              " . $ad_module_field['ad_module_field_display'] . " AS field1
              FROM
              " . $ad_module_field['tc_table_name'] . "
              WHERE
              " . db_tc_table_get_key($ad_module_field['tc_table_name']) . " = '" . $ad_res_detail_value_from . "'
              ",4);
          }
          $ad_res_detail_value_to_display = $this->db->get("
            SELECT
            " . $ad_module_field['ad_module_field_display'] . " AS field1
            FROM
            " . $ad_module_field['tc_table_name'] . "
            WHERE
            " . db_tc_table_get_key($ad_module_field['tc_table_name']) . " = '" . $ad_res_detail_value_to . "'
            ",4);
        } elseif (substr($ad_module_field['ad_module_field_name'], -4) === "_ind") {
          // This is an indicator field - find its db file and run the appropriate
          // db_<field name>_desc function to get it's display value
          $fileName = "db." . $ad_module_field['tc_table_name_from'] . ".php";
          $fileExists = file_exists("/" . $fileName);
          if ($fileExists) {
            require_once(__DIR__ . "/" . $fileName);
          }
          $functionName = "db_" . str_replace("_ind", "_desc", explode(".", $ad_module_field['ad_module_field_name'])[1]);
          if (in_array($ad_res_detail_action_ind, array(DB_AD_RES_DETAIL_ACTION_EDIT, DB_AD_RES_DETAIL_ACTION_DELETE))) {
            try {
              $ad_res_detail_value_from_display = call_user_func($functionName, $ad_res_detail_value_from);
            } catch(Exception $ex) {
              $ad_res_detail_value_from_display = $ad_res_detail_value_from;
            }
          }
          try {
            $ad_res_detail_value_to_display = call_user_func($functionName, $ad_res_detail_value_to);
          } catch(Exception $ex) {
            $ad_res_detail_value_to_display = $ad_res_detail_value_to;
          }
        } else {
          $ad_res_detail_value_from_display = $ad_res_detail_value_from;
          $ad_res_detail_value_to_display = $ad_res_detail_value_to;
          $ad_res_detail_value_from = Null;
          $ad_res_detail_value_to = Null;
        }
      }
      $this->detailItems[] = array(
        'ad_res_detail_value_from' => $ad_res_detail_value_from,
        'ad_res_detail_value_to' => $ad_res_detail_value_to,
        'ad_res_detail_value_from_display' => $ad_res_detail_value_from_display,
        'ad_res_detail_value_to_display' => $ad_res_detail_value_to_display,
        'ad_res_detail_id_from' => $ad_res_detail_id_from,
        'ad_res_detail_id_to' => $ad_res_detail_id_to,
        'ad_res_detail_field_id'=> $ad_res_detail_field_id,
        'ad_res_detail_action_ind' => $ad_res_detail_action_ind,
        'ad_module_field_id' => $ad_module_field_id
      );
    }
  }

  public function addDetailMisc(
    $ad_res_detail_value_from,
    $ad_res_detail_value_to,
    $ad_res_detail_action_ind,
    $ad_misc_detail_field_name
  ) {
    $this->detailItems[] = array(
      'ad_res_detail_value_from' => $ad_res_detail_value_from,
      'ad_res_detail_value_to' => $ad_res_detail_value_to,
      'ad_res_detail_action_ind' => $ad_res_detail_action_ind,
      'ad_misc_detail_field_name' => $ad_misc_detail_field_name
    );
  }

  public function fetch($fromDate=false,$toDate=false,$parameters=false) {
    switch($this->recordType) {
    case TYPE_RESERVATION:
      return getResAudit($this->recordId,$fromDate,$toDate,$parameters);
    case TYPE_PERSONA:
      return getPersonaAudit($this->recordId, $fromDate, $toDate, $parameters);
    default:
      throw new Exception("Audit trail record cannot be found because the record type is not defined.");
      break;
    }
  }
}
