<?php

//# # # # # # # # # # # # # # # # # # # # # # # # # # # # #
//      Form Class - The MySQL Form Generator v3          #
//      Tobie van der Spuy - 2002                         #
//      tobie@eplay.co.za                                 #
//# # # # # # # # # # # # # # # # # # # # # # # # # # # # #

Class Form {

// Form Variables -------------------------------------------------------------
	var $Name;						// Name of form object
	var $Arguments;				// Page(Task) ID and Job ID executed on submit
	var $FormHTML;				// HTML populated for each form - null will output in auto generated list format
	var $HTML;						// Name of above HTML file
	
	var $TargetPage;			// Defaulted: Which php file to execute
	var $Enctype;					// Defaulted: Determine whether this form can upload files
	var $Method;					// Defaulted: Which method to use when passing form inputs
	var $SubmitValue;			// Defaulted: Displayed text on the save/submit button
	
	var $TableList;				// Generated: List of all Tables in form
	var $IdentTable;			// Generated: Table containing the human readable entries to identify a record
	var $FieldList;				// Generated: List of all fields in form (contains field class)

	var $ValidateList;		// Optional: List of fields that require validation
	var $HideList;				// Optional: List of hidden fields
	var $EqualList;				// Optional: List of fields set equal to others (don't show them on form)
	
	var $RecordList;			// Optional: Result of external SQL Query that generated a listing of records
	var $RecordListSQL;		// Optional: SQL Query to generate a listing of records
	var $RecordCheckSQL;	// Optional: SQL Query to verify that record exists
	
	var $NoRowsHTML;     	// Optional: Echo this when no records are found
	var $ListHTML;       	// Optional: HTML (file) used as framework for listing rows
	var $RowHTML;        	// Optional: Rows to be populated by the generated values
	
	var $PopUpHTML;				// Optional: HTML to be populated for a popup window
	var $PopUpURL;				// Optional: URL to use when called in a popup window
	var $PopUpSize;				// Optional: Dimensions to resize the popup window to onload
	var $PopUpTitle;			// Optional: Description or Title to echo on popup window
	
	var $Focus;						// Optional: Field to receive focus on load
	var $Events;					// Optional: Array of Form JavaScript Events (onload, etc)
	var $FieldEvents;			// Optional: Array of JavaScript Events passed to all fields
	
	var $error;						// All posssible form related errors get stored here


// Form Methods ---------------------------------------------------------------
	// Constructor
	function __construct($name, $arguments, $HTML="", $enctype="application/x-www-form-urlencoded", $method="POST") {
		// get HTML string from htm file
      if ($HTML != "") {
         $formhtml = Join("",File($HTML));
      } else {
         $formhtml = "";
      }

      // setup object variables
      $this->Name = $name;
      $this->TargetPage = "reservation.php";
      $this->Arguments = $arguments;

      $this->FormHTML = $formhtml;
      $this->HTML = $HTML;
      $this->Enctype = $enctype;
      $this->Method = $method;
      $this->SubmitValue = "Submit";

      $this->TableList = array();
      $this->IdentTable = "";
      $this->FieldList = array();

      $this->ValidateList = array();
      $this->HideList = array();
      $this->EqualList = array();

      $this->RecordList = array();
      $this->RecordListSQL = "";
      $this->RecordCheckSQL = "";

      $this->NoRowsHTML = "";
      $this->ListHTML = "";
      $this->RowHTML = "";

      $this->PopUpHTML = "";
      $this->PopUpURL = "";
      $this->PopUpSize = "";
      $this->PopUpTitle = "";

      $this->Focus = "";
      $this->Events = array();
      $this->FieldEvents = array();

      $this->error = "";
   }

#==================================================================================================

   # Add a new table
   function AddTable (&$db,$table,$fieldlist=array(),$wheresql="",$andsql="",$ordersql="",$identfields=array()) {
      # check inputs
      checkarray($fieldlist);
      checkarray($identfields);

      $tablename = $this->Name."_".$table;
      array_push($this->TableList,$tablename);
      $GLOBALS[$tablename] = new MySQLTable ($this->Name,$db,$tablename,$table,$fieldlist,$wheresql,$andsql,$ordersql,$identfields);
   }

#==================================================================================================

   # Add a Validatelist
   function Validate ($fields) {
      # if $fields is a string, explode into an array
      checkarray($fields);

      # store the field list in the form
      $this->ValidateList = $fields;
   }

#==================================================================================================

   # Add a non-DB field (name, id, fieldtype, value)
   function AddField ($fieldname,$varname,$value,$class) {
      # clean the error variable
      $error = "";

      # check that field doesn't already exist
      if (!in_array($fieldname,$this->FieldList)) {

         # !DEMO! update when Field Objects work
         $GLOBALS[$fieldname] = new MySQLField($fieldname,$varname,$value,$class);

         array_push($this->FieldList,$fieldname);
      } else {
         $error .= " | ".$this->Name." >> $fieldname already exists!<br>\n";
      }

      # if no errors reported, return true, else return error
      if ($error == "") {
         return True;
      } else {
         $this->error .= $error;
         return False;
      }
   }

#==================================================================================================

   # Delete field from the form's fieldlist
   function DeleteField ($fieldname) {
      # check that field doesn't already exist
      if (in_array($fieldname,$this->FieldList)) {
         # Delete field from fieldlist
         $temparray = array_flip($this->FieldList);
         $i = $temparray[$fieldname];
         $this->FieldList[$i] = "";
         cleanse ($this->FieldList);
      }
   }

#==================================================================================================

   # Hide fields and echo them with formsubmit anchor
   function Hide ($fields) {
      # if $fields is a string, explode into an array
      checkarray($fields);

      # clean the error variable
      $error = "";

      # for each field specified do:
      $imax = sizeof($fields);
      for ($i = 0; $i < $imax; $i++) {
         $fieldname = $fields[$i];
         if (in_array($fieldname,$this->FieldList)) {
            array_push($this->HideList,$fieldname);
            $GLOBALS[$fieldname]->IsHidden = "1";
         } else {
            $error .= " | ".$this->Name." >> $fieldname doesn't exists!<br>\n";
         }
      }

      # if no errors reported, return true, else return error
      if ($error == "") {
         return True;
      } else {
         $this->error .= $error;
         return False;
      }
   }

#==================================================================================================

   # UnHide field and echo under normal anchor
   function ShowField ($fields) {
      # clean the error variable
      $error = "";

      # for each field specified do:
      $imax = sizeof($fields);
      for ($i = 0; $i < $imax; $i++) {
         $fieldname = $fields[$i];
         if (in_array($fieldname,$this->FieldList)) {
            if (in_array($fieldname,$this->Hidelist)) {
               # Delete field from hidelist
               $temparray = array_flip($this->HideList);
               $i = $temparray[$fieldname];
               $this->HideList[$i] = "";
            }
         } else {
            $error .= " | ".$this->Name." >> $fieldname doesn't exists!<br>\n";
         }
      }

      # if no errors reported, return true, else return error
      if ($error == "") {
         return True;
      } else {
         $this->error .= $error;
         return False;
      }
   }

#==================================================================================================

   # Disable fields but still display them
   function Disable ($fields) {

      # if $fields is a string, explode into an array
      checkarray($fields);

      # clean the error variable
      $error = "";

      # for each field specified do:
      $imax = sizeof($fields);
      for ($i = 0; $i < $imax; $i++) {
         $fieldname = $fields[$i];
         if (in_array($fieldname,$this->FieldList)) {
            $GLOBALS[$fieldname]->IsDisabled = "1";
         } else { /*$error .= " | ".$this->Name." >> $fieldname doesn't exists!<br>\n"; */
         }
      }

      # if no errors reported, return true, else return error
      if ($error == "") {
         return True;
      } else {
         $this->error .= $error;
         return False;
      }
   }

#==================================================================================================

   # Build a list of all the fields in the form
   function Get ($action) {
      # reverse table order - why? >> dunno, but some of my older stuff doesnt work without it
      $this->TableList = array_reverse($this->TableList);

      cleanse($this->TableList);

      # for each table do this
      $imax = sizeof($this->TableList);
      for ($i = 0; $i < $imax; $i++) {
         $table = $this->TableList[$i];
         $GLOBALS[$table]->Get($action);
         $temp = $GLOBALS[$table]->FieldList;
         cleanse($temp);
         $final = array();

         # for each field do this
         foreach ($temp as $field) {
            # if field is set equal to another, add the other field's name
            if (in_array($field,$this->EqualList)) {
               $name = $ieq[$field];
            }
            array_push($final,$field);
         }
         # update temporary list
         $this->FieldList = array_merge($final,$this->FieldList);
      }

      # update field list
      $this->FieldList = array_unique($this->FieldList);
   }

#==================================================================================================

   # Clear the field and/or table list(s)
   function Kill ($code="0") {
      $this->TableList = array_reverse($this->TableList);

      switch ($code) {
         case (0) :  # Reset Field list
            $this->FieldList = array();
            break;
         case (1) :  # Reset Table list
            $this->TableList = array();
            break;
         case (2) :  # Reset both Table and Field lists
            $this->TableList = array();
            $this->FieldList = array();
            break;
      }
   }

#==================================================================================================

   # Call the submit function on all child tables
   function Submit ($paction) {

   	$error = (isset($error) ? $error : "");
    
      # for each table run the submit method
      $imax = sizeof($this->TableList);
      for ($i = 0; $i < $imax; $i++) {
         $table = $this->TableList[$i];
         if ($GLOBALS[$table]->submit($this,$paction)) {
         } else {
            $error .= " | ".$this->Name." >> Error in $table<br>\n";
         }
      }

      # if no errors reported, return true, else return error
      if ($this->error == "") {
         return True;
      } else {
         $this->error .= $error;
         return False;
      }
   }

#==================================================================================================
   # Populate the FormHTML with data and return it
   function Show ($paction,$db="",$record="0") {

      if(strpos($this->FormHTML,"!TOP_CONTENTS!") === true || strpos($this->FormHTML,"id=\"TOP_CONTENTS\"") === true) {
         $GLOBALS[isPopup] = false;
      }

      # send all display, new and update calls to action 1;
      if ($paction <= "3" && $paction >= "1") {
         $action = "1";
      } else {
         $action = $paction;
      }

      if (isset($GLOBALS['DONTFORMPARSE']) && $GLOBALS['DONTFORMPARSE'])
      {
         $outvalue = $this->FormHTML;
      }
      else
      {
         $tempvalues = array();

         switch ($action) {
            case (0) :     # Generate full listing of records in db

               ###############################
               # Phase 1: Get the Recordlist #
               ###############################

               # verify that the recordlist contains no null fields
               checkarray($this->RecordList);

               # verify that we have a database connection
               if ($db == "") {
                  $db = $GLOBALS[lDB];
               }

               $table = $this->IdentTable;
               if ($table == "") {
                  $table = $this->TableList[0];
               }
               $table = $GLOBALS[$table]->Table;

               # get the list of records if the RecordList is empty
               if (sizeof($this->RecordList) == "0") {
                  # if the RecordListSQL is also empty, generate it!
                  if ($this->RecordListSQL == "") {
                     $keyfield = $GLOBALS[$table]->FieldList[0];
                     $keyname = $GLOBALS[$keyfield]->Varname;
                     $sql = "select $keyname from $table";
                     $wheresql = $GLOBALS[$table]->wheresql;
                     if ($wheresql != "" && (strpos($wheresql,$keyname) === false)) {
                        $wheresql = " where".$wheresql;
                        if ($andsql != "" && (strpos($andsql,$keyname) === false)) {
                           $andsql = " and".$andsql;
                        }
                     } else {
                        if ($andsql != "" && (strpos($andsql,$keyname) === false)) {
                           $andsql = " where".$andsql;
                        }
                     }
                     $this->RecordListSQL = $sql.$wheresql.$andsql;
                  }

                  if ($this->RecordCheckSQL != "") {
                     # execute RecordListSQL and build RecordList from result
                     $templist = $db->get($this->RecordListSQL,"2");
                  }

                  if (sizeof($templist) >= "1") {
                     # add each record to recordlist
                     foreach ($templist as $recordid) {
                        array_push($this->RecordList,$recordid[0]);
                     }
                  }
               }

               ##############################
               # Phase 2: Generate the List #
               ##############################

               # now for each record in the RecordList do this
               if ($this->RecordCheckSQL != "") {
                  $check = $db->get($sql4,"1");
               } else {
                  $check[0] = sizeof($this->RecordList);
               }

               if ($check[0] != "0") {
                  $GLOBALS[temp][recordsfound] = $check[0];
                  $list = array();
                  $this->RecordList;
                  $q = 1;
                  foreach ($this->RecordList as $record) {
                     #$record = $this->RecordList[$i];

                     # refresh the form object for each of the records in the db
                     $this->Refresh($record,"0");

                     # clear the list and setup the seperator
                     if ($this->RowHTML == "") {
                        $seperator1 = " - ";
                     }

                     # for each field in the form
                     $row = array();
                     foreach ($this->FieldList as $field) {
                        if (!in_array($field, $this->HideList)) {
                           $value = $GLOBALS[$field]->Show();
                           $temp = array ($field => $value);

                           # populate rowhtml and add to list
                           $row = array_merge($temp,$row);
                        }
                     }
                     $increment = array ("increment" => (string) $q++);
                     $row = array_merge($increment,$row);
                     $list[rows] .= showpage($row,$this->RowHTML,$seperator);
                  }
                  return showpage($list,$this->ListHTML);
               } else {
                  $GLOBALS[temp][recordsfound] = "0";
                  $list = array("rows" => $this->NoRowsHTML);
                  return showpage($list,$this->ListHTML);
               }
               break;
            case (1) :     # Generate (1)Display / (2)New / (3)Update form

               # generate the html for each field from it's object
               $formstart = $this->Name."start";
               $formend = $this->Name."end";
               $formhide = $this->Name."hide";

               $start = "<form name=\"".$this->Name .
             "\" id=\"".$this->Name.
                  "\" action=\"".$this->TargetPage."?".$this->Arguments .
                  "\" method=\"".$this->Method .
                  "\" enctype=\"".$this->Enctype .
                  "\" style=\"display:inline\">\n";
            $end = "";
							// $end = "<input type=submit name=submit value=\"".$this->SubmitValue."\">";
							if ( !array_key_exists('mode',$GLOBALS) ) {
								$GLOBALS['mode'] = "";
							}

							if(!array_key_exists('addCheck',$GLOBALS)) {
								$GLOBALS['addCheck'] = "";
							}

							$end .= "<input type=\"hidden\" id=\"mode\" name=\"mode\" value=\"".$GLOBALS['mode']."\" />\n";
							$end .= "<input type=\"hidden\" id=\"jobid\" name=\"jobid\" value=\"\" />\n";
							$end .= "<input type=\"hidden\" id=\"addcheck\" name=\"addcheck\" value=\"".$GLOBALS['addCheck']."\" />\n";
							$end .= "</form>";

							$tempvalues = array( $formstart => $start);
							$endvalues = array(  $formhide => "", $formend => $end);
               foreach ($this->FieldList as $name) {
                  if (!in_array($name, $this->HideList)) {
                     if ($paction == "1") {
                        $data = $GLOBALS[$name]->Show($paction);
                     } else {
                        $data = $GLOBALS[$name]->Make($paction);
                     }
                     // $data = stripslashes($data);
                     $tmpp = array("$name" => "$data");
                     $tempvalues = array_merge($tempvalues,$tmpp);
                  } else {
                     if ($paction != "1") {
                        $data = $GLOBALS[$name]->Make($paction);
                        // $data = stripslashes($data);
                        $endvalues[$formhide] .= $data;
                     }
                  }
               }
               $tempvalues = array_merge($tempvalues,$endvalues);
               break;
            case (4) :     # Generate delete record confirmation form
               # setup some required variables
               $path = $this->TargetPage."?".$this->Arguments;
               $table = $this->TableList[0];

               $keyfield = $GLOBALS[$table]->FieldList[0];
               $keyname = $GLOBALS[$keyfield]->Varname;
               $tmpfields = $GLOBALS[$table]->IdentFields;
               $wheresql = $GLOBALS[$table]->WhereSQL;
               $andsql = $GLOBALS[$table]->AndSQL;

               $sql = " where $keyname = '$record'";
               if ($wheresql != "" && (strpos($andsql,$wheresql) === false)) {
                  $wheresql = " where".$wheresql;
                  if ($andsql != "" && (strpos($andsql,$keyname) === false)) {
                     $andsql = " and".$andsql;
                  } else {
                     $andsql = "";
                  }
               } else {
                  $wheresql = "";
                  if ($andsql != "" && (strpos($andsql,$keyname) === false)) {
                     $andsql = " where".$andsql;
                  } else {
                     $andsql = "";
                  }
               }
               $sql2 = "select count(*) from $table".$sql.$wheresql.$andsql;
               # $string = "select count(*) from $table where $keyname = '$record'";

               # execute SQL string
               $temp = $db->get($sql2,"1");

               # if the record exists ask confirmation to delete
               if ($temp[0] == "1") {
                  $error .= "";
                  $string2 = "select $keyname";

                  foreach ($tmpfields as $field) {
                     $field2 = $GLOBALS[$table]->FieldList[$field];
                     $name = $GLOBALS[$field2]->name;
                     if ($name != $keyname && $name != "") {
                        $string2 .= ", ";
                        $string2 .= $name;
                     }
                  }
                  $field = $tmpfields[$i];
                  $name = $GLOBALS[$field]->name;
                  if ($name != $keyname && $name != "") {
                     $string2 .= ",";
                     $string2 .= $name;
                  }

                  $string2 .= " from $table".$sql.$wheresql.$andsql;

                  $temp2 = $db->get($string2,"1");
                  $out .= "Really delete record: <b>";

                  $imax = sizeof($temp2);
                  for ($i = 0; $i < $imax; $i++) {
                     $valz = $temp2[$i];
                     if ($valz != "") {
                        if ($i != "0") {
                           $out .= ", ";
                        }
                        $out .= $valz;
                     }
                  }
                  $out .= "</b>?<br><a href=".$path."+".$temp2[0].">Really Delete</a>";
                  $tempvalues[rows] = $out;
               } else {
                  $tempvalues[rows] = "No Records To Delete!";
               }
               break;
            case (5) :     # Generate popup listing of relevant records
               # Place holder, will write later when/if popup is specced
               break;
         }
         $outvalue = showpage($tempvalues,$this->FormHTML);
      }
      $exit = array($this->Name => $outvalue);
      return $exit;
   }

// Additional Methods
#==================================================================================================

   # Refresh all tables in form according to $record
   function Refresh ($record,$action) {

      $debug = "... ".$this->Name." refreshing ($action)<br>";
      #echo $debug;

      # reverse tables - why? >> See above somewhere
      $this->TableList = array_reverse($this->TableList);

      # for each table run the submit method
      foreach ($this->TableList as $table) {
         $GLOBALS[$table]->Refresh($record,$action);
      }

      # destroy previous field listing
      $this->Kill();

      # generate new field listing
      $formid = preg_replace("/[A-z]/i","",$this->Name);
      initform($db,$formid,$action);
      $this->Get($action);
   }


#==================================================================================================

   # Set a field equal to another in the form
   function EqualFields ($victim,$host) {
      $GLOBALS[$victim]->varname = $GLOBALS[$host]->varname;
      $temp = array($victim => $host);
      array_push($this->Equal,$temp);
   }

#==================================================================================================

   # Show a listing of all the Form's fields
   function ListFields () {
      $list = "<table><tr>".
         "<td><b>Object</b></td><td width=10></td>".
         "<td align=center><b>Class</b></td><td width=10></td>".
         "<td align=center><b>Value</b></td></tr>";
      foreach ($this->FieldList as $field) {
         $list .= "<tr><td>".$field."</td><td width=10></td>".
            "<td align=center>(".$GLOBALS[$field]->Class.")</td><td width=10></td>".
            "<td align=center>".$GLOBALS[$field]->Value."</td></tr>\n";
      }
      $list .= "</table>";
      return $list;
   }

#==================================================================================================

   # Specify which field to recieve focus onload
   function SetFocus ($field) {
      $this->Focus = $field;
   }

#==================================================================================================

   # Add a JavaScript event for the form
   function AddEvent ($event,$action) {
      $temp = array($event => $action);
      array_push($this->Events,$temp);
   }

#==================================================================================================

   # Add a JavaScript event to each field in the form
   function AddFieldsEvent ($event,$action) {
      $temp = array($event => $action);
      array_push($this->FieldEvents,$temp);
   }

#==================================================================================================

   # Specify PopUp URL, Window Size, and Description
   function SetPopUp ($URL,$x=440,$y=220,$HTML="",$desc="") {
      # get HTML string from htm file
      if ($HTML != "") {
         $popuphtml = Join("\n",File(__DIR__ . "/" . $HTML));
      } else {
         $popuphtml = "";
      }

      # set popup variables
      $this->PopUpHTML = $popuphtml;
      $this->PopUpURL = $URL;
      $this->PopUpSize = "$x,$y";
      $this->PopTitle = $desc;
   }

#==================================================================================================

   // Redundant Methods
   // =================
   #  Link                          # Update the linked fields and their values
   #  Link Field                    # Link a field to an Intelligent popup window
   #  SetAction                     # Set action in form and all child tables

#==================================================================================================
}
# End Class

function createFormObject($form,$html) {
	if(!isset($GLOBALS[$form]) || !is_object($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form, "", $html);
	}
}
?>
