<?php

require_once(__DIR__ . '/class.financial.interface.php');
require_once(__DIR__ . '/class.great.plains.invoice.export.php');

/**
 * Implementation of the financial interface to the Xero accounting system.
 */
class GreatPlainsInterface extends FinancialInterface
{

    /**
     * Create an instance of the Great Plains Interface for the given invoicing unit.
     *
     * @param MySQLDB $lDB The connection to the database.
     * @param string $invoicingUnit The id of the invoicing unit.
     */
    public function __construct($lDB, $invoicingUnit)
    {
        parent::__construct($lDB, $invoicingUnit);
    }

    /**
     * Generates an array of invoices in the format required to be imported into Great Plains.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices contained within the given batch.
     */
    public function exportInvoices($batch)
    {
        $invoiceExport = new GreatPlainsInvoiceExport($this->lDB, $this->activeOptions, $batch);
        return $invoiceExport->export();
    }
}