<?php

require_once(__DIR__ . "/db.fn_folio.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.rv_reservation_item.php");
require_once(__DIR__ . "/db.rv_res_item_comp.php");
require_once(__DIR__ . "/db.rv_res_item_comp_tax.php");
require_once(__DIR__ . "/db.rv_res_item_comp_rate_grp.php");
require_once(__DIR__ . "/db.rv_special.php");
require_once(__DIR__ . "/class.rate.php");
require_once(__DIR__ . "/functions.reservation.itinerary.php");

require_once(__DIR__ . "/functions.specials.php");

class Itinerary {
	var $ReservationId;
	var $ReservationItemId;
	var $AccommTypeId;
	var $ArriveDate;
	var $DepartDate;
	var $RateGroups;
	var $RateTypeId;
	var $Optionals;
	var $Override;
	var $Split;
	var $BlockItinerary;
	var $BlockSeriesId;
	var $BlockSeriesSequence;
	var $AllocationItemExpiryDate;
	var $LinkId;
	var $Allocations;
	var $FolioId;
	var $CommPerc;
	var $CommYN;
	var $Specials;
	var $SpecialOverride;
	var $Edit; // if this itinerary is being edited
	var $CacheComponents;
	var $showItinErrorPopup = false;
	var $AppliedAllocation;
	var $DoNotDeleteAllocations = false;

	function __construct() {
		$this->ReservationItemId = false;
		$this->Edit = false;
		$this->ResetData();
	}

	function SetReservationItemId($sReservationItemId) {
		global $lDB;

		if(db_rv_reservation_item_exists($sReservationItemId)) {
			$this->ReservationItemId = $sReservationItemId;
			$itemInfo = $lDB->get("
				SELECT
					rv_reservation_item.rv_reservation_id,
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_adult_count,
					rv_reservation_item.rv_item_child_count,
					rv_reservation_item.rt_rate_type_id,
					rv_reservation_item.fn_folio_id,
					rv_reservation_item.rv_link_res_item_id,
					rv_reservation_item.rv_item_overide_level_ind,
					rv_reservation_item.rv_item_overide_amt,
					rv_reservation_item.rv_item_comm_perc,
					rv_reservation_item.rv_item_comm_yn,
					rv_reservation_item.bl_series_id,
					rv_reservation_item.bl_series_sequence_number,
					rv_reservation_item.bl_block_itinerary_id,
					rv_reservation_item.rv_alloc_expiry_date
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_item_ix = '$sReservationItemId'
			",1);

			$this->SetReservationId($itemInfo['rv_reservation_id']);
			$this->SetAccommTypeId($itemInfo['ac_accomm_type_id']);
			$this->SetArriveDate($itemInfo['rv_item_date_arrive']);
			$this->SetDepartDate($itemInfo['rv_item_date_depart']);
			$this->SetRateTypeId($itemInfo['rt_rate_type_id']);
			$this->SetFolioId($itemInfo['fn_folio_id']);
			$this->SetLinkId($itemInfo['rv_link_res_item_id']);
			$this->SetItemCommPerc($itemInfo['rv_item_comm_perc']);
			$this->SetItemCommYN($itemInfo['rv_item_comm_yn']);
			$this->SetItemSpecials(db_rv_special_get_specials_by_reservation($itemInfo['rv_reservation_id']));
			$this->SetItemSpecialOverride(db_rv_reservation_has_special_override($itemInfo['rv_reservation_id']));
			$this->SetBlockItinerary($itemInfo['bl_block_itinerary_id']);
			$this->SetBlockSeriesId($itemInfo['bl_series_id']);
			$this->SetBlockSeriesSequence($itemInfo['bl_series_sequence_number']);
			$this->SetAllocationItemExpiryDate($itemInfo['rv_alloc_expiry_date']);
			$this->Components = $lDB->get("
				SELECT
					rv_res_item_comp.rv_res_item_comp_ix AS rv_res_item_comp_id,
					rv_res_item_comp.rt_component_id,
					rv_res_item_comp.rv_item_comp_freq_ind,
					rv_res_item_comp.rv_item_comp_freq_factor,
					rv_res_item_comp.rv_item_comp_rate,
					rv_res_item_comp.rv_item_comp_rate_comm,
					rv_res_item_comp.rv_item_comp_comm_ind AS comm_ind,
					rv_res_item_comp.rv_item_comp_option_yn AS ac_acc_cmp_option_yn,
					rv_res_item_comp.rv_item_comp_separate_yn AS rt_component_separate_yn,
					rv_res_item_comp.rv_item_comp_var,
					rv_res_item_comp.rt_tax_ind,
					rv_res_item_comp.rt_tax_id,
					rv_res_item_comp.rv_item_comp_tax_perc AS rf_tax_rate_perc,
					rv_res_item_comp.rv_item_comp_amt_payable,
					rv_res_item_comp.rv_item_comp_amt_sp_discount
				FROM
					rv_res_item_comp
					INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
				WHERE
					rv_res_item_comp.rv_reservation_item_id = '$sReservationItemId'
			",2);
			
			$this->GetComponentRateGrpAmts();
			
			$optionals = $lDB->get("
				SELECT
					rv_res_item_comp.rt_component_id
				FROM
					rv_res_item_comp
					INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
				WHERE
					rv_res_item_comp.rv_reservation_item_id = '$sReservationItemId'
					AND rv_res_item_comp.rv_item_comp_option_yn = '1'
			",3);
			
			$this->SetOptionals($optionals);
			
			$rateGroups = $lDB->get("
				SELECT
					rv_res_item_rate_grp.rv_res_item_rate_grp_count AS qty,
					rv_res_item_rate_grp.rt_rate_group_id AS rt_rate_group_ix,
					rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt,
					rt_rate_group.rt_rate_group_sys_code
				FROM
					rv_res_item_rate_grp
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
				WHERE
					rv_res_item_rate_grp.rv_reservation_item_id = '$sReservationItemId'
			",2);		
			$this->SetRateGroups($rateGroups);

			$this->SetOverride(getOverrideArray($sReservationItemId));			
			$this->Edit = true;
			
		}
	}

	function SetReservationId($sReservationId) {
		$this->ReservationId = $sReservationId;
	}

	function SetAccommTypeId($sAccommTypeId) {
		$this->AccommTypeId = $sAccommTypeId;
	}

	function SetArriveDate($sArriveDate) {
		$this->ArriveDate = $sArriveDate;
	}

	function SetDepartDate($sDepartDate) {
		$this->DepartDate = $sDepartDate;
	}
	
	function SetRateGroups($sRateGroups){
		global $lDB;
		$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
		if (!isset($sRateGroups[0]['rt_rate_group_ix']) || $sRateGroups[0]['rt_rate_group_ix'] == ""){
			$sRateGroups[0]['rt_rate_group_ix'] = $unitCode;
			$sRateGroups[0]['name'] = "Units";
		}
		$this->RateGroups = $sRateGroups;

	}

	function SetRateTypeId($sRateTypeId) {
		$this->RateTypeId = $sRateTypeId;
	}

	function SetOptionals($sOptionals) {
		$this->Optionals = $sOptionals;
	}

	function SetOverride($aOverride) {
		if (empty($aOverride)){
			$this->Override = false;
		} elseif (is_array($aOverride)) {
			$hasValue = false;
			foreach($aOverride['amounts'] as $group){
				if (is_array($group)){
					foreach($group as $rateGroupAmt){
						if ($rateGroupAmt != ""){
							$hasValue = true;
						}
					}	
				} else {
					if ($group != ""){
						$hasValue = true;
					}				
				}
			}

			if ($hasValue){
				$this->Override = $aOverride;
			} else {
				$this->Override = false;
			}
		}
	}

	function SetSplit($sSplit) {
		$this->Split = $sSplit;
	}

	function SetBlockItinerary($sBlBlockItineraryId) {
		$this->BlockItinerary = $sBlBlockItineraryId;
	}

	function SetBlockSeriesId($sBlSeriesId) {
		$this->BlockSeriesId = $sBlSeriesId;
	}

	function SetBlockSeriesSequence($bl_series_sequence_number) {
		$this->BlockSeriesSequence = $bl_series_sequence_number;
	}

	function SetAllocationItemExpiryDate($rv_alloc_expiry_date) {
		$this->AllocationItemExpiryDate = $rv_alloc_expiry_date;
	}

	function SetLinkId($sLinkId) {
		if(db_rv_reservation_item_exists($sLinkId)) {
			$this->LinkId = $sLinkId;
		} else {
			$this->LinkId = false;
		}
	}

	function SetItemCommPerc($sCommPerc) {
		global $lDB;
		if($sCommPerc === false) {
			$sCommPerc = $lDB->get("
				SELECT rv_commission_perc FROM rv_reservation WHERE rv_reservation_ix = '" . $lDB->escape($this->ReservationId) . "'
		",4);
		}
		if(empty($sCommPerc)) {
			$sCommPerc = 0;
		}
		
		$this->CommPerc = $sCommPerc;
	}

	function SetItemCommYN($sCommYN) {
		$this->CommYN = $sCommYN;
	}

	function SetItemSpecials($sSpecials) {
		$this->Specials = $sSpecials;
	}

	function SetItemSpecialOverride($sSpecialOverride) {
		$this->SpecialOverride = $sSpecialOverride;
	}

	function SetAllocations($sAllocations) {
		if(!is_array($sAllocations)) {
			$sAllocations = explode(":",$sAllocations);
		}
		$this->Allocations = array();
		foreach($sAllocations as $allocation) {
			if(db_rv_reservation_exists($allocation)) {
				array_push($this->Allocations,$allocation);
			}
		}
	}

	function SetFolioId($sFolioId) {
		if(db_fn_folio_exists($sFolioId)) {
			$this->FolioId = $sFolioId;
		} else {
			$this->FolioId = false;
		}
	}

	function SetCacheComponents($sCacheComponents) {
		$this->CacheComponents = $sCacheComponents;
	}

	function SetDoNotDeleteAllocations($value = false) {
		$this->DoNotDeleteAllocations = $value;
	}

	function ResetData() {
		$this->ReservationId = false;
		$this->AccommTypeId = false;
		$this->ArriveDate = false;
		$this->DepartDate = false;
		$this->RateTypeId = false;
		$this->Optionals = array();
		$this->Override = false;
		$this->Split = false;
		$this->LinkId = false;
		$this->FolioId = false;
		$this->Allocations = array();
		$this->CacheComponents = array('occupancy');
		$this->SetReservationItemId($this->ReservationItemId);
	}

	function Create($cReservationId,$cAccommTypeId,$cArriveDate,$cDepartDate,$cRateGroups,$cRateTypeId,$cOptionals,$cOverride,$cLinkId=false,$cAllocations=false,$cSplit=false,$cBlBlockItineraryId=false,$cBlSeriesId=false,$cRetainExpiredBlockAllocations=false,$cCommPerc=false) {
		$this->SetReservationId($cReservationId);
		$this->SetAccommTypeId($cAccommTypeId);
		$this->SetArriveDate($cArriveDate);
		$this->SetDepartDate($cDepartDate);
		$this->SetRateGroups($cRateGroups);
		$this->SetRateTypeId($cRateTypeId);
		$this->SetOptionals($cOptionals);
		$this->SetOverride($cOverride);
		$this->SetLinkId($cLinkId);
		$this->SetItemCommPerc($cCommPerc);
		$this->SetItemSpecialOverride(db_rv_reservation_has_special_override($cReservationId));
		$this->SetAllocations($cAllocations);
		$this->SetSplit($cSplit);
		if (empty($this->BlockSeriesId)) {
			$this->SetBlockSeriesId($cBlSeriesId);
		}
		if ($this->LinkId !== false || !empty($this->Allocations)) {
			$this->SetCacheComponents(array('agentAllocation','occupancy'));
		}
		if (empty($this->BlockItinerary)) {
			// If not already set in function SetReservationItemId
			$this->SetBlockItinerary($cBlBlockItineraryId);
		}
		if($cRetainExpiredBlockAllocations) {
			$this->Edit = true;
		}
	}

	function AddToFolio() {
		global $lDB;

		if($this->FolioId === false || !db_fn_folio_exists_by_reservation($this->FolioId,$this->ReservationId)) {
			$this->FolioId = db_fn_folio_insert_reservation_item($this->ReservationItemId);
		}

		$lDB->put("UPDATE rv_reservation_item SET fn_folio_id = '".$this->FolioId."' WHERE rv_reservation_item_ix = '".$this->ReservationItemId."'");
		db_fn_folio_update_totals($this->FolioId);
	}

	function Save($newBooking) { /* FIXME: The allocations code needs to all be moved to this class */
		// New bookings (ie from the calendar / quick search)
		// will re-apply specials unless there is already an override
		global $lDB;

		$this->Specials = db_rv_special_get_specials_by_reservation($this->ReservationId);
		removeSpecialsFromRes($this->ReservationId); // When a reservation is edited, currently applied specials are removed

		$dates = makeDates($this->ArriveDate.":".$this->DepartDate,dateSubtract($this->DepartDate,$this->ArriveDate));
		$cacheClear = false;
		$currentReservationItemId = $this->ReservationItemId;
		
		if($this->ReservationItemId !== false) {
			$this->AppliedAllocation = $lDB->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_link_res_item_id = '" . $this->ReservationItemId . "'", 3);
			
			// Compare old item to new to see if cache needs clearing
			$itemInfo = $lDB->get("
				SELECT
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation.rf_reservation_status_id,
					rv_reservation.rv_provision_expiry_date
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix = '$this->ReservationItemId'
			",1);

			$this->SetFolioId($this->FolioId);
			$this->ReservationItemId = false;

			// Check if status is stock-holding
			$stockHolding = ($itemInfo['rf_reservation_status_id'] >= 15 && $itemInfo['rf_reservation_status_id'] <= 30);
			// Check if provisionals are expired
			if(
				$stockHolding
				&& $itemInfo['rf_reservation_status_id'] == 20 
				&& $itemInfo['rv_provision_expiry_date'] < date('Y-m-d')
			) {
				$stockHolding = false;
			}

			// Only clear cache if reservation is stock-holding
			if(Stock::CacheStock() && $stockHolding) {
				$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);
				$rv_item_accomm_count = false;
				foreach($this->RateGroups as $rateGroup) {
					if($rateGroup['rt_rate_group_ix'] == $unitCode) {
						$rv_item_accomm_count = $rateGroup['qty'];
					}
				}
				$unitChange = ($rv_item_accomm_count === false) || ($itemInfo['rv_item_accomm_count'] != $rv_item_accomm_count);
				$oldDates = makeDates($itemInfo['rv_item_date_arrive'].":".$itemInfo['rv_item_date_depart'],dateSubtract($itemInfo['rv_item_date_depart'],$itemInfo['rv_item_date_arrive']));
				$dateChange = $oldDates != $dates;
				$accommodationChange = $itemInfo['ac_accomm_type_id'] != $this->AccommTypeId;
				if ($accommodationChange) {
					$stock = new Stock($itemInfo['ac_accomm_type_id'],$itemInfo['rv_item_date_arrive'],$itemInfo['rv_item_date_depart']);
					$stock->ClearCache($this->CacheComponents, $oldDates);
					$cacheClear = $dates;
				} else if ($unitChange || $dateChange) {
					$cacheClear = array_values(array_unique(array_merge($oldDates, $dates)));
				}
			}
		} else {
			// Clear cache
			$cacheClear = $dates;
		}

		$items = array();
		$rf_reservation_status_id = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation.rv_reservation_ix = '".$this->ReservationId."'",4);
		if($rf_reservation_status_id != 15 && $rf_reservation_status_id != 97) {
			$rate = new Rate($this->AccommTypeId,$this->ArriveDate,$this->DepartDate,$this->RateGroups,$this->RateTypeId,$this->Optionals,$this->Override,$this->ReservationId,$this->CommPerc);

			$periods = $rate->ToPeriods();

			if ($currentReservationItemId !== false && $this->ReservationId !== false) {
				if (!empty($periods)) {
					calDeleteItem($currentReservationItemId, $this->ReservationId, false, false, true, false, $this->DoNotDeleteAllocations);
				} else {
					if ($this->showItinErrorPopup) {
						echo "<script>parent.openPopup('prompt.php?type=a&message=Something went wrong with the update, which would have resulted in the removal of the itinerary. No changes were made.');</script>";
					}
				}
			}

			foreach($periods as $period) {
				$override = $this->Override;
				// Fix per stay amount for period splits
				if(is_array($override) && array_key_exists("level",$override) && $override['level'] == 3) {
					$override['amounts']['stay'] = $period['rv_item_amt_payable'];
				}
				$this->ReservationItemId = db_rv_reservation_item_insert($this->ReservationId,$this->AccommTypeId,$period['rt_period_date_from'],$period['ac_prd_date_depart'],$this->RateGroups,$period['rt_rate_comm_yn'],$override,$this->Split,$this->RateTypeId,$this->LinkId,false,false,$this->BlockItinerary,$this->BlockSeriesId,$this->BlockSeriesSequence,$this->AllocationItemExpiryDate,$this->CommPerc);
				array_push($items,$this->ReservationItemId);
				foreach($period['components'] as $component) {
					$rv_res_item_comp_id = db_rv_res_item_comp_insert($this->ReservationItemId, $component['rt_component_id'], $component['rt_tax_ind'], $component['rt_tax_id'], $component['rt_comp_freq_ind'], $component['rt_comp_freq_factor'], $component['rv_item_comp_rate'], $component['rv_item_comp_rate_comm'], $component['comm_ind_db'], $component['ac_acc_cmp_option_yn'], $component['rt_component_separate_yn'], 0, $component['rf_tax_rate_perc'], $component['rv_item_comp_amt_gross'], $component['rv_item_comp_amt_nett'], $component['rv_item_comp_amt_comm'], $component['rv_item_comp_amt_comm_calc'], $component['rv_item_comp_amt_tax'], $component['rv_item_comp_amt_payable']);

					foreach($component['tax_detail'] as $tax_rate_id => $taxrecord){
						db_rv_res_item_comp_tax_insert($taxrecord['amount'], $taxrecord['perc'], $tax_rate_id, $rv_res_item_comp_id);
					}

					foreach($component['rate_groups'] as $rate_group_id => $rate_group){
						db_rv_res_item_comp_rate_grp_insert($rv_res_item_comp_id, $rate_group_id, $rate_group['rate'], $rate_group['rate_comm'], $rate_group['gross'], $rate_group['nett'], $rate_group['comm'], isset($rate_group['add_comm'])?$rate_group['add_comm']:"", $rate_group['tax'], $rate_group['payable'], 0);
					}				
				}
				$this->AddToFolio();
				if(sizeof($this->Allocations) > 0) {
					drawAllocations($this->ReservationItemId,$this->Allocations,$this->Edit,$this->BlockSeriesId, $this->AppliedAllocation);
				}
			}
		} else { // Create allocation itineraries as TBA for increased performance
			$this->ReservationItemId = db_rv_reservation_item_insert($this->ReservationId,$this->AccommTypeId,$this->ArriveDate,$this->DepartDate,$this->RateGroups,0,$this->Override,$this->Split,$this->RateTypeId,$this->LinkId,false,false,$this->BlockItinerary,$this->BlockSeriesId,$this->BlockSeriesSequence,$this->AllocationItemExpiryDate,$this->CommPerc);
			array_push($items,$this->ReservationItemId);
		}
		if(Stock::CacheStock() && $cacheClear !== false) {
			$stock = new Stock($this->AccommTypeId,$this->ArriveDate,$this->DepartDate);
			$stock->ClearCache($this->CacheComponents, $cacheClear);
		}
		recalcTotals($this->ReservationId,4);
		updateReservation($this->ReservationId);
		specialsAutoApply($this->ReservationId, $this->Specials, $this->SpecialOverride, $newBooking);
		return $items;
	}

	function UpdateTotals() {
		$rate = new Rate($this->AccommTypeId,$this->ArriveDate,$this->DepartDate,$this->RateGroups,$this->RateTypeId,$this->Optionals,$this->Override,$this->ReservationId,$this->CommPerc);

		$days = dateSubtract($this->DepartDate,$this->ArriveDate);
		
		$components = $rate->CalculateTotals($this->Components,$days,$this->CommYN);

		foreach($components as $key=>$component) {
			db_rv_res_item_comp_update($component['rv_res_item_comp_id'],$component['rv_item_comp_amt_gross'],$component['rv_item_comp_amt_nett'],$component['rv_item_comp_amt_comm'],$component['rv_item_comp_amt_comm_calc'],$component['rv_item_comp_amt_tax'],$component['rv_item_comp_amt_payable'],$component['rv_item_comp_var'],$component['rv_item_comp_amt_sp_discount']); 

			foreach($component['tax_detail'] as $tax_rate_id => $taxrecord){
				db_rv_res_item_comp_tax_update_amt($tax_rate_id, $component['rv_res_item_comp_id'], $taxrecord['amount'], $taxrecord['perc']);
			}

			if ($component['rate_groups']){
				foreach($component['rate_groups'] as $rate_group_id => $rate_group){
					if (isset($rate_group['rv_res_item_comp_rate_grp_ix']) && 
						isset($rate_group['gross']) && 
						isset($rate_group['nett']) && 
						isset($rate_group['comm']) && 
						isset($rate_group['add_comm']) && 
						isset($rate_group['tax']) && 
						isset($rate_group['payable']) && 
						isset($rate_group['rv_item_comp_rate_grp_amt_var'])
						) {
						db_rv_res_item_comp_rate_grp_update($rate_group['rv_res_item_comp_rate_grp_ix'], false, false, $rate_group['gross'], $rate_group['nett'], $rate_group['comm'], $rate_group['add_comm'], $rate_group['tax'], $rate_group['payable'], $rate_group['rv_item_comp_rate_grp_amt_var'], $rate_group['rv_item_comp_rate_grp_amt_sp_discount']);
					}
				}	
			}
			
		}
		
	}

	function RegenerateRate($keepTBA=false) {
		if($keepTBA && db_rv_reservation_item_is_tba($this->ReservationItemId)) {
			$isTBA = true;
		} else {
			$rate = new Rate($this->AccommTypeId,$this->ArriveDate,$this->DepartDate,$this->RateGroups,$this->RateTypeId,$this->Optionals,$this->Override,$this->ReservationId,$this->CommPerc);
			$isTBA = $rate->IsTBA();
		}
		if(!$isTBA) {
			$periods = $rate->ToPeriods();
			if(sizeof($periods) > 1) { return false; }
			$GLOBALS['lDB']->put("UPDATE rv_reservation_item SET rv_item_comm_yn = '".$periods[0]['rt_rate_comm_yn']."' WHERE rv_reservation_item.rv_reservation_item_ix = '".$this->ReservationItemId."'");
			db_rv_res_item_comp_delete_by_item($this->ReservationItemId);
			foreach($periods[0]['components'] as $component) {
				$rv_res_item_comp_id = db_rv_res_item_comp_insert($this->ReservationItemId, $component['rt_component_id'], $component['rt_tax_ind'], $component['rt_tax_id'], $component['rt_comp_freq_ind'], $component['rt_comp_freq_factor'], $component['rv_item_comp_rate'], $component['rv_item_comp_rate_comm'], $component['comm_ind_db'], $component['ac_acc_cmp_option_yn'], $component['rt_component_separate_yn'], 0, $component['rf_tax_rate_perc'], $component['rv_item_comp_amt_gross'], $component['rv_item_comp_amt_nett'], $component['rv_item_comp_amt_comm'], $component['rv_item_comp_amt_comm_calc'], $component['rv_item_comp_amt_tax'], $component['rv_item_comp_amt_payable']);
				foreach($component['tax_detail'] as $tax_rate_id => $taxrecord){
					db_rv_res_item_comp_tax_insert($taxrecord['amount'], $taxrecord['perc'], $tax_rate_id, $rv_res_item_comp_id);
				}

				foreach($component['rate_groups'] as $rate_group_id => $rate_group){
					db_rv_res_item_comp_rate_grp_insert($rv_res_item_comp_id, $rate_group_id, $rate_group['rate'], $rate_group['rate_comm'], $rate_group['gross'], $rate_group['nett'], $rate_group['comm'], isset($rate_group['add_comm'])?$rate_group['add_comm']:0, $rate_group['tax'], $rate_group['payable'], 0);
				}					
				
			}
		} else {
			db_rv_res_item_comp_delete_by_item($this->ReservationItemId);
		}

		$this->AddToFolio();
	}

	function ToArray() {
		return array(
			'rv_reservation_id'=>$this->ReservationId,
			'rv_reservation_item_id'=>$this->ReservationItemId,
			'ac_accomm_type_id'=>$this->AccommTypeId,
			'rv_item_date_arrive'=>$this->ArriveDate,
			'rv_item_date_depart'=>$this->DepartDate,
			'rt_rate_type_id'=>$this->RateTypeId,
			'components'=>$this->Components,
			'optionals'=>$this->Optionals,
			'override'=>$this->Override
		);
	}
	
	function GetComponentRateGrpAmts(){
		global $lDB;
	
		foreach ($this->Components as $key=> $component){
		
			$rateGrpAmts = $lDB->get("
				SELECT
					rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
					rv_res_item_comp_rate_grp.rt_rate_group_id,
					rv_res_item_comp_rate_grp.rv_res_item_comp_id,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_rate,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_rate_comm,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_add_comm,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_var,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount
				FROM
					rv_res_item_comp_rate_grp
				WHERE
					rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$component['rv_res_item_comp_id']."'
			",2);
			
			$this->Components[$key]['rate_groups'] = array();
			foreach($rateGrpAmts as $rateGrpAmt){
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['rv_res_item_comp_rate_grp_ix'] = $rateGrpAmt['rv_res_item_comp_rate_grp_ix'];
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['rate'] = $rateGrpAmt['rv_item_comp_rate_grp_rate'];
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['rate_comm'] = $rateGrpAmt['rv_item_comp_rate_grp_rate_comm'];
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['add_comm'] = $rateGrpAmt['rv_item_comp_rate_grp_amt_add_comm'];
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['rv_item_comp_rate_grp_amt_var'] = $rateGrpAmt['rv_item_comp_rate_grp_amt_var'];
				$this->Components[$key]['rate_groups'][$rateGrpAmt['rt_rate_group_id']]['rv_item_comp_rate_grp_amt_sp_discount'] = $rateGrpAmt['rv_item_comp_rate_grp_amt_sp_discount'];
			}
		}
	}
}


