<?php

define("LOCK_LEVEL_GLOBAL",1);
define("LOCK_LEVEL_PRINCIPAL",2);
define("LOCK_LEVEL_ENVIRONMENT",3);

class Lock {
	private $Name;
	private $Timeout;

	public function __construct($name, $level=LOCK_LEVEL_PRINCIPAL, $timeout=0) {
		global $principal_id, $dbcode;

		$name = trim($name);
		if(empty($name)) {
			throw new Exception("Invalid lock name");
		}

		if($level < 1 || $level > 3) {
			throw new Exception("Invalid lock level");
		}

		if(!is_numeric($timeout)) {
			throw new Exception("Invalid lock timeout");
		}

		$fullNameArray = array();
		if($level >= LOCK_LEVEL_PRINCIPAL) {
			$fullNameArray[] = $principal_id;
		} else {
			$fullNameArray[] = "ALL";
		}
		if($level >= LOCK_LEVEL_ENVIRONMENT) {
			$fullNameArray[] = $dbcode;
		} else {
			$fullNameArray[] = "ALL";
		}
		$fullNameArray[] = $name;
		$this->Name = join("_",$fullNameArray);

		$this->Timeout = $timeout;
	}

	public function Acquire() {
		return $this->Process("GET_LOCK");
	}

	public function Release() {
		return $this->Process("RELEASE_LOCK");
	}

	public function IsHeld() {
		return $this->Process("IS_USED_LOCK");
	}

	public function IsFree() {
		return !$this->IsHeld();
	}

	private function Process($function) {
		global $lDB;

		$params = "'$this->Name'";
		if($function == "GET_LOCK") {
			$params .= ",$this->Timeout";
		}

		if($lDB->get("SELECT $function($params)",4) != 0) {
			return true;
		} else {
			return false;
		}
	}
}
