<?php

$GLOBALS['debug'] = isset($GLOBALS['debug']) ? $GLOBALS['debug'] : 0;

require_once(__DIR__ . "/db.rf_database.php");
require_once(__DIR__ . "/db.tc_table.php");
require_once(__DIR__ . "/db.tc_property_trf.php");
require_once(__DIR__ . "/db.td_prop_deletions.php");
require_once(__DIR__ . "/db.tr_rule.php");
require_once(__DIR__ . "/db.tc_sequence.php");

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#                                                         #
#       MySQLDB Class - The MySQL Form Generator v2.5     #
#       Tobie van der Spuy - 2002                         #
#       tobie@eplay.co.za                                 #
#                                                         #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

Class MySQLDB {

	// MySQLDB Variables
	// =================
	var $name;
	var $login;
	var $passwd;
	var $host;
	var $conn;
	var $error;
	var $dbCode;
	var $isMaster;
	var $insert_id;
	var $insert_override;
	var $masterOverrideEnabled = false;
	var $transferFlagging = true;
	var $transaction = 0;

	// MySQLDB Methods
	// ===============
	function __construct($name,$login,$passwd,$host=localhost) {      # Constructor
		# set object variables
		$this->name = $name;
		$this->login = $login;
		$this->passwd = $passwd;
		$this->host = $host;

		$this->error = "";
		$this->conn = mysqli_connect($this->host,$this->login,$this->passwd);

		if(!$this->conn) {
			return;
		}

		mysqli_set_charset($this->conn, 'utf8mb4');

		# set this db as the active one
		if ($name != "") {
			$this->select();
		}
		$this->isMaster = "1";

		$this->insert_id = false;
		$this->insert_override = false;
	}

	function close() {
		return mysqli_close($this->conn);
	}


	function select () { # MySQL Select Database
		mysqli_select_db($this->conn,$this->name);
	}

	function timezone() {
		mysqli_real_query($this->conn, "SET time_zone = '".date("e")."'");
	}

	function group_concat_max_len($max) {
		mysqli_real_query($this->conn, "SET SESSION group_concat_max_len = $max");
	}

	function dbCode($dbCode) { // Set @dbCode MariaDB session variable for the triggers
		$this->dbCode = $dbCode;
		mysqli_real_query($this->conn, "
			CALL sp_set_environment('$dbCode');
		");
	}

	function transferFlagging($transferFlagging) {
		if ($this->transferFlagging === $transferFlagging) {
			return;
		}

		if ($transferFlagging === false) {
			mysqli_real_query($this->conn, "
				CALL sp_transfer_flagging(FALSE);
			");
			$this->transferFlagging = false;
		} else {
			mysqli_real_query($this->conn, "
				CALL sp_transfer_flagging(TRUE);
			");
			$this->transferFlagging = true;
		}
	}

	function masterOverride($masterOverride) {
		if ($this->isMaster == "1") {
			$isMaster = true;
		} else {
			$isMaster = false;
		}

		if($isMaster !== $this->masterOverrideEnabled) { // Only enable or disable overrides if the override has changed
			if($masterOverride === true) {
				mysqli_real_query($this->conn, "
					CALL sp_master_override(TRUE);
				");
				$this->masterOverrideEnabled = true;
			} else {
				mysqli_real_query($this->conn, "
					CALL sp_master_override(FALSE);
				");
				$this->masterOverrideEnabled = false;
			}
		}
	}

	function put ($string,$debug="0") { # MySQL Insert and Update
		$this->error = "";
		$error = "";
		if($debug != "7") {
			$debug = 0;
		} else {
			$debug = 2;
		}

		if (
			(isset($GLOBALS['dbcode']) && !isset($this->dbCode)) ||
			($this->dbCode && $GLOBALS['dbcode'] != $this->dbCode)
		) {
			$this->dbCode($GLOBALS['dbcode']); // Set MariaDB session variables for triggers
		}

		if ($this->isMaster == "1") {
			$this->masterOverride(true); // Enable master override
		} else {
			$this->masterOverride(false); // Disable master override
		}

		if ($GLOBALS['flagChngs'] == "0") {
			$this->transferFlagging(false); // Turn off transfer flagging. Modifying a transferred record won't cause it to be transferred
		} else {
			$this->transferFlagging(true); // Enable transfer flagging
		}


		// Step 1: Get the type of SQL statment and the table information from tc_table
		$iString = trim(strtolower($string));
		$iArray = preg_split("/\s+/",$iString);
		$type = $iArray[0];
		$mode = "full";

		switch($type) {
		case "insert":
			$table = $iArray[1] != "ignore" ? $iArray[2] : $iArray[3];
			break;
		case "delete":
			$table = $iArray[2];
			break;
		case "update":
			$table = $iArray[1];
			break;
		case "lock":
		case "unlock":
			$mode = "quick";
			break;
		default:
			if($debug > 0) {
				echo "Error: Unknown SQL type '$type'.<br />";
			}
			return false;
			break;
		}

		if($mode == "quick") {
			if ($GLOBALS['debug'] > "0" || $debug > "0") {
				echo $string."  (D:".$GLOBALS['debug'].",d:".$debug.")<br>";
			}
			mysqli_query($this->conn,$string);
			$error = mysqli_error($this->conn);
			if($error != "") {
				if ($GLOBALS['debug'] > "1" || $debug > "1") { echo "<b>".$error."</b> (D:".$GLOBALS['debug'].",d:".$debug.")<br>"; }
				$this->error = $error;
				return false;
			}
			return true;
		}

		mysqli_query($this->conn, $string);

		$error = mysqli_error($this->conn);
		if(!empty($error)) {
			error_log("===========================");
			error_log("TABLE: " . $table);
			error_log("TYPE: " . $type);
			error_log("ERROR: " . $error);
			error_log("<<<<<<<<<<<<<<<<<<<<<<<<<<<");
			error_log($string);
			error_log(">>>>>>>>>>>>>>>>>>>>>>>>>>>");

			mysqli_real_query($this->conn, "SET @last_insert_id = NULL");
			$this->insert_id = false;
			return false;
		}

		if($type == "insert") {
			// Returns zero if there was no previous query on the connection or if the query did not update an AUTO_INCREMENT value.
			$this->insert_id = mysqli_insert_id($this->conn);

			if(empty($this->insert_id)) {
				// Fetch last insert ID from triggers
				$this->insert_id = mysqli_fetch_assoc(mysqli_query($this->conn, 'SELECT @last_insert_id'))['@last_insert_id'];

				$error = mysqli_error($this->conn);
				if(!empty($error)) {
					error_log("Error fetching last insert ID: " . $error);
				}

				if(empty($this->insert_id)) {
					$this->insert_id = false;
				}
			}
			mysqli_real_query($this->conn, "SET @last_insert_id = NULL");
		}

		return true;
	}

	/**
	 * get() - Run an SQL select statement
	 * @param string $string - The SQL string to execute
	 * @param string $mode - How to return the result:
	 *			0: return result directly
	 *			1: return one row of result in multi-dimension array
	 *			2: return all rows in result in multi-dimension array
	 *			3: return all rows' first column in single dimension array
	 *			4: return the first row's first column value
	 *			5: return all rows in result in multi-dimension array
	 *			6: return all rows in result in multi-dimension with fields as keys only
	 * @param int $debug
	 * @return var
	 **/
	function get($string,$mode="1",$debug=0) { # MySQL Select
		$this->error = "";
		if($GLOBALS['debug'] > "0" || $debug == "1") {
			debug('$'."lDB->get(\"\n".$string."\n\",$mode,$debug);");
		}
		if($debug == "2") {
			error_log('$'."lDB->get(\"\n".$string."\n\",$mode,$debug);");
		}

		# get the values in
		$query = mysqli_query($this->conn,$string);
		$error = mysqli_error($this->conn);
		if($GLOBALS['debug'] > "1" || $debug == "1") { debug('$'."lDB error: $error"); }
		if($debug == "2") { error_log('$'."lDB error: $error"); }

		if($error == "") {
			# switch on get 'mode'
			switch ($mode) {
            case 0: # if mode 0, return result directly
				$result = $query;
				break;
			case 1: # if mode 1, return one row of result in multi-dimension array
				if(mysqli_num_rows($query) != "0") {
					$result = mysqli_fetch_array($query);
				} else {
					$result = false;
				}
				break;
			case 2: # if mode 2, return all rows in result in multi-dimension array
				$result = array();
				while($row = mysqli_fetch_array($query)) {
					array_push($result,$row);
				}
				break;
			case 3: # if mode 3, return all rows' first column in single dimension array
				$result = array();
				while($row = mysqli_fetch_array($query)) {
					array_push($result,$row[0]);
				}
				break;
			case 4: # if mode 4, return the first row's first column value
				if(mysqli_num_rows($query) != "0") {
					$row = mysqli_fetch_array($query);
					$result = $row[0];
				} else {
					$result = false;
				}
				break;
			case 5: # if mode 2, return all rows in result in multi-dimension array
				$result = array();
				while($row = mysqli_fetch_row($query)) {
					array_push($result,$row);
				}
				break;
			case 6: # if mode 6, return all rows in result in multi-dimension with fields as keys only
				$result = array();
				while($row = mysqli_fetch_assoc($query)) {
					array_push($result,$row);
				}
				break;
			}
			if($mode != 0) {
				mysqli_free_result($query);
			}
			return $result;
		} else {
			error_log("MYSQL ERROR [#get]: ".$error. " WHEN EXECUTING: '$string'");
			$this->error = $error;
			return false;
		}
	}

	function count($table,$field,$value,$check,$where="where",$debug=0) { # MySQL Count
		$this->error = "";
		# compile sql query from arguments
		$qry = "select count(*) from ";
		$qry .= $table;
		if ($where == "where") {
			$qry .= " ".$where." ";
			$qry .= $field;
			$qry .= " = '";
			$qry .= $value;
			$qry .= "'";
		} else {
			$qry .= $where;
		}

		# execute query
		$tmp = $this->get($qry,"1");
		if ($debug == "1"){
			echo $qry."<br>\n".$tmp[0]." vs ".$check."<br>\n".mysqli_error($this->conn)."<br>\n";
		}

		# return true or false on check
		if ($tmp[0] == $check) {
			return True;
		} else {
			return False;
		}
	}

	function escape($value) {
		return mysqli_real_escape_string($this->conn,$value);
	}

	function getTransaction() {
		return $this->transaction;
	}

	function begin() {
		mysqli_query($this->conn,"START TRANSACTION;");
		$this->transaction = ($this->transaction < 1)?1:$this->transaction + 1;
	}

	function commit() {
		mysqli_query($this->conn,"COMMIT;");
		$this->transaction = $this->transaction - 1;
	}

	function rollback() {
		mysqli_query($this->conn,"ROLLBACK;");
		$this->transaction = $this->transaction - 1;
	}

	function escapeLike($value,$escapeWildcards=true) {
		$value = $this->escape($value);
		$value = $this->escape($value);
		if($escapeWildcards) {
			$value = addcslashes($value,'%_');
		}
		return $value;
	}

	function like($value,$wildcard='*',$escapeWildcards=true) {
		return str_replace($wildcard,'%',$this->escapeLike($value,$escapeWildcards));
	}

}
