<?php

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#                                                         #
#       MySQLField Class - The MySQL Form Generator v3    #
#       Tobie van der Spuy - 2001                         #
#       tobie@eplay.co.za                                 #
#                                                         #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

class MySQLField {

// Field Variables
#==================================================================================================
   var $db;                                        # Database Object

   var $Name;                                      # Field Name
   var $Varname;                                   # Variable used to get value from
   var $Value;                                     # Field Value (contents)
   var $Class;                                     # Which Class (used when submitting and building)

   var $IsKey;                                     # Is this field a Key or Index in the DB?
   var $IsDisabled;                                # Is this field enabled or disabled?
   var $IsHidden;                                  # Is this field hidden?
   var $IsReadonly;              # Is this field readonly?
   var $IsDate_Time;                               # Display as a date or time field?
   var $AlwaysOn;                                  # Always show this field in 'edit mode'?
   var $ShowInput;                                 # Forces this object to display itself as a standard input field

   var $Get;                                       # Update this field's value from user input?
   var $Changed;                                   # Has this field's value actually changed?
   var $Events;                                    # Array of JavaScript Events for this field
   var $onChange;                                  # Array of JavaScript Events for this field
   var $MoreHTML;                                  # Optional: Additional HTML/JavaScript to echo with field
   var $Debug;                                     # Debug Information: Echo when Global Debug mode is on

   var $URL;                                       # URL used when field acts as a link
   var $Select;                                    # Array containing values required to generate a combobox
   var $LinkSQL;                                   # SQL query used to select human readable value for field

   var $Length;                                    # Column Length from DB
   var $Size;                                      # Display Length for input fields
   var $Width;
   var $Default;                                   # Default Value for Column from DB
   var $Null;                                      # Null Value for Column from DB
   var $Extra;                                     # Additional Column info from DB (auto increment)
   var $ColumnType;                                # The column type information derived from mysql
   var $TabIndex;                                  # Field's Tab index
   var $StyleType;                                 # Fields CSS Class

   var $Rows;                                      # Amount of rows for textbox displays
   var $Cols;                                      # Amount of columns for textbox displays

   var $PopUpSQL;                                  # SQL Query used to populate linked display field
   var $PopUpJob;                                  # Job ID and record to call when popping up new window
   var $PopUpURL;                                  # Job ID and record that popup passes back to host

   var $ParamList;      # Optional: Used in the new templating engine to store parameters
   var $ValueList;      # Optional: Used in the new templating engine to store values for the paramaters
   var $AttribList;     # Optional: Used in the new templating engine to store attributes (like 'checked' or 'disabled')


// Form Methods
#==================================================================================================
   function __construct($name,$varname,$value,$class,$key=0,$dbcode=0) {   # Constructor

      if ($key != "0") {
         #echo "I am $name and I am a key!<br>";
         }
      $this->Name = $name;
      $this->Varname = $varname;
      $this->Value = $value;
      $this->Class = $class;

      $this->IsKey = $key;
      $this->IsDBCode = $dbcode;
      //$this->IsDisabled = $disabled;
      //$this->IsHidden = $hidden;
      $this->IsDisabled = "";
      $this->IsHidden = "";

      $this->Get = "1";
      $this->Changed = "0";
      //$this->Events = $events;
      $this->Events = "";
      $this->MoreHTML = "";
      $this->Debug = "";

      $this->URL = "";
      $this->Select = array();

      $this->Length = "";
      $this->Size = "";
      $this->Default = "";
      $this->Null = "";
      $this->Extra = "";

      $this->Rows = "";
      $this->Cols = "";

      $this->PopUpSQL = "";
      $this->PopUpJob = "";
      $this->PopUpURL = "";

      $this->ParamList = array();
      $this->ValueList = array();
      $this->AttribList = array();

      $debug = "...creating $name, has value:".$value."<br>";
      #echo $debug;

      }


#==================================================================================================
   function Expand (&$db,$length,$default,$null,$extra,$column) {     # Additional values added for fields generated from DB

      $this->db = $db;

      $this->Length = $length;
      $this->Default = $default;
      $this->Null = $null;
      $this->Extra = $extra;
      $this->ColumnType = $column;
      }


#==================================================================================================
   function Select ($array) {     # Set field class to combobox and update select array with $array

      $this->Select = $array;
      if ($this->Class != "12")
      {
         $this->Class = "3";
      }
      }


#==================================================================================================
   function SetValue ($value) {     # Set the value for this field manually and don't update with user input

      $this->Value = $value;
      $this->Get = "0";
      $this->Changed = "1";
      }


#==================================================================================================
function GetValue() {     # Update field value with user input
   if ($this->Get == "1") {
      $var = $this->Varname;
      $class = $this->Class;
      $temp = $_POST;
      if(array_key_exists($var,$temp)) {
         if($this->Value !== $temp[$var]) {
            $this->Changed = "1";
         }
         if (strpos($this->ColumnType,"int") !== false) {
            $temp[$var] = str_replace(" ","",$temp[$var]);
            $temp[$var] = str_replace(",","",$temp[$var]);
         }
         // htmlspecialchars makes life extremely hard if enabled as it is an unknown and
         // is liable to change as php changes - plus it doesn't work properly.
         // $this->Value = htmlspecialchars($temp[$var],ENT_QUOTES);
         $this->Value = $temp[$var];
         if($class == 9) {
            if($this->Value == "on"){$this->Value = 1;}
         }
         $debug = "...getting value from var!<br>";
         #echo $debug;
      } else {
         $this->Value = "";
      }
   }
}


#==================================================================================================
   function UpdateVar ($value) {     # Update the user input variable with new value

      $_POST[$this->Varname] = $value;
      $this->Value = $value;
      }


#==================================================================================================
   function Validate () {     # Validate the user input according to field class

      # not exactly functional at the moment ;D
      $this->Validate = "0";
      return True;
      }


#==================================================================================================
   function Show ($action="") {      # Create output HTML according to field class

      # pass onto the make function if argument exists, otherwise show only values
      if ($this->AlwaysOn == "1"){
         $action = "3";
      }
      if ($action != "") {
         return $this->Make($action);
         }
      else {
         // $value = stripslashes($this->Value);
      	$value = $this->Value;

         # generate output depending on field class
         switch ($this->Class) {

            case (3):   # ComboBox

               # use the human readable value
               if (strpos($this->Select[$value],":|:") !== false){
                  $temp = explode(":|:",$this->Select[$value]);
                  $value = $temp[1];
               }else{
                  $value = $this->Select[$value];
               }
               break;

            case (4):   # IntelliSearch

               # use the value from the linked table
               $db = $this->db;
               $temp = $db->get($this->LinkSQL,"1");
               $value = $temp[0];
               break;

            default:

               # do nothing
               break;
            }

         # if this field should be a link populate the url and return it
         if ($this->URL != "") {
            $value = str_replace("!v!",$value,$this->URL);
            }

         return $value;
         }
      }


#==================================================================================================
   function Make ($action) {      # Create output HTML according to field class

      # prepare the data we need
      $varname = $this->Varname;
      // $value = stripslashes($this->Value);
      $value = $this->Value;
      $length = $this->Length;

     $tabindex = "";
      if ($this->TabIndex != "") {
         $tabindex = "tabindex=\"".$this->TabIndex."\"";
      }


      # disable fields if building for view mode
     $disable = "";
      if ($action == "1" || $this->IsDisabled == "1") { $disable = " disabled"; }

      # limit maximum field length
      if ($this->Size != "") {
         $maxsize = $this->Size;
         }
      elseif ($this->IsDate_Time == "1") {
         $maxsize = "6";
         }
      else {
         if ($length >= "25") { $maxsize = "25"; }
         else { $maxsize = $length; }
         }
       $onChange = "";
         if ($this->onChange != "") {
            $onChange = "onchange=\"".str_replace("\t"," ",str_replace("\r\n"," ",str_replace("\r"," ",str_replace("\n"," ",$this->onChange))))."\"";
//     echo "<PRE>$onChange</PRE>";
            }

     $width = "";
     $readonly = "";
      if ($this->IsHidden != "1") {

         if ($this->StyleType == "") {
            $this->StyleType = "forminput";
            }
         $stylet = $this->StyleType;

         if ($this->Width != "") {
            $width = " style=\"width: ".$this->Width."px\"";
         }
    if ($this->IsReadonly != "") {
       $readonly = " readonly style=\"color: #848284\" ";
    }
         # generate output depending on field class
         switch ($this->Class) {

            case (2):    # password field

               if ($this->IsHidden != "1") {
                  # generate standard output but for password field
                  $output = "<input type=\"password\" name=\"$varname\" value=\"".t_encodeHTMLField($value)."\" size=\"$maxsize\"";
                  $output .= "maxlength=\"$length\" class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                  }

               break;

            case (3):   # ComboBox

               $tempoption = "";
               if ($this->IsHidden != "1") {
                  # integer values stored in db
                  $varname = $this->Varname;

                  $start = "<select id=\"$varname\" name=\"$varname\" class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                  $output = $start;

                  # split the recieved array up into ids and text
                  $nmax = sizeof($this->Select);
                  for($n=0;$n<$nmax;$n++) {
                     $array = $this->Select[$n];
					 if(trim($array) != "") {
	                     if (strpos($array,":|:") !== false) {
    	                    $temp = explode(":|:",$array);
        	                }
            	         else {
                	        $temp = explode("-",$array);
                    	    }
	                     $id = $temp[0];
    	                 $displayval = $temp[1];
					 } else {
						 $id = "";
						 $displayval = "";
					 }

                     # limit the dropdown box at this length
					 if($this->Size > 0) {
	                     $limit = "21";
    	                 if ($this->Size > $limit) {
        	                $limit = $this->Size;
            	         }
                     	if (trim($id) != "") {
	                        if (strlen($displayval) >= $limit) { $displayval = substr($displayval,"0",$limit-2).".."; }
    	                 }
					 }

					 $displayval = t_encodeHTMLField($displayval);

                     if ($this->ShowInput == "1" && ($action == "1" || $this->IsDisabled == "1") && $id == $this->Value)
                     {
                        $output = "<input type=\"text\" id=\"$varname\" name=\"$varname\" value=\"$displayval\" size=\"$maxsize\"";
                        $output .= " maxlength=\"$length\" class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                        return $output;
                     }
                     # automatically select the previous value
                     if ($id == $this->Value) { $selected = " selected"; }
                     else { $selected = ""; }
                     $outvalue1 = "<option value=\"$id\"$selected>$displayval\n";

                     if ($tempoption == "" || $id == "0" || $id == "") {
                        $tempoption = $outvalue1;
                     }

                     if ($action == "1" || $this->IsDisabled == "1") {
                        #echo "Disabled!<br>";
                        if ($id == $this->Value || $n == "0") {
                           $output .= $outvalue1;
                        }
                     }else{
                        $output .= $outvalue1;
                     }
                  }

                  if ($output == $start) {
                     $output .= $tempoption;
                     }

                $spacerz = "";
                  for ($w=0;$w<$this->Size;$w++) {
                     $spacerz .= "&nbsp;";
                     }
                  if ($spacerz != "" && $action == "1") {
                     $output .= "<option>$spacerz\n";
                     }
                  $output .= "</select>\n";
                  }

               break;

            case (5):    # Textbox

               # generate the output for a standard form field
               if ($this->IsHidden != "1") {
                  $txtDisable = "";
                  if (trim($disable) == "disabled") {
                     $txtDisable = " readonly style=\"color: #848284\"";
                  }
                  $output = "<textarea id=\"".$varname."\" name=\"".$varname."\" class=\"$stylet\" rows=\"".$this->Rows."\" cols=\"".$this->Cols."\"$width $txtDisable $tabindex $onChange>";
                  $output .= t_encodeHTMLField($value)."";
                  $output .= "</textarea>";
                  }
               break;

            case (8):    # Just the value

               # generate the output for a standard form field
               if ($this->IsHidden != "1") {
                  $output = $value."\n";
                  }
               break;

            case (9):    # checkbox

               if ($this->IsHidden != "1") {
                  # generate the output for a standard checkbox
                  # Check if the value is 1 (checked) or 0 (unchecked) and set the correct output
                  if($value) {
                     $checked = " checked";
                  }else{
                     $checked = " ";
                  }
                  $output = "<input type=\"checkbox\" id=\"$varname\" name=\"".t_encodeHTMLField($varname)."\" $checked ";
                  $output .= " class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                  }

               break;

            case (10):    # radio button
				if ($this->IsHidden != "1") {
					# generate the output for a standard radio button


					# split the recieved array up into ids and text
					$nmax = sizeof($this->Select);
					$output = "";
					for($n=0;$n<$nmax;$n++) {
					$array = $this->Select[$n];
					if(trim($array) != "") {
						if (strpos($array,":|:") !== false) {
							$temp = explode(":|:",$array);
						}
						else {
							$temp = explode("-",$array);
						}
						$id = $temp[0];
						$displayval = $temp[1];
					} else {
						$id = "";
						$displayval = "";
					}

					if ($id == $this->Value) { 
						$checked = " checked"; 
					} else { 
						$checked = ""; 
					}

						$output .= "<input type=\"radio\" name=\"$varname\" id=\"".$varname."_".$n."\" value=\"$id\"";
						$output .= " class=\"$stylet\"$width $disable $tabindex $onChange $checked> ".t_encodeHTMLField($displayval)." \n";
					}
				  
                }
				  
				  

               break;

            case (11):    # textarea

               if ($this->IsHidden != "1") {
                  # generate the output for a standard textarea
                  $output = "<textarea id=\"$varname\" name=\"$varname\" rows=".$this->Rows." cols=".$this->Cols." ";
                  $output .= " $width $disable $tabindex $onChange>".t_encodeHTMLField($value)."</textarea>\n";
                  }

               break;

            case (12):   # ComboBox

               $tempoption = "";
               if ($this->IsHidden != "1") {
                  # integer values stored in db
                  $varname = $this->Varname;

                  $start = "<select multiple id=\"$varname\" name=\"$varname\" class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                  $output = $start;

                  # split the recieved array up into ids and text
                  $nmax = sizeof($this->Select);
                  for($n=0;$n<$nmax;$n++) {
                     $array = $this->Select[$n];
                     if (strpos($array,":|:")) {
                        $temp = explode(":|:",$array);
                        }
                     else {
                        $temp = explode("-",$array);
                        }
                     $id = $temp[0];
                     $displayval = $temp[1];

                     # limit the dropdown box at this length
                     $limit = "21";
                     if ($this->Size > $limit) {
                        $limit = $this->Size;
                     }
                     if (trim($id) != "") {
                        if (strlen($displayval) >= $limit) { $displayval = substr($displayval,"0",$limit-2).".."; }
                     }

                     if ($this->ShowInput == "1" && ($action == "1" || $this->IsDisabled == "1") && (in_array($id,$this->Value)))
                     {
                        $output = "<input type=\"text\" id=\"$varname\" name=\"$varname\" value=\"".t_encodeHTMLField($displayval)."\" size=\"$maxsize\"";
                        $output .= " maxlength=\"$length\" class=\"$stylet\"$width $disable $tabindex $onChange>\n";
                        return $output;
                     }
                     # automatically select the previous value
                     if (in_array($id,$this->Value)) { $selected = " selected"; }
                     else { $selected = ""; }
                     $outvalue1 = "<option value=\"$id\"$selected>".t_encodeHTMLField($displayval)."\n";

                     if ($tempoption == "" || $id == "0" || $id == "") {
                        $tempoption = $outvalue1;
                     }

                     if ($action == "1" || $this->IsDisabled == "1") {
                        #echo "Disabled!<br>";
                        if ($id == $this->Value || $n == "0") {
                           $output .= $outvalue1;
                        }
                     }else{
                        $output .= $outvalue1;
                     }
                  }

                  if ($output == $start) {
                     $output .= $tempoption;
                     }

                $spacerz = "";
                  for ($w=0;$w<$this->Size;$w++) {
                     $spacerz .= "&nbsp;";
                     }
                  if ($spacerz != "" && $action == "1") {
                     $output .= "<option>$spacerz\n";
                     }
                  $output .= "</select>\n";
                  }

               break;

            default:    # default input box

               if ($this->IsHidden != "1") {
                  # generate the output for a standard form field
                  $output = "<input type=\"text\" id=\"$varname\" name=\"$varname\" value=\"".t_encodeHTMLField($value)."\" size=\"$maxsize\"";
                  $output .= " maxlength=\"$length\" class=\"$stylet\"$width $disable $readonly $tabindex $onChange>\n";
                  }

               break;
            }
         }
      else {
         $output = "<input type=\"hidden\" id=\"$varname\" name=\"$varname\" value=\"".t_encodeHTMLField($value)."\" $onChange>";
         }

      if ($this->Debug >= "2") { $output .= "(".$this->Name.")"; }
      return $output;

      }

   function result($tag,$content,$end)
   {
      $temp = explode(" ",$tag);
      $tagName = $temp[0];

      array_push($this->ParamList,"name");
      array_push($this->ValueList,$this->Varname);

      if ($this->TabIndex != "")
      {
         array_push($this->ParamList,"tabindex");
         array_push($this->ValueList,$this->TabIndex);
      }

      // Hide the object
      if ($this->IsHidden == "1")
      {
         array_push($this->ParamList,"type");
         array_push($this->ValueList,"hidden");
      }

      // CSS class
      if ($this->StyleType != "")
      {
         array_push($this->ParamList,"class");
         array_push($this->ValueList,$this->StyleType);
      }

      // Javascript onchange event
      if ($this->onChange != "")
      {
         array_push($this->ParamList,"onchange");
         array_push($this->ValueList,$this->onChange);
      }

      // Disable the object
      if ($this->IsDisabled == "1")
      {
         array_push($this->AttribList,"disabled");
      }
      else
      {
         $tag = str_replace(" disabled","",$tag);
      }

      // Set the object width (add to style tag if already exist)
      if ($this->Width != "") {
         $check = array_keys($this->ParamList);
         if (in_array("style",$this->ParamList))
         {
            $imax = sizeof($this->ParamList);
            $index = 0;
            for($i=0;$i<sizeof($imax);$i++)
            {
               if ($this->ParamList[$i] == "style")
               {
                  $index = $i;
                  break;
               }
            }
            $this->ValueList[$index] .= ";width: ".$this->Width."px";
         }
         else
         {
            array_push($this->ParamList,"style");
            array_push($this->ValueList,"width: ".$this->Width."px");
         }
      }

	  $this->Value = t_encodeHTMLField($this->Value);

      switch ($this->Class)
      {
         case (3) :  // Select
            $optionsList = "";
            $showValue = "";
            $nmax = sizeof($this->Select);
            for($n=0;$n<$nmax;$n++) {
               $array = $this->Select[$n];
               if (strpos($array,":|:")) {
                  $temp = explode(":|:",$array);
                  }
               else {
                  $temp = explode("-",$array);
                  }
               $id = $temp[0];
               $displayval = $temp[1];
               if ($id == $this->Value)
               {
                  $showValue = $displayval;
               }
               if ($this->ShowInput != "1" || ($this->AlwaysOn == "1" || $this->IsDisabled != "1"))
               {
                  $selected = "";
                  if ($id == $this->Value)
                  {
                     $selected = " selected";
                  }
                  $optionsList .= "<option value=\"".$id."\"".$selected.">".$displayval."\n";
               }
            }

            if ($this->ShowInput == "1" && ($this->AlwaysOn != "1" && $this->IsDisabled == "1"))
            {
               array_push($this->ParamList,"value");
               array_push($this->ValueList,$showValue);

               $tag = str_replace("<select","<input",$tag);
               $content = "";
               $end = "";
            }
            else
            {
               if ($this->AlwaysOn != "1" && $this->IsDisabled == "1")
               {
                  $content = "<option value=\"".$this->Value."\">".$showValue."\n";
               }
               else
               {
                  $content = $optionsList;
               }
            }
         break;

         case (5) :  // Textarea
            array_push($this->ParamList,"rows");
            array_push($this->ValueList,$this->Rows);

            array_push($this->ParamList,"cols");
            array_push($this->ValueList,$this->Cols);

            $content = $this->Value;
         break;

         case (8) : // Just the value
            $tag = "";
            $content = $this->Value;
            $end = "";
         break;

         case (9) :  // Checkbox
            if ($this->Value == "1")
            {
               array_push($this->AttribList,"checked");
            }
            else
            {
               $tag = str_replace(" checked","",$tag);
            }
         break;

         default :
            if ($this->Size != "")
            {
               array_push($this->ParamList,"size");
               array_push($this->ValueList,$this->Size);
            }

            array_push($this->ParamList,"value");
            array_push($this->ValueList,$this->Value);
         break;
      }

      // Add parameters (name=value)
      $imax = sizeof($this->ParamList);
      for($i=0;$i<$imax;$i++)
      {
         $param = $this->ParamList[$i];
         $value = $this->ValueList[$i];
         if (strpos($tag," ".$param) !== false)
         {
            $tag = str_replace(">","",$tag);
             $tagData = preg_split("/\s+/",$tag);

            $jmax = sizeof($tagData);
            for($j=0;$j<$jmax;$j++)
            {
               if (substr($tagData[$j],0,strlen($param)) == $param)
               {
                  $tagData[$j] = "";
                  if ($tagData[$j+1][0] == "=")
                  {
                     $tagData[$j+1] = "";
                  }
               }
            }
            $tag = join(" ",$tagData).">";
         }

         $tag = str_replace($tagName,$tagName." ".$param."=\"".$value."\"",$tag);
      }

      $imax = sizeof($this->AttribList);
      for($i=0;$i<$imax;$i++)
      {
         $attrib = $this->AttribList[$i];
         $tag = str_replace($tagName,$tagName." ".$attrib,$tag);
      }

      return $tag.$content.$end;
   }


}  # End Class
#==================================================================================================
