<?php

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #
#                                                         #
#       MySQLTable Class - The MySQL Form Generator v3    #
#       Tobie van der Spuy - 2002                         #
#       tobie@eplay.co.za                                 #
#                                                         #
# # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

Class MySQLTable {

// Table Variables
#==================================================================================================
   var $db;                                     # Database Connection
   var $Action;                                 # Add or Edit or Delete
   var $Table;                                  # Name of the Table in DB
   var $IdentFields;                            # Table columns used to identify rows to the user
   var $FieldList;                              # List of fields the table should "open"
   var $WhereSQL;                               # Where statement (primary key)
   var $AndSQL;                                 # And statement (sometimes secondary key)
   var $OrderSQL;                               # Order by clause
   var $Keys;                                   # List of Primary and Secondary Key in table
   var $Sql;                                    # Final composite statement (echo on debug)
   var $TableName;                              # Actual name of the table object
   var $FormName;                               # Text to use when naming fields
   var $Raw;                                    # Temp area to store Show Fields query result


// Table Methods
#==================================================================================================
   function __construct($formname,&$db,$tablename,$table,$uselist=array(),$wheresql="",$andsql="",$ordersql="",$identfields=array()) {      # Constructor

	  # check inputs
	  checkarray($uselist);
	  checkarray($identfields);

	  # setup object variables
	  $this->db = $db;
	  $this->Table = $table;
	  $this->Use = $uselist;
	  $this->FieldList = array();

	  $this->WhereSQL = $wheresql;
	  $this->AndSQL = $andsql;
	  $this->OrderSQL = $ordersql;
	  $this->IdentFields = $identfields;

	  $this->Keys = array();
	  $this->FormName = $formname;
	  $this->TableName = $tablename;
	  $this->Raw = "";
	  }


#==================================================================================================
	function Get ($paction) {             # Build a list of all the fields in the Table

		# setup some values
		$db = $this->db;
		$table = $this->Table;
		if (gettype($this->Raw) != "array") {
			$sql0 = "show fields from $table";
			$raw = $GLOBALS['lDB']->get($sql0,"2");
			$this->Raw = $raw;
		} else {
			$raw = $this->Raw;
		}

		$fieldList = $GLOBALS['lDB']->get("SELECT * FROM $table LIMIT 1",0);

		# if updating or displaying get the values
		$andsql = "";
		if ($paction != "2") {
			$sql = "select * from $table";
			if(array_key_exists($table,$GLOBALS)) {
				$wheresql = $GLOBALS[$table]->wheresql;
			} else {
				$wheresql = "";
			}

			if ($wheresql != "" && (strpos($wheresql,$keyfield) === false)) {
				$wheresql = " where".$wheresql;
				if ($andsql != "" && (strpos($andsql,$keyfield) === false)) {
					$andsql = " and".$andsql;
				}
			} else {
				if ($andsql != "" && (strpos($andsql,$keyfield) === false)) {
					$andsql = " where".$andsql;
				}
			}

			$this->ListSQL = $sql.$wheresql.$andsql;
			$sql = "select * from ".$table." where ".$this->WhereSQL;
			if ((strpos($sql,"''") === false)) {
				$raw2 = $GLOBALS['lDB']->get($sql,"1");
			}
		}

		# for each row (table column) returned create a field object
		for($i=0;$i<sizeof($raw);$i++) {
			$row = $raw[$i];
			$dbcodefield = 0;
			if(strpos($row[0],"_db") && (strpos($row[0],"_id") === false)) {
				array_push($this->Use,$row[0]);
				$dbcodefield = 1;
			}
			if (in_array($row[0],$this->Use)) {
				$field = $row[0];

				# get the column length from the db table
				$fieldInfo = mysqli_fetch_field_direct($fieldList,$i);
				$len = $fieldInfo->length;

				# if updating or displaying pass values
				if(isset($raw2)) {
					$value = $raw2[$field];
				} else {
					$value = "";
				}

				$fieldname = $this->FormName."_".$table."_".$field;
				array_push($this->FieldList,$fieldname);

				# determine field class
				$TV_row_1 = strtolower($row[1]);
				if (
					(strpos($TV_row_1,"int") !== false)
					|| (strpos($TV_row_1,strtolower("double")) !== false)
					|| (strpos($TV_row_1,"float") !== false)
					|| (strpos($TV_row_1,"decimal") !== false)
					|| (strpos($TV_row_1,"date") !== false)
					|| (strpos($TV_row_1,"time") !== false)
					|| (strpos($TV_row_1,"year") !== false)
					|| (strpos($TV_row_1,"char") !== false)
				) {
					$class = "0";
				} elseif (
					(strpos($TV_row_1,"enum") !== false)
					|| (strpos($TV_row_1,"set") !== false)
				) {
				   $class = "3";
				} elseif (strpos($TV_row_1,"text") !== false) {
					$class = "5";
				} else {
					$class = "0";
				}

				$iskey = "0";
				if ($row[3] == "PRI") {
					array_push($this->Keys,$fieldname);
					$iskey = "1";
				}

				# instantiate the new field object and then expand it with the additional values from the db
				$GLOBALS[$fieldname] = new MySQLField($fieldname,$row[0],$value,$class,$iskey,$dbcodefield);
				$GLOBALS[$fieldname]->Expand($db,$len,$row[4],$row[2],$row[5],$row[1]);

				if ((strpos($TV_row_1,"date") !== false) || (strpos($TV_row_1,"time") !== false)) {
					$GLOBALS[$fieldname]->IsDate_Time = "1";
				}

				# pass further data that may be required
				switch ($class) {
				case (3):
					# add code here to auto generate array for combo values
					break;
				}
			}
		}
	}


#==================================================================================================
   function Refresh ($record,$action) {          # Deletes field from table list

	  $debug = "... ".$this->TableName." refreshing ($action)<br>";
	  #echo $debug;

	  # update the table's where clause
	  $temp = explode("=",$this->WhereSQL);
	  $field = $temp[0];
	  $this->WhereSQL = $field."="." '".$record."'";

	  foreach($this->FieldList as $field) {
		 unset($GLOBALS[$field]);
	  }

	  $this->Get($action);
   }


#==================================================================================================
   function Delete ($fieldname) {          # Deletes field from table list

	  # check that field actually exist
	  if (in_array($fieldname,$this->FieldList)) {

		 # Delete field from fieldlist
		 $temparray = array_flip($this->FieldList);
		 $i = $temparray[$fieldname];
		 $this->FieldList[$i] = "";
		 cleanse($this->FieldList);
		 }
	  }


#==================================================================================================
function Kill ($code="0") {               # Clear the table's field and/or key list(s)

	  $debug = "...killing ".$this->TableName."(code $code)";
	  #echo $debug;

	  switch ($code) {

		 case (0) :  # Reset Field list

			$this->FieldList = array();
			break;

		 case (1) :  # Reset Table list

			$this->Keys = array();
			break;

		 case (2) :  # Reset both Table and Field lists

			$this->TableList = array();
			$this->Keys = array();
			break;
		 }
	  }


#==================================================================================================
   function Submit (&$form,$action) {     # Update each field's value from user input, compile sql query and execute

   		if (isset($GLOBALS['addCheckPrev']) && isset($_POST['addcheck'])){
   			if($GLOBALS['bypassAddCheck'] == false && $GLOBALS['addCheckPrev'] != $_POST['addcheck'] && $action != 3 && $action != 4) {
				$GLOBALS['addCheckFailed'] = true;
				return;
			}
   		}



	  $db = $this->db;
	  $actionlist = array("2","3","4");

			###############################
			# Phase 1: Assemble the query #
			###############################

	  $string = "";
	  switch ($action) {

		 case (2):      # generate an insert query from the fields in the table

			$this->FieldList = array_unique($this->FieldList);
			cleanse($this->FieldList);
			$strstart = "Insert into ";
			$strtemp = "";
			$body = "(";
			$bodyend = ") values (";
			$bodyend2 = ")";
			$ac0 = "0"; $ac1 = "0";

			# generate a bit of the sql body for each field
			for ($p = 0; $p < sizeof($this->FieldList); $p++){
				$temp = $this->FieldList[$p];
				$GLOBALS[$temp]->GetValue();
				$field = $GLOBALS[$temp]->Varname;
				$value = $GLOBALS[$temp]->Value;
				$ixfield = $this->Table."_ix";

				if ($field != $ixfield) {
					if (in_array($temp,$form->ValidateList)) {
						$validate = "1";
					}
					else { $validate = "0"; }

					if ($value != "" || $validate != "1") {
						$body .= $this->AddSQLBody($field,$value,$ac0,"0");
						$ac0++;
						$bodyend .= $this->AddSQLBody($field,$value,$ac1,"1");
						$ac1++;
					}
					else {
						if ($value == "") { $erval = "Nothing!"; }
						else { $erval = $value; }
						$form->error .= "Invalid <b>value</b> ($erval) for <b>field</b>: $field! in table ".$this->table.".<br>\n";
					}
				}
			}
			$bodyend .= $bodyend2;
			$body .= $bodyend;

			# append all the bits and pieces into the final sql string
			$string .= $strstart;
			$string .= $this->Table;
			$string .= " " . $strtemp;
			$string .= $body;
			$chngcount = 1;
			break;

		 case (3):      # generate an update query from the fields and clauses in the table

			 $this->FieldList = array_unique($this->FieldList);
			 cleanse($this->FieldList);
			 $strstart = "Update ";
			 $strtemp = " set ";
			 $bodyend = "";
			 $bodyend2 = "";
			 $body = "";
			 $ac0 = "0"; $ac1 = "0"; $ac2 = "0";
			 $keycount = 0;
			 $chngcount = 0;

			 # generate a bit of the sql body for each field
			 for ($p = 0; $p < sizeof($this->FieldList); $p++){
				 $temp = $this->FieldList[$p];
				 $GLOBALS[$temp]->GetValue();
				 $chng = $GLOBALS[$temp]->Changed;
				 if ($chng == "1") {
					 $field = $GLOBALS[$temp]->Varname;
					 $value = trim($GLOBALS[$temp]->Value);

					 if (in_array($temp,$form->ValidateList)) {
						 $validate = "1";
					 }
					 else { $validate = "0"; }

					 if ($value != ""  || $validate != "1") {
						 if (in_array($temp,$this->Keys)) {
							 $keycount++;
						 }
						 else {
							 $chngcount++;
							 $body .= $this->AddSQLBody($field,$value,$ac2,"2");
							 $ac2++;
						 }
					 }
					 else {
						 if ($value == "") { $erval = "Nothing!"; }
						 else { $erval = $value; }
						 $form->error .= "Invalid <b>value</b> ($erval) for <b>field</b>: $field! in table ".$this->TableName.".<br>\n";
					 }
				 }
			 }
			 $bodyend .= $bodyend2;
			 $body .= $bodyend;

			 # if the wheresql exists add it to the string
			 if ($this->WhereSQL != "") {
				 $stringend = " where ".$this->WhereSQL;

				 # if the andsql exists add it to the string
				 if ($this->AndSQL != "") {
					 $stringend .= " and ".$this->AndSQL;
				 }
			 }
			 else {

				 # if the andsql exists add it to the string
				 if ($this->AndSQL != "") {
					 $stringend .= " and ".$this->AndSQL;
				 }
				 else {
					 $stringend = "";
				 }
			 }

			 # append all the bits and pieces into the final sql string
			 $string .= $strstart;
			 $string .= $this->Table;
			 $string .= " " . $strtemp;
			 $string .= $body;
			 $string .= $stringend;
			 break;

		 case (4):      # generate a delete query from the keyfield and clauses in the table

			 $ixfieldpos = array_search($this->TableName."_".$this->Table."_ix",$this->FieldList);
			 $keyfield = $this->FieldList[0];
			 $keyname = $GLOBALS[$keyfield]->Varname;
			 $record = isset($GLOBALS['delrecord'])?$GLOBALS['delrecord']:"";
			 $spec = 0;
			 if ($ixfieldpos !== false) {
				 $keyfield = $this->FieldList[$ixfieldpos];
				 $keyname = $GLOBALS[$keyfield]->Varname;
			 } elseif (strpos($keyname,"_db") !== false) {
				 $keyfield2 = $this->FieldList[1];
				 $keyname2 = $GLOBALS[$keyfield2]->Varname;
				 if (strpos($keyname2,"_id") !== false) {
					 $keyname = "concat(".$keyname.",".$keyname2.")";
					 $spec = "1";
				 }
			 }

			 $string = "Delete from ".$this->Table." where $keyname = '$record'";

			 # verify the clauses from the table
			 if ($this->WhereSQL != "" && (strpos($this->WhereSQL,$keyname) === false)) {
				 # if wheresql exists and != keyfield, add to string
				 $whereSQL = " where ".$this->WhereSQL;
				 if ($this->AndSQL != "" && (strpos($this->AndSQL,$keyname) === false)) {
					 # if andsql exists and != keyfield, add to string
					 $andSQL = " and ".$this->AndSQL;
				 }
				 else { $andSQL = ""; }
			 }
			 else {
				 $whereSQL = "";
				 if ($this->AndSQL != "" && (strpos($this->AndSQL,$keyname) === false)) {
					 # if andsql exists and != keyfield, add to string
					 $andSQL = " where ".$this->AndSQL;
				 }
				 else { $andSQL = ""; }
			 }

			 # add the clauses to the query
			 if ($spec != "1") {
				 $string .= $whereSQL.$andSQL;
			 }

			 # clear the autovar;
			 if(isset($GLOBALS['autovar'])) {
				 $varna = $GLOBALS['autovar'];
				 $_SERVER['argv'][$varna] = "";
			 }

			 # remove record from form's recordlist
			 $formname = $this->FormName;
			 $recordlist = $GLOBALS[$formname]->RecordList;
			 if (in_array($record,$recordlist)) {
				 for ($l = 0; $l < sizeof($recordlist); $l++) {
					 if ($recordlist[$l] == $record) {
						 $recordlist[$l] = "";
					 }
				 }
			 }
			 cleanse($recordlist);
			 $GLOBALS[$formname]->RecordList = $recordlist;

			 $chngcount = 1;
			 break;

			}

			##############################
			# Phase 2: Execute the query #
			##############################

	  # now that we have a sql query, lets determine if we can execute it
	  if ($form->error == "" && in_array($action,$actionlist)) {

		 #echo $string;

	  	$keycount = (isset($keycount) ? $keycount : 0);

		 # if it's succesfully executed update the auto increment id field!
		 if ($keycount != sizeof($this->FieldList) && $chngcount > "0") {
			if ($GLOBALS['lDB']->put($string)) {
			   $temp = $this->FieldList[0];
			   #echo sizeof($this->Keys);
			   if ($action == "2") {
				  if ($GLOBALS[$temp]->Extra != "auto_increment" && $GLOBALS[$temp]->IsKey == "1") {
					 $upvar = $GLOBALS[$temp]->Value;
					 }
				  else {
					 $upvar = $GLOBALS['lDB']->insert_id;
					 }
				  if (strpos($temp,"_db") !== false) {
					 $temp2 = $this->FieldList[1];
					 if (strpos($temp2,"_id") !== false) {
						if ($GLOBALS[$temp2]->Extra != "auto_increment" && $GLOBALS[$temp2]->IsKey == "1") {
						   $upvar .= $GLOBALS[$temp2]->Value;
						   }
						else {
						   $upvar .= $GLOBALS['lDB']->insert_id;
						   }
						}
					 }

				  $GLOBALS[$temp]->UpdateVar($upvar);
				  $GLOBALS[$temp]->GetValue();
				  $temname = $GLOBALS[$temp]->Varname;
			      if(isset($GLOBALS['autovar'])) {
				  	$varna = $GLOBALS['autovar'];
					$_SERVER['argv'][$varna] = $upvar;
				  }
				  $GLOBALS['autoid'] = $upvar;
				  }
			   return True;
			   }
			else {
			   if ($action != "6") {

				  # otherwise add the db error to the form's error output
				  $form->error .=  mysqli_error($GLOBALS['lDB']->conn);
				  return False;
				  }
			   else {
				  return True;
				  }
			   }
			}
		 else {
			return True;
			}
		 }
	  else {
		 return False;
		 }
	  }


#==================================================================================================
   function AddSQLBody($field,$value,$ac,$action) {         # Modular function used when compiling SQL statement
	   global $lDB;

	  # don't add a comma if it's the first field!
	  $out = "";
	  if ($ac != "0") { $out .= ","; }
	  else { $out .= ""; }

	  # switch on newa(0), newb(1) or update(2) action
	  switch ($action) {

		 case 0:  # New record first part
			$out .= "$field";
			break;

		 case 1:  # New record last part
			$out .= " '".mysqli_real_escape_string($lDB->conn,$value)."'";
			break;

		 case 2:  # Update record
			$out .= " $field = '".mysqli_real_escape_string($lDB->conn,$value)."'";
			break;
		 }

	  return $out;
	  }

   }     # End Class
#==================================================================================================
