<?php

/**
 * class.newrelic.php - Class to manage new relic customized instrumentation
 **/

class NewRelic {

    protected $app; //holds an instance of the app name
    protected $extension; //holds an instance of the new relic extension
    protected $module; //holds an instance of module to be loaded
    protected $license; //holds an instance of license key, if using a different one from the one one server

    public function __construct($extension = "", $module = "", $license = ""){
        $this->extension = ($extension != "" ) ? $extension: "newrelic";
        $this->module = ($module != "" ) ? $module : "appname";
        $this->license = ($license != "" ) ? $license : "";
        $this->app = (extension_loaded($this->extension)) ? ini_get($this->extension.$this->module) : "";
    }

    public function record_transaction($title){
        $recorded = false;
        if (extension_loaded($this->extension)) {       // ensure that the agent is available
            $this->stop_transaction();
            if($this->license != "") { // start recording a new transaction
                newrelic_start_transaction($this->app, $this->license);
            }
            else {
                newrelic_start_transaction($this->app);
            }
            newrelic_name_transaction($title);
            $recorded =  true;
        }

        return $recorded;
    }

    public function stop_transaction(){
        $stopped = false;
        if (extension_loaded($this->extension)) {
            newrelic_end_transaction();
            $stopped =  true;
        }

        return $stopped;
    }
}